/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.switchyard.tools.ui.debug.SwitchYardStepHandler;

public class SwitchYardStepCommandHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        IStackFrame stackFrame = (IStackFrame)DebugPlugin.getAdapter((Object)adaptable, IStackFrame.class);
        if (stackFrame == null || !stackFrame.isSuspended()) {
            return null;
        }
        IThread thread = stackFrame.getThread();
        if (thread instanceof IJavaThread) {
            try {
                new SwitchYardStepHandler((IJavaThread)thread).step();
            }
            catch (CoreException e) {
                throw new ExecutionException("Error initializing breakpoints for step.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        IStackFrame stackFrame = (IStackFrame)DebugPlugin.getAdapter((Object)adaptable, IStackFrame.class);
        return stackFrame != null && stackFrame instanceof IJavaStackFrame && stackFrame.isSuspended() && this.switchYardCode(stackFrame);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean switchYardCode(IStackFrame stackFrame) {
        try {
            boolean hasSwitchYardCode = false;
            IStackFrame[] iStackFrameArray = stackFrame.getThread().getStackFrames();
            int n = iStackFrameArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return hasSwitchYardCode;
                }
                IStackFrame frame = iStackFrameArray[n2];
                String typeName = ((IJavaStackFrame)frame).getReferenceType().getName();
                if (typeName != null) {
                    if ("org.switchyard.bus.camel.processors.ConsumerCallbackProcessor".equals(typeName)) {
                        return false;
                    }
                    if (typeName.startsWith("org.switchyard.")) {
                        hasSwitchYardCode = true;
                    }
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            return false;
        }
    }
}

