/*************************************************************************************
 * Copyright (c) 2013 Red Hat, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     JBoss by Red Hat - Initial implementation.
 ************************************************************************************/
package org.switchyard.tools.ui.i18n;

import org.eclipse.osgi.util.NLS;

/**
 * Messages class for processing localized messages.
 *
 */
public final class Messages extends NLS {
    
    /**
     * Bundle name of the actual messages.properties file.
     */
    private static final String BUNDLE_NAME = "org.switchyard.tools.ui.i18n.messages"; //$NON-NLS-1$

    public static String AbstractSwitchYardProjectOperation_exceptionMessage_errorUpdatingSYXML;

    public static String AbstractSwitchYardProjectOperation_operationLabel_creatingBeansXMLFile;

    public static String AbstractSwitchYardProjectOperation_operationLabel_creatingSYXMLFile;

    public static String AbstractSwitchYardProjectOperation_statusLabel_errorsUpdatingProjectConfig;

    public static String AbstractSwitchYardProjectOperation_statusMessage_unableToCreateBeansXML;

    public static String AbstractSwitchYardProjectOperation_taskLabel_creatingBeansXMLFiles;

    public static String AbstractSwitchYardProjectOperation_taskLabel_readingPOM;

    public static String AbstractSwitchYardProjectOperation_taskLabel_readingSYXML;

    public static String AbstractSwitchYardProjectOperation_taskLabel_updatingPOMFile;

    public static String AbstractSwitchYardProjectOperation_taskLabel_updatingSYXML;

    public static String AbstractSwitchYardProjectOperation_taskLabel_updatingSYXMLFile;

    public static String AbstractSwitchYardProjectOperation_taskLabel_writingUpdatedSYXML;

    public static String ArtifactDetailsWizardPage__checkboxLabelDownloadArtifactToWorkspace;

    public static String ArtifactDetailsWizardPage_errorMessage_mustSpecifyName;

    public static String ArtifactDetailsWizardPage_errorMessage_mustSpecifyURL;

    public static String ArtifactDetailsWizardPage_errorMessage_nameAlreadyExists;

    public static String ArtifactDetailsWizardPage_errorMessage_urlInvalid;

    public static String ArtifactDetailsWizardPage_labelArtifactName;

    public static String ArtifactDetailsWizardPage_labelArtifactURL;

    public static String ArtifactDetailsWizardPage_wizardPageDescription;

    public static String ArtifactDetailsWizardPage_wizardPageTitle;

    public static String ArtifactModelPropertySource_propertyDescriptor_name;

    public static String ArtifactModelPropertySource_propertyDescriptor_url;

    public static String ArtifactModelPropertySource_propertyDescriptorDescription_name;

    public static String ArtifactModelPropertySource_propertyDescriptorDescription_url;

    public static String ArtifactPropertySource_propertyDescriptor_artifact;

    public static String ArtifactPropertySource_propertyDescriptorDescription_artifact;

    public static String ArtifactsNode_labelArtifacts;

    public static String BeanComponentImplementationtModelPropertySource_propertyDescriptor_class;

    public static String BeanComponentImplementationtModelPropertySource_propertyDescriptorDescription_class;

    public static String BindingModelPropertySource_propertyDescriptor_bindingType;

    public static String BindingModelPropertySource_propertyDescriptor_contextMapper;

    public static String BindingModelPropertySource_propertyDescriptor_messageComposer;

    public static String BindingModelPropertySource_propertyDescriptor_operationSelector;

    public static String BindingModelPropertySource_propertyDescriptorCategory_general;

    public static String BindingModelPropertySource_propertyDescriptorDescription_bindingType;

    public static String BindingModelPropertySource_propertyDescriptorDescription_contextMapper;

    public static String BindingModelPropertySource_propertyDescriptorDescription_messageComposer;

    public static String BPELComponentImplementationtModelPropertySource_propertyDescriptor_bpelProcess;

    public static String BPELComponentImplementationtModelPropertySource_propertyDescriptorDescriptor_bpelProcess;

    public static String BPMComponentImplementationtModelPropertySource_1;

    public static String BPMComponentImplementationtModelPropertySource_propertyDescriptor_bpmProcessDefinition;

    public static String BPMComponentImplementationtModelPropertySource_propertyDescriptor_bpmProcessID;

    public static String BPMComponentImplementationtModelPropertySource_propertyDescriptorDescription_bpmProcessDefinition;

    public static String BPMComponentImplementationtModelPropertySource_propertyDescriptorDescription_bpmProcessID;

    public static String CamelComponentImplementationtModelPropertySource_propertyDescriptor_javaClass;

    public static String CamelComponentImplementationtModelPropertySource_propertyDescriptor_route;

    public static String CamelComponentImplementationtModelPropertySource_propertyDescriptorDescription_javaClass;

    public static String CamelComponentImplementationtModelPropertySource_propertyDescriptorDescription_route;

    public static String ClasspathResourceSelectionDialog_dialogTitle;

    public static String ClojureComponentImplementationtModelPropertySource_propertyDescriptor_clojureScriptFile;

    public static String ClojureComponentImplementationtModelPropertySource_propertyDescriptorDescription_clojureScriptFile;

    public static String ComponentModelPropertySource_propertyDescriptor_implementation;

    public static String ComponentModelPropertySource_propertyDescriptor_name;

    public static String ComponentModelPropertySource_propertyDescriptorDescription_implementation;

    public static String ComponentModelPropertySource_propertyDescriptorDescription_name;

    public static String ComponentPropertySource_propertyDescriptor_component;

    public static String ComponentPropertySource_propertyDescriptorDescription_component;

    public static String ComponentReferenceModelPropertySource_propertyDescriptor_interface;

    public static String ComponentReferenceModelPropertySource_propertyDescriptor_name;

    public static String ComponentReferenceModelPropertySource_propertyDescriptor_policyRequirements;

    public static String ComponentReferenceModelPropertySource_propertyDescriptorDescription_interface;

    public static String ComponentReferenceModelPropertySource_propertyDescriptorDescription_name;

    public static String ComponentReferenceModelPropertySource_propertyDescriptorDescription_policyRequirements;

    public static String ComponentReferencePropertySource_propertyDescriptor_syComponentReference;

    public static String ComponentReferencePropertySource_propertyDescriptorDescription_syComponentReference;

    public static String ComponentServiceModelPropertySource_propertyDescriptor_interface;

    public static String ComponentServiceModelPropertySource_propertyDescriptor_name;

    public static String ComponentServiceModelPropertySource_propertyDescriptor_policyRequirements;

    public static String ComponentServiceModelPropertySource_propertyDescriptorDescription_interface;

    public static String ComponentServiceModelPropertySource_propertyDescriptorDescription_name;

    public static String ComponentServiceModelPropertySource_propertyDescriptorDescription_policyRequirements;

    public static String ComponentServicePropertySource_propertyDescriptor_componentService;

    public static String ComponentServicePropertySource_propertyDescriptorDescription_componentService;

    public static String ComponentsNode_labelComponents;

    public static String CompositeReferenceModelPropertySource_propertyDescriptor_interface;

    public static String CompositeReferenceModelPropertySource_propertyDescriptor_name;

    public static String CompositeReferenceModelPropertySource_propertyDescriptor_promotedReference;

    public static String CompositeReferenceModelPropertySource_propertyDescriptorDescription_interface;

    public static String CompositeReferenceModelPropertySource_propertyDescriptorDescription_name;

    public static String CompositeReferenceModelPropertySource_propertyDescriptorDescription_promotedReference;

    public static String CompositeServiceModelPropertySource_propertyDescriptor_interface;

    public static String CompositeServiceModelPropertySource_propertyDescriptor_name;

    public static String CompositeServiceModelPropertySource_propertyDescriptor_promotedService;

    public static String CompositeServiceModelPropertySource_propertyDescriptorDescription_interface;

    public static String CompositeServiceModelPropertySource_propertyDescriptorDescription_name;

    public static String CompositeServiceModelPropertySource_propertyDescriptorDescription_promotedService;

    public static String ContextMapperModelPropertySource_propertyDescriptor_class;

    public static String ContextMapperModelPropertySource_propertyDescriptor_excludesNS;

    public static String ContextMapperModelPropertySource_propertyDescriptor_exludes;

    public static String ContextMapperModelPropertySource_propertyDescriptor_includes;

    public static String ContextMapperModelPropertySource_propertyDescriptor_includesNS;

    public static String ContextMapperModelPropertySource_propertyDescriptorDescription_class;

    public static String ContextMapperModelPropertySource_propertyDescriptorDescription_excludes;

    public static String ContextMapperModelPropertySource_propertyDescriptorDescription_excludesNS;

    public static String ContextMapperModelPropertySource_propertyDescriptorDescription_includes;

    public static String ContextMapperModelPropertySource_propertyDescriptorDescription_includesNS;

    public static String ContractControl_errorContractTypeMustExtendContract;

    public static String ContractControl_labelServiceName;

    public static String ContractControl_validateMessageMustSpecifyName;

    public static String ConvertWarToJarAction_errorDialog_message_errorInstallingSYFacet;

    public static String ConvertWarToJarAction_errorDialog_title_errorInstallingSYFacet;

    public static String ConvertWarToJarAction_errorMessage_errorInitializingSYFacet;

    public static String ConvertWarToJarAction_errorMesssage_ErrorInPOMForSYProject;

    public static String ConvertWarToJarAction_messageDialog_message_AddSYCapabilities;

    public static String ConvertWarToJarAction_messageDialog_message_AddSYCapabilitiesAndFacets;

    public static String ConvertWarToJarAction_messageDialog_title_AddSYCapabilities;

    public static String ConvertWarToJarAction_messageDialog_title_AddSYCapabilitiesAndFacets;

    public static String CreateArtifactReferenceOperation_exceptionMessage_errorUpdatingSYXMLFile;

    public static String CreateArtifactReferenceOperation_exceptionMessage_errorWhileDownloadingArtifact;

    public static String CreateArtifactReferenceOperation_operationLabel_creatingSYXMLFile;

    public static String CreateArtifactReferenceOperation_taskLabel_addingArtifactReferenceToProject;

    public static String CreateArtifactReferenceOperation_taskLabel_downloadingArtifactResource;

    public static String CreateArtifactReferenceOperation_taskLabel_loadingSYXMLFile;

    public static String CreateArtifactReferenceOperation_taskLabel_updatingSYXMLFile;

    public static String CreateArtifactReferenceOperation_taskLabel_writingUpdatedSYXML;

    public static String CreateBeanServiceOperation_exceptionMessage_errorWhileCreatingServiceTestClass;

    public static String CreateBeanServiceOperation_taskLabel_creatingServiceImplementation;

    public static String CreateBeanServiceOperation_taskLabel_creatingServiceTest;

    public static String CreateBeanServiceOperation_wizardPageDescription_creatingNewBeanService;

    public static String CreateJavaFromWSDLOperation_statusLabel_javaGeneratedSuccessfully;

    public static String CreateJavaFromWSDLOperation_statusLabel_javaGenerationFailed;

    public static String CreateJavaFromWSDLOperation_statusLabel_refreshedOutputFolder;

    public static String CreateJavaFromWSDLOperation_statusLabel_wsdl2JavaOperation;

    public static String CreateServiceTestOperation_subtaskLabel_creatingServiceImpl;

    public static String CreateServiceTestOperation_wizardPageText_creatingNewSYServiceTest;

    public static String CreateSwitchYardProjectOperation_CreatingFeaturesXML;

    public static String CreateSwitchYardProjectOperation_ErrorCreatingFeaturesXML;

    public static String CreateSwitchYardProjectOperation_errorMessage_errorAttachingTargetRuntimeToProject;

    public static String CreateSwitchYardProjectOperation_exceptionMessage_errorCreatingSYProject;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainResourceFolder;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainSourceFolder;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingDefaultMainTestSourceFolder;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingDefaultTestResourceFolder;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingPOM;

    public static String CreateSwitchYardProjectOperation_operationLabel_creatingSYXML;

    public static String CreateSwitchYardProjectOperation_operationLabel_newSYProject;

    public static String CreateSwitchYardProjectOperation_statusLabel_errorsCreatingProject;

    public static String CreateSwitchYardProjectOperation_statusMessage_errorCreatingDefaultFolders;

    public static String CreateSwitchYardProjectOperation_statusMessage_errorCreatingPOM;

    public static String CreateSwitchYardProjectOperation_statusMessage_errorCreatingSYXML;

    public static String CreateSwitchYardProjectOperation_statusMessage_errorUpdatingMavenProjectConfig;

    public static String CreateSwitchYardProjectOperation_taskLabel_attachingTargetRuntimeToProject;

    public static String CreateSwitchYardProjectOperation_taskLabel_creatingDefaultFolders;

    public static String CreateSwitchYardProjectOperation_taskLabel_creatingPOM;

    public static String CreateSwitchYardProjectOperation_taskLabel_creatingSYProject;

    public static String CreateSwitchYardProjectOperation_taskLabel_creatingSYXMLFile;

    public static String CreateSwitchYardProjectOperation_taskLabel_updatingMavenProjectConfig;

    public static String CreateWSDLFromJavaOperation_exceptionMessage_errorWritingWSDL;

    public static String CreateWSDLFromJavaOperation_exceptionMessage_wsdlGenerationFailed;

    public static String CreateWSDLFromJavaOperation_operationLabel_writingSchemaFile;

    public static String CreateWSDLFromJavaOperation_operationLabel_writingWSDLFile;

    public static String CreateWSDLFromJavaOperation_statusLabel_errorWritingSchemaFiles;

    public static String CreateWSDLFromJavaOperation_statusLabel_java2WSDLOperation;

    public static String CreateWSDLFromJavaOperation_statusMessage_errorWritingImportedSchema;

    public static String CreateWSDLFromJavaOperation_statusMessage_schemaWrittenSuccessfully;

    public static String CreateWSDLFromJavaOperation_statusMessage_wsdlGeneratedSuccessfully;

    public static String CreateWSDLFromJavaOperation_statusMessage_wsdlWrittenSuccessfully;

    public static String ESBInterfaceControlAdapter_statusMessage_specifyingFaultTypeRequiresOutputType;

    public static String ESBInterfaceControlAdapter_statusMessage_specifyInputType;

    public static String ESBInterfaceInputDialog_FaultTypeLabel;

    public static String ESBInterfaceInputDialog_FaultTypeRequiresOutputTypeMessage;

    public static String ESBInterfaceInputDialog_InputTypeLabel;

    public static String ESBInterfaceInputDialog_InputTypeRequiredMessage;

    public static String ESBInterfaceInputDialog_Message;

    public static String ESBInterfaceInputDialog_OutputTypeLabel;

    public static String ESBInterfaceInputDialog_Title;

    public static String ESBInterfaceInputDialog_WindowTitle;

    public static String InterfaceControl_BrowseButtonLabel;

    public static String InterfaceControl_ESBRadioLabel;

    public static String InterfaceControl_InterfaceLinkLabel;

    public static String InterfaceControl_InterfaceTypeRequiredMessage;

    public static String InterfaceControl_JavaRadioLabel;

    public static String InterfaceControl_Label;

    public static String InterfaceControl_WSDLRadioLabel;

    public static String InterfaceModelPropertySource_propertyDescriptor_interface;

    public static String InterfaceModelPropertySource_propertyDescriptorDescription_interface;

    public static String Java2WSDLOptionsWizardPage_checkboxUseImportsForGeneratedSchemas;

    public static String Java2WSDLOptionsWizardPage_checkboxUseWrappedMessages;

    public static String Java2WSDLOptionsWizardPage_errorMessage_invalidColonInServiceName;

    public static String Java2WSDLOptionsWizardPage_errorMessage_invalidEndpoint;

    public static String Java2WSDLOptionsWizardPage_errorMessage_invalidTargetNamespace;

    public static String Java2WSDLOptionsWizardPage_errorMessage_mustSelectServiceInterface;

    public static String Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyEndpointURI;

    public static String Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyServiceName;

    public static String Java2WSDLOptionsWizardPage_errorMessage_mustSpecifyTargetNamespace;

    public static String Java2WSDLOptionsWizardPage_errorMessage_serviceNameMustStartWithUnderscoreOrLetter;

    public static String Java2WSDLOptionsWizardPage_labelEndpointURI;

    public static String Java2WSDLOptionsWizardPage_labelSelectType;

    public static String Java2WSDLOptionsWizardPage_labelServiceInterface;

    public static String Java2WSDLOptionsWizardPage_labelServiceName;

    public static String Java2WSDLOptionsWizardPage_labelTargetNamespace;

    public static String Java2WSDLOptionsWizardPage_wizardPageDescription;

    public static String Java2WSDLOptionsWizardPage_wizardPageTitle;

    public static String Java2WSDLWizard_errorMessage_errorWhileGeneratingSchemaFiles;

    public static String Java2WSDLWizard_errorMessage_errorWhileGeneratingWSDL;

    public static String Java2WSDLWizard_wizardTitle;

    public static String Java2WSDLWizard_wsdlFilePageDescription;

    public static String Java2WSDLWizard_wsdlFilePageTitle;

    public static String JavaInterfaceControlAdapter_statusMessage_SelectedTypeNotOnClasspath;

    public static String JavaInterfaceControlAdapter_statusMessage_selectJavaInterface;

    public static String NewArtifactReferenceWizard_errorMessage_errorAddingArtifactReference;

    public static String NewArtifactReferenceWizard_logMessage_errorAddingArtifactReference;

    public static String NewBeanServiceClassWizardPage_buttonLabelCreateTestClass;

    public static String NewBeanServiceClassWizardPage_wizardPageDescription;

    public static String NewBeanServiceClassWizardPage_wizardPageTitle;

    public static String NewBeanServiceWizard_errorMessage_errorCreatingBeanService;

    public static String NewBeanServiceWizard_logMessage_errorCreatingBeanServiceClass;

    public static String NewBeanServiceWizard_logMessage_errorOpeningBeanServiceSource;

    public static String NewBeanServiceWizard_windowTitle;

    public static String NewGenericArtifactReferenceWizard_wizardTitle;

    public static String NewServiceTestClassWizard_errorMessage_errorCreatingTestClass;

    public static String NewServiceTestClassWizard_logMessage_errorCreatingTestClass;

    public static String NewServiceTestClassWizard_logMessage_errorOpeningBeanServiceSource;

    public static String NewServiceTestClassWizard_wizardTitle;

    public static String NewServiceTestClassWizardPage_16;

    public static String NewServiceTestClassWizardPage_exceptionMessage_errorResolvingServiceInterface;

    public static String NewServiceTestClassWizardPage_labelService;

    public static String NewServiceTestClassWizardPage_labelTestMixIns;

    public static String NewServiceTestClassWizardPage_statusMessage_classNameMustEndWithTest;

    public static String NewServiceTestClassWizardPage_taskName_creatingAnnotation;

    public static String NewServiceTestClassWizardPage_warningMessage_sourceFolderNotConfiguredForTestSource;

    public static String NewServiceTestClassWizardPage_warningStatus_noServiceSpecifiedStubWillBeCreated;

    public static String NewServiceTestClassWizardPage_warningStatus_selectedServiceDoesNotDefineInterface;

    public static String NewServiceTestClassWizardPage_wizardPageDescription;

    public static String NewServiceTestClassWizardPage_wizardPageTitle;

    public static String NewSwitchYardProjectWizard_confirmText_cannotResolveSwitchYardDependencies;

    public static String NewSwitchYardProjectWizard_confirmTitle_cannotResolveSwitchYardDependencies;

    public static String NewSwitchYardProjectWizard_errorMessage_errorCreatingProject;

    public static String NewSwitchYardProjectWizard_errorMessage_noSwitchYardVersionSpecified;

    public static String NewSwitchYardProjectWizard_errorTitle_noVersionSpecified;

    public static String NewSwitchYardProjectWizard_logError_errorCreatingSYProject;

    public static String NewSwitchYardProjectWizard_logError_errorOpeningSYXML;

    public static String NewSwitchYardProjectWizard_projectPageDescription;

    public static String NewSwitchYardProjectWizard_projectPageTitle;

    public static String NewSwitchYardProjectWizard_taskLabel_resolvingSwitchYardArtifacts;

    public static String NewSwitchYardProjectWizard_windowTitle;

    public static String NewWSDLFileWizard_wizardTitle;

    public static String ProjectConfigurationWizardPage_18;

    public static String ProjectConfigurationWizardPage_errorMessage_pleaseSpecifySwitchYardVersion;

    public static String ProjectConfigurationWizardPage_labelArtifactID;

    public static String ProjectConfigurationWizardPage_labelGroupID;

    public static String ProjectConfigurationWizardPage_labelPackageName;

    public static String ProjectConfigurationWizardPage_labelTNS;

    public static String ProjectConfigurationWizardPage_OSGIBundleCheckbox;

    public static String ProjectConfigurationWizardPage_wizardPageDescription;

    public static String ProjectConfigurationWizardPage_wizardPageTitle;

    public static String ReferencePropertySource_propertyDescriptor_syReference;

    public static String ReferencePropertySource_propertyDescriptorDescription_syReference;

    public static String ReferencesNode_labelReferences;

    public static String RepositoryArtifactReferenceWizard_pageTitle;

    public static String RepositoryArtifactReferenceWizard_windowTitle;

    public static String RepositoryArtifactReferenceWizard_wizardPageTitle;

    public static String RulesComponentImplementationtModelPropertySource_propertyDescriptor_resources;

    public static String RulesComponentImplementationtModelPropertySource_propertyDescriptorDescription_resources;

    public static String ServiceGatewayPropertySource_propertyDescriptor_binding;

    public static String ServiceGatewayPropertySource_propertyDescriptorDescription_binding;

    public static String ServicePropertySource_propertyDescriptor_syService;

    public static String ServicePropertySource_propertyDescriptorDescription_syService;

    public static String ServicesNode_labelServices;

    public static String SOAPBindingModelPropertySource_propertyDescriptor_contextPath;

    public static String SOAPBindingModelPropertySource_propertyDescriptor_socketAddress;

    public static String SOAPBindingModelPropertySource_propertyDescriptor_wsdlFile;

    public static String SOAPBindingModelPropertySource_propertyDescriptor_wsdlPort;

    public static String SOAPBindingModelPropertySource_propertyDescriptorCategory_soap;

    public static String SOAPBindingModelPropertySource_propertyDescriptorDescription_contextPath;

    public static String SOAPBindingModelPropertySource_propertyDescriptorDescription_socketAddress;

    public static String SOAPBindingModelPropertySource_propertyDescriptorDescription_wsdlFile;

    public static String SOAPBindingModelPropertySource_propertyDescriptorDescription_wsdlPort;

    public static String SwitchYardBasicPresetFactory_presetDescription_basicSYApplication;

    public static String SwitchYardBasicPresetFactory_presetTitle_basicSYApplication;

    public static String SwitchYardComponentExtensionManager_DuplicateIDStatus;

    public static String SwitchYardComponentExtensionManager_InvalidCategoryStatus;

    public static String SwitchYardComponentExtensionManager_InvalidDependencyStatus;

    public static String SwitchYardComponentExtensionManager_InvalidElementStatus;

    public static String SwitchYardComponentExtensionManager_InvalidIDStatus;

    public static String SwitchYardComponentExtensionManager_MultipleArtifactIDsStatus;

    public static String SwitchYardComponentExtensionManager_MultipleGroupIDsFoundStatus;

    public static String SwitchYardComponentExtensionManager_MultipleScopesStatus;

    public static String SwitchYardExplorerContentProvider_jobMessage_RefreshingSYProjectConfig;

    public static String SwitchYardExplorerLabelProvider_AppArtifactsNode;

    public static String SwitchYardExplorerLabelProvider_AppComponentsNode;

    public static String SwitchYardExplorerLabelProvider_ApplicationNode;

    public static String SwitchYardExplorerLabelProvider_AppReferencesNode;

    public static String SwitchYardExplorerLabelProvider_AppServicesNode;

    public static String SwitchYardExplorerLabelProvider_ArtifactReferenceNode;

    public static String SwitchYardExplorerLabelProvider_BindingNode;

    public static String SwitchYardExplorerLabelProvider_ComponentNode;

    public static String SwitchYardExplorerLabelProvider_ComponentReferenceNode;

    public static String SwitchYardExplorerLabelProvider_ComponentServiceNode;

    public static String SwitchYardExplorerLabelProvider_ReferenceNode;

    public static String SwitchYardExplorerLabelProvider_ServiceNode;

    public static String SwitchYardExplorerLabelProvider_SwitchYardRootNode;

    public static String SwitchYardExplorerLabelProvider_UnnamedNode;

    public static String SwitchYardFacetInstallActionDelegate_errorMessage_notAMavenProject;

    public static String SwitchYardFacetInstallActionDelegate_exceptionMessage_cannotResolveSYProject;

    public static String SwitchYardFacetInstallActionDelegate_operationLabel_installingSYFacet;

    public static String SwitchYardFacetInstallConfigFactory_statusMessage_MustSpecifySYVersion;

    public static String SwitchYardFacetInstallWizardPage_pageDescription_switchYard;

    public static String SwitchYardFacetInstallWizardPage_pageName_switchYard;

    public static String SwitchYardFacetInstallWizardPage_pageTitle_switchYard;

    public static String SwitchYardModelPropertySource_propertyDescriptor_name;

    public static String SwitchYardModelPropertySource_propertyDescriptor_tns;

    public static String SwitchYardModelPropertySource_propertyDescriptorDescription_name;

    public static String SwitchYardModelPropertySource_propertyDescriptorDescription_tns;

    /**
     * Exception message when the Interface Type is Unsupported.
     */
    public static String SwitchYardModelUtils_InterfaceClassNotFound;
    
    public static String SwitchYardModelUtils_InterfaceTypeUnsupportedException;
    
    public static String SwitchYardProject_errorMessage_exceptionWhileLodingSYFile;

    public static String SwitchYardProject_taskMessage_loadingMavenConfig;

    public static String SwitchYardProjectManager_ErrorLoadingMetadataMessage;

    public static String SwitchYardProjectManager_UpdatingProjectMetadataJob;

    public static String SwitchYardProjectManager_UpdatingProjectMetadataJob2;

    public static String SwitchYardProjectValidator_validatorMessage_InvalidSYXMLFile;

    public static String SwitchYardProjectWorkingCopy_errorMessage_workingCopyOutOfSync;

    public static String SwitchYardProjectWorkingCopy_taskMessage_processingSYSettingsChanges;

    public static String SwitchYardProjectWorkingCopy_taskMessage_updatingProjectPOM;

    public static String SwitchYardProjectWorkingCopy_taskMessage_validatingComponentDependencies;

    public static String SwitchYardProjectWorkingCopy_taskMessage_validatingRepoSettings;

    public static String SwitchYardProjectWorkingCopy_taskMessage_validatingSYPlugin;

    public static String SwitchYardProjectWorkingCopy_taskMessage_validatingVersionProperty;

    public static String SwitchYardRootNode_errorLogMessage_errorLoadingSYConfig;

    public static String SwitchYardRootPropertySource_propertyDescriptor_application;

    public static String SwitchYardRootPropertySource_propertyDescriptor_configFile;

    public static String SwitchYardRootPropertySource_propertyDescriptorDescription_application;

    public static String SwitchYardRootPropertySource_propertyDescriptorDescription_configFile;

    public static String SwitchYardRuntimeComponentProvider_label_runtimeComponentName;

    public static String SwitchYardSettingsAction_errorMessage_errorInstallingSYFacet;

    public static String SwitchYardSettingsAction_errorMessage_title_errorInstallingSYFacet;

    public static String SwitchYardSettingsAction_logMessage_errorInitializingSYFacet;

    public static String SwitchYardSettingsAction_messageDialog_message_addSYCapabilities;

    public static String SwitchYardSettingsAction_messageDialog_message_addSYCapabilitiesAndFacet;

    public static String SwitchYardSettingsAction_messageDialog_title_addSYCapabilities;

    public static String SwitchYardSettingsAction_messageDialog_title_addSYCapabilitiesAndFacet;

    public static String SwitchYardSettingsGroup_ComponentUnavailableLabel;

    public static String SwitchYardSettingsGroup_ConfigurationVersionLabel;

    public static String SwitchYardSettingsGroup_DetailsGroup;

    public static String SwitchYardSettingsGroup_EmptyRuntimeComponentLabel;

    public static String SwitchYardSettingsGroup_ErrorLoadingCapabilitiesMessage;

    public static String SwitchYardSettingsGroup_GatewayBindingsLabel;

    public static String SwitchYardSettingsGroup_ImplementationSupportLabel;

    public static String SwitchYardSettingsGroup_Integration_Pack_Group_Label;

    public static String SwitchYardSettingsGroup_Integration_Pack_Version_Checkbox;

    public static String SwitchYardSettingsGroup_Integration_Pack_Version_Label;

    public static String SwitchYardSettingsGroup_Kie_Version_Label;

    public static String SwitchYardSettingsGroup_LibraryVersionLabel;

    public static String SwitchYardSettingsGroup_LoadingAvailableCapabilitiesMessage;

    public static String SwitchYardSettingsGroup_RuntimeLinkLabel;

    public static String SwitchYardSettingsGroup_SYComponentsGroupLabel;

    public static String SwitchYardSettingsGroup_TargetRuntimeLabel;

    public static String SwitchYardSettingsGroup_TestMixinsLabel;

    public static String SwitchYardSettingsGroup_UnknownCategoryLabel;

    public static String SwitchYardSettingsGroup_VersionDetailsGroup;

    public static String SwitchYardTestMixInExtensionManager_logMessageDuplicateNameForSYMixIn;

    public static String SwitchYardTestMixInExtensionManager_logMessageMissingNameForSYMixIn;

    public static String ValidationProblem_AmbiguousReference;

    public static String ValidationProblem_DuplicateName;
    
    public static String ValidationProblem_DuplicateServiceName;

    public static String ValidationProblem_IncompatibleInterfaceType;

    public static String ValidationProblem_IncompatibleMessageExchangePattern;

    public static String ValidationProblem_MissingComponentReference;

    public static String ValidationProblem_MissingComponentService;

    public static String ValidationProblem_NoProblem;

    public static String ValidationProblem_PromotedReferenceNameMismatch;

    public static String ValidationProblem_ReferenceInterfaceMismatch;

    public static String ValidationProblem_RequiredCapabilityMissing;

    public static String ValidationProblem_RequiredTransformMissing;

    public static String ValidationProblem_ServiceInterfaceMismatch;

    public static String ValidationProblem_UnableToValidateTransformers;

    public static String ValidationProblem_UnboundOperation;

    public static String ValidationProblem_UnboundService;

    public static String ValidationProblem_UnhandledFault;

    public static String ValidationProblem_UnimplementedServiceDeclaration;

    public static String ValidationProblem_UnresolvableBeanClass;
    
    public static String ValidationProblem_UnresolvableCamelRouteClass;

    public static String ValidationProblem_UnresolvableServiceInterface;
    
    public static String ValidationProblem_ServiceInterfaceHasMethodWithMultipleParameters;

    public static String ValidationProblem_UnresolvedReference;

    public static String ValidationProblem_UnspecifiedBeanClass;

    public static String ValidationProblem_UnspecifiedCamelRouteClass;

    public static String ValidationProblem_UnusedCapability;

    public static String ValidationProblem_UnusedComponentReference;

    public static String ValidationProblem_UnusedReference;

    public static String ValidationProblem_UnusedReturnValue;

    public static String ValidationProblem_ValidateProblem;
    
    public static String ValidationProblem_CamelRouteNoSYFromFound;

    public static String WiringValidationContext_statusMessage_errorLoadingServiceInterfaceMetadata;

    public static String WSDL2JavaOptionsWizardPage_buttonBrowse;

    public static String WSDL2JavaOptionsWizardPage_checkboxLabelCreateWrapperForMessageParts;

    public static String WSDL2JavaOptionsWizardPage_checkboxLabelGenerateParameterAndResultTypes;

    public static String WSDL2JavaOptionsWizardPage_checkboxLabelOverwriteExistingFiles;

    public static String WSDL2JavaOptionsWizardPage_errorMessage_cannotGenerateIntoDefaultPackage;

    public static String WSDL2JavaOptionsWizardPage_errorStatus_specifiedFileNotAWSDL;

    public static String WSDL2JavaOptionsWizardPage_errorStatus_specifiedWSDLDoesNotExist;

    public static String WSDL2JavaOptionsWizardPage_labelWSDLFile;

    public static String WSDL2JavaOptionsWizardPage_wizardPageDescription;

    public static String WSDL2JavaOptionsWizardPage_wizardPageTitle;

    public static String WSDL2JavaWizard_errorMessage_errorWhileGeneratingJava;

    public static String WSDL2JavaWizard_wizardTitle;

    public static String WSDLInterfaceControlAdapter_statusMessage_selectedWSDLNotOnClasspath;

    public static String WSDLInterfaceControlAdapter_statusMessage_selectPortType;

    public static String WSDLPortTypeSelectionDialog_dialogTitle;

    public static String WSDLPortTypeSelectionDialog_labelSelectPortType;

    public static String WSDLPortTypeSelectionDialog_validateMessage_SelectWSDLFileAndPortType;
    
    public static String InterfaceControl_DefaultESBInterface_ServiceName;
    
    public static String ValidationProblem_CamelJavaClassDoesNotExtendRouteBuilder;
    
    public static String ValidationProblem_NoCamelXMLSpecified;
    
    public static String ValidationProblem_CamelImplementationTypeMissing;
    
    public static String ValidationProblem_InvalidCamelRouteOperationReference;
    
    public static String ValidationProblem_CamelRouteOperationNotFoundAsReference;
    
    public static String ValidationProblem_CamelRouteOperationNotFoundAsService;
    
    public static String ValidationProblem_CamelRouteOperationRequiredNotSpecified;
    
    public static String ValidationProblem_CamelXMLNotFound;
    
    public static String ValidationProblem_CamelRouteMoreThanOneFromFound;
    
    public static String ProjectConfigurationWizardPage_errorMessage_bomRequiresVersion2;
    
    public static String ProjectConfigurationWizardPage_BOMCheckbox;
    
    public static String ValidationProblem_CamelRouteURIInvalid;
    
    public static String ValidationProblem_NoOperationSelectedForInterface;
    
    public static String ValidationProblem_CamelRouteInvalidSYToFound;
    
    static {
        // initialize resource bundle
        NLS.initializeMessages(BUNDLE_NAME, Messages.class);
    }

    private Messages() {
    }
}

