/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.bertclu;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.text.bertclu.AutoValue_BertCluAnnotator_BertCluAnnotatorOptions;
import org.tensorflow.lite.task.text.bertclu.CluRequest;
import org.tensorflow.lite.task.text.bertclu.CluResponse;

public class BertCluAnnotator
extends BaseTaskApi {
    private static final String BERT_CLU_ANNOTATOR_NATIVE_LIBNAME = "task_text_jni";

    public static BertCluAnnotator createFromFile(Context context, String modelPath) throws IOException {
        return BertCluAnnotator.createFromBufferAndOptions(TaskJniUtils.loadMappedFile((Context)context, (String)modelPath), BertCluAnnotatorOptions.builder().build());
    }

    public static BertCluAnnotator createFromBufferAndOptions(final ByteBuffer modelBuffer, final BertCluAnnotatorOptions options) {
        if (!modelBuffer.isDirect() && !(modelBuffer instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
        }
        return new BertCluAnnotator(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                long baseOptionsHandle = options.getBaseOptions() == null ? 0L : TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions());
                return BertCluAnnotator.initJniWithByteBuffer(options, modelBuffer, baseOptionsHandle);
            }
        }, (String)BERT_CLU_ANNOTATOR_NATIVE_LIBNAME));
    }

    public CluResponse annotate(CluRequest cluRequest) {
        return BertCluAnnotator.annotateNative(this.getNativeHandle(), cluRequest);
    }

    private BertCluAnnotator(long nativeHandle) {
        super(nativeHandle);
    }

    private static native long initJniWithByteBuffer(BertCluAnnotatorOptions var0, ByteBuffer var1, long var2);

    private static native CluResponse annotateNative(long var0, CluRequest var2);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    @UsedByReflection(value="bert_clu_annotator_jni.cc")
    public static abstract class BertCluAnnotatorOptions {
        private static final int DEFAULT_MAX_HISTORY_TURNS = 5;
        private static final float DEFAULT_DOMAIN_THRESHOLD = 0.5f;
        private static final float DEFAULT_INTENT_THRESHOLD = 0.5f;
        private static final float DEFAULT_CATEGORICAL_SLOT_THRESHOLD = 0.5f;
        private static final float DEFAULT_MENTIONED_SLOT_THRESHOLD = 0.5f;

        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        abstract int getMaxHistoryTurns();

        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        abstract float getDomainThreshold();

        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        abstract float getIntentThreshold();

        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        abstract float getCategoricalSlotThreshold();

        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        abstract float getMentionedSlotThreshold();

        @Nullable
        abstract BaseOptions getBaseOptions();

        public static Builder builder() {
            return new AutoValue_BertCluAnnotator_BertCluAnnotatorOptions.Builder().setMaxHistoryTurns(5).setDomainThreshold(0.5f).setIntentThreshold(0.5f).setCategoricalSlotThreshold(0.5f).setMentionedSlotThreshold(0.5f);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(@Nullable BaseOptions var1);

            public abstract Builder setMaxHistoryTurns(int var1);

            public abstract Builder setDomainThreshold(float var1);

            public abstract Builder setIntentThreshold(float var1);

            public abstract Builder setCategoricalSlotThreshold(float var1);

            public abstract Builder setMentionedSlotThreshold(float var1);

            public abstract BertCluAnnotatorOptions build();
        }
    }
}

