/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.bertclu;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.support.label.Category;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.text.bertclu.AutoValue_CluResponse;
import org.tensorflow.lite.task.text.bertclu.AutoValue_CluResponse_CategoricalSlot;
import org.tensorflow.lite.task.text.bertclu.AutoValue_CluResponse_Mention;
import org.tensorflow.lite.task.text.bertclu.AutoValue_CluResponse_MentionedSlot;

@AutoValue
@UsedByReflection(value="bert_clu_annotator_jni.cc")
public abstract class CluResponse {
    @UsedByReflection(value="bert_clu_annotator_jni.cc")
    static CluResponse create(List<Category> domains, List<Category> intents, List<CategoricalSlot> categoricalSlots, List<MentionedSlot> mentionedSlots) {
        return new AutoValue_CluResponse(Collections.unmodifiableList(new ArrayList<Category>(domains)), Collections.unmodifiableList(new ArrayList<Category>(intents)), Collections.unmodifiableList(new ArrayList<CategoricalSlot>(categoricalSlots)), Collections.unmodifiableList(new ArrayList<MentionedSlot>(mentionedSlots)));
    }

    public abstract List<Category> getDomains();

    public abstract List<Category> getIntents();

    public abstract List<CategoricalSlot> getCategoricalSlots();

    public abstract List<MentionedSlot> getMentionedSlots();

    @AutoValue
    @UsedByReflection(value="bert_clu_annotator_jni.cc")
    public static abstract class MentionedSlot {
        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        static MentionedSlot create(String slot, Mention mention) {
            return new AutoValue_CluResponse_MentionedSlot(slot, mention);
        }

        public abstract String getSlot();

        public abstract Mention getMention();
    }

    @AutoValue
    @UsedByReflection(value="bert_clu_annotator_jni.cc")
    public static abstract class Mention {
        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        static Mention create(String value, float score, int start, int end) {
            return new AutoValue_CluResponse_Mention(value, score, start, end);
        }

        public abstract String getValue();

        public abstract float getScore();

        public abstract int getStart();

        public abstract int getEnd();
    }

    @AutoValue
    @UsedByReflection(value="bert_clu_annotator_jni.cc")
    public static abstract class CategoricalSlot {
        @UsedByReflection(value="bert_clu_annotator_jni.cc")
        static CategoricalSlot create(String slot, Category prediction) {
            return new AutoValue_CluResponse_CategoricalSlot(slot, prediction);
        }

        public abstract String getSlot();

        public abstract Category getPrediction();
    }
}

