/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.nlclassifier;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import org.tensorflow.lite.support.label.Category;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.text.nlclassifier.AutoValue_BertNLClassifier_BertNLClassifierOptions;

public class BertNLClassifier
extends BaseTaskApi {
    private static final String BERT_NL_CLASSIFIER_NATIVE_LIBNAME = "task_text_jni";

    public static BertNLClassifier createFromFile(Context context, String modelPath) throws IOException {
        return BertNLClassifier.createFromBuffer(TaskJniUtils.loadMappedFile((Context)context, (String)modelPath));
    }

    public static BertNLClassifier createFromFile(File modelFile) throws IOException {
        return BertNLClassifier.createFromFileAndOptions(modelFile, BertNLClassifierOptions.builder().build());
    }

    public static BertNLClassifier createFromFileAndOptions(Context context, String modelPath, BertNLClassifierOptions options) throws IOException {
        return BertNLClassifier.createFromBufferAndOptions(TaskJniUtils.loadMappedFile((Context)context, (String)modelPath), options);
    }

    public static BertNLClassifier createFromFileAndOptions(File modelFile, final BertNLClassifierOptions options) throws IOException {
        try (final ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);){
            BertNLClassifier bertNLClassifier = new BertNLClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

                public long createHandle() {
                    return BertNLClassifier.initJniWithFileDescriptor(descriptor.getFd(), options, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()));
                }
            }, (String)BERT_NL_CLASSIFIER_NATIVE_LIBNAME));
            return bertNLClassifier;
        }
    }

    public static BertNLClassifier createFromBuffer(ByteBuffer modelBuffer) {
        return BertNLClassifier.createFromBufferAndOptions(modelBuffer, BertNLClassifierOptions.builder().build());
    }

    public static BertNLClassifier createFromBufferAndOptions(final ByteBuffer modelBuffer, final BertNLClassifierOptions options) {
        if (!modelBuffer.isDirect() && !(modelBuffer instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
        }
        return new BertNLClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                return BertNLClassifier.initJniWithByteBuffer(modelBuffer, options, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()));
            }
        }, (String)BERT_NL_CLASSIFIER_NATIVE_LIBNAME));
    }

    public List<Category> classify(String text) {
        return BertNLClassifier.classifyNative(this.getNativeHandle(), text);
    }

    private BertNLClassifier(long nativeHandle) {
        super(nativeHandle);
    }

    private static native long initJniWithByteBuffer(ByteBuffer var0, BertNLClassifierOptions var1, long var2);

    private static native long initJniWithFileDescriptor(int var0, BertNLClassifierOptions var1, long var2);

    private static native List<Category> classifyNative(long var0, String var2);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    @UsedByReflection(value="bert_nl_classifier_jni.cc")
    public static abstract class BertNLClassifierOptions {
        static final int DEFAULT_MAX_SEQ_LEN = 128;

        abstract int getMaxSeqLen();

        abstract BaseOptions getBaseOptions();

        public static Builder builder() {
            return new AutoValue_BertNLClassifier_BertNLClassifierOptions.Builder().setMaxSeqLen(128).setBaseOptions(BaseOptions.builder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            @Deprecated
            public abstract Builder setMaxSeqLen(int var1);

            public abstract BertNLClassifierOptions build();
        }
    }
}

