/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.nlclassifier;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import org.tensorflow.lite.support.label.Category;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.text.nlclassifier.AutoValue_NLClassifier_NLClassifierOptions;

public class NLClassifier
extends BaseTaskApi {
    private static final String NL_CLASSIFIER_NATIVE_LIBNAME = "task_text_jni";

    public static NLClassifier createFromFile(Context context, String modelPath) throws IOException {
        return NLClassifier.createFromFileAndOptions(context, modelPath, NLClassifierOptions.builder().build());
    }

    public static NLClassifier createFromFile(File modelFile) throws IOException {
        return NLClassifier.createFromFileAndOptions(modelFile, NLClassifierOptions.builder().build());
    }

    public static NLClassifier createFromFileAndOptions(Context context, String modelPath, NLClassifierOptions options) throws IOException {
        return NLClassifier.createFromBufferAndOptions(TaskJniUtils.loadMappedFile((Context)context, (String)modelPath), options);
    }

    public static NLClassifier createFromFileAndOptions(File modelFile, final NLClassifierOptions options) throws IOException {
        try (final ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);){
            NLClassifier nLClassifier = new NLClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

                public long createHandle() {
                    long baseOptionsHandle = options.getBaseOptions() == null ? 0L : TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions());
                    return NLClassifier.initJniWithFileDescriptor(options, descriptor.getFd(), baseOptionsHandle);
                }
            }, (String)NL_CLASSIFIER_NATIVE_LIBNAME));
            return nLClassifier;
        }
    }

    public static NLClassifier createFromBufferAndOptions(final ByteBuffer modelBuffer, final NLClassifierOptions options) {
        if (!modelBuffer.isDirect() && !(modelBuffer instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
        }
        return new NLClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                long baseOptionsHandle = options.getBaseOptions() == null ? 0L : TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions());
                return NLClassifier.initJniWithByteBuffer(options, modelBuffer, baseOptionsHandle);
            }
        }, (String)NL_CLASSIFIER_NATIVE_LIBNAME));
    }

    public List<Category> classify(String text) {
        return NLClassifier.classifyNative(this.getNativeHandle(), text);
    }

    protected NLClassifier(long nativeHandle) {
        super(nativeHandle);
    }

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private static native long initJniWithByteBuffer(NLClassifierOptions var0, ByteBuffer var1, long var2);

    private static native long initJniWithFileDescriptor(NLClassifierOptions var0, int var1, long var2);

    private static native List<Category> classifyNative(long var0, String var2);

    private native void deinitJni(long var1);

    @AutoValue
    @UsedByReflection(value="nl_classifier_jni.cc")
    public static abstract class NLClassifierOptions {
        private static final int DEFAULT_INPUT_TENSOR_INDEX = 0;
        private static final int DEFAULT_OUTPUT_SCORE_TENSOR_INDEX = 0;
        private static final int DEFAULT_OUTPUT_LABEL_TENSOR_INDEX = -1;
        private static final String DEFAULT_INPUT_TENSOR_NAME = "INPUT";
        private static final String DEFAULT_OUTPUT_SCORE_TENSOR_NAME = "OUTPUT_SCORE";
        private static final String DEFAULT_OUTPUT_LABEL_TENSOR_NAME = "OUTPUT_LABEL";

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract int getInputTensorIndex();

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract int getOutputScoreTensorIndex();

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract int getOutputLabelTensorIndex();

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract String getInputTensorName();

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract String getOutputScoreTensorName();

        @UsedByReflection(value="nl_classifier_jni.cc")
        abstract String getOutputLabelTensorName();

        @Nullable
        abstract BaseOptions getBaseOptions();

        public static Builder builder() {
            return new AutoValue_NLClassifier_NLClassifierOptions.Builder().setInputTensorIndex(0).setOutputScoreTensorIndex(0).setOutputLabelTensorIndex(-1).setInputTensorName(DEFAULT_INPUT_TENSOR_NAME).setOutputScoreTensorName(DEFAULT_OUTPUT_SCORE_TENSOR_NAME).setOutputLabelTensorName(DEFAULT_OUTPUT_LABEL_TENSOR_NAME);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(@Nullable BaseOptions var1);

            public abstract Builder setInputTensorName(String var1);

            public abstract Builder setOutputScoreTensorName(String var1);

            public abstract Builder setOutputLabelTensorName(String var1);

            public abstract Builder setInputTensorIndex(int var1);

            public abstract Builder setOutputScoreTensorIndex(int var1);

            public abstract Builder setOutputLabelTensorIndex(int var1);

            public abstract NLClassifierOptions build();
        }
    }
}

