/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.qa;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.text.qa.AutoValue_BertQuestionAnswerer_BertQuestionAnswererOptions;
import org.tensorflow.lite.task.text.qa.QaAnswer;
import org.tensorflow.lite.task.text.qa.QuestionAnswerer;

public class BertQuestionAnswerer
extends BaseTaskApi
implements QuestionAnswerer {
    private static final String BERT_QUESTION_ANSWERER_NATIVE_LIBNAME = "task_text_jni";
    private static final int OPTIONAL_FD_LENGTH = -1;
    private static final int OPTIONAL_FD_OFFSET = -1;

    public static BertQuestionAnswerer createFromFile(Context context, String modelPath) throws IOException {
        return BertQuestionAnswerer.createFromFileAndOptions(context, modelPath, BertQuestionAnswererOptions.builder().build());
    }

    public static BertQuestionAnswerer createFromFile(File modelFile) throws IOException {
        return BertQuestionAnswerer.createFromFileAndOptions(modelFile, BertQuestionAnswererOptions.builder().build());
    }

    public static BertQuestionAnswerer createFromFileAndOptions(Context context, String modelPath, BertQuestionAnswererOptions options) throws IOException {
        return new BertQuestionAnswerer(TaskJniUtils.createHandleFromFdAndOptions((Context)context, (TaskJniUtils.FdAndOptionsHandleProvider)new TaskJniUtils.FdAndOptionsHandleProvider<BertQuestionAnswererOptions>(){

            public long createHandle(int fileDescriptor, long fileDescriptorLength, long fileDescriptorOffset, BertQuestionAnswererOptions options) {
                return BertQuestionAnswerer.initJniWithFileDescriptor(fileDescriptor, fileDescriptorLength, fileDescriptorOffset, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()));
            }
        }, (String)BERT_QUESTION_ANSWERER_NATIVE_LIBNAME, (String)modelPath, (Object)options));
    }

    public static BertQuestionAnswerer createFromFileAndOptions(File modelFile, final BertQuestionAnswererOptions options) throws IOException {
        try (final ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);){
            BertQuestionAnswerer bertQuestionAnswerer = new BertQuestionAnswerer(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

                public long createHandle() {
                    return BertQuestionAnswerer.initJniWithFileDescriptor(descriptor.getFd(), -1L, -1L, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()));
                }
            }, (String)BERT_QUESTION_ANSWERER_NATIVE_LIBNAME));
            return bertQuestionAnswerer;
        }
    }

    public static BertQuestionAnswerer createBertQuestionAnswererFromFile(Context context, String modelPath, String vocabPath) throws IOException {
        return new BertQuestionAnswerer(TaskJniUtils.createHandleWithMultipleAssetFilesFromLibrary((Context)context, (TaskJniUtils.MultipleBuffersHandleProvider)new TaskJniUtils.MultipleBuffersHandleProvider(){

            public long createHandle(ByteBuffer ... buffers) {
                return BertQuestionAnswerer.initJniWithBertByteBuffers(buffers);
            }
        }, (String)BERT_QUESTION_ANSWERER_NATIVE_LIBNAME, (String[])new String[]{modelPath, vocabPath}));
    }

    public static BertQuestionAnswerer createAlbertQuestionAnswererFromFile(Context context, String modelPath, String sentencePieceModelPath) throws IOException {
        return new BertQuestionAnswerer(TaskJniUtils.createHandleWithMultipleAssetFilesFromLibrary((Context)context, (TaskJniUtils.MultipleBuffersHandleProvider)new TaskJniUtils.MultipleBuffersHandleProvider(){

            public long createHandle(ByteBuffer ... buffers) {
                return BertQuestionAnswerer.initJniWithAlbertByteBuffers(buffers);
            }
        }, (String)BERT_QUESTION_ANSWERER_NATIVE_LIBNAME, (String[])new String[]{modelPath, sentencePieceModelPath}));
    }

    @Override
    public List<QaAnswer> answer(String context, String question) {
        this.checkNotClosed();
        return BertQuestionAnswerer.answerNative(this.getNativeHandle(), context, question);
    }

    private BertQuestionAnswerer(long nativeHandle) {
        super(nativeHandle);
    }

    private static native long initJniWithBertByteBuffers(ByteBuffer ... var0);

    private static native long initJniWithAlbertByteBuffers(ByteBuffer ... var0);

    private static native long initJniWithFileDescriptor(int var0, long var1, long var3, long var5);

    private static native List<QaAnswer> answerNative(long var0, String var2, String var3);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    public static abstract class BertQuestionAnswererOptions {
        abstract BaseOptions getBaseOptions();

        public static Builder builder() {
            return new AutoValue_BertQuestionAnswerer_BertQuestionAnswererOptions.Builder().setBaseOptions(BaseOptions.builder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            public abstract BertQuestionAnswererOptions build();
        }
    }
}

