/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.text.searcher;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.ParcelFileDescriptor;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.processor.NearestNeighbor;
import org.tensorflow.lite.task.processor.SearcherOptions;
import org.tensorflow.lite.task.text.searcher.AutoValue_TextSearcher_TextSearcherOptions;

public final class TextSearcher
extends BaseTaskApi {
    private static final String TEXT_SEARCHER_NATIVE_LIB = "task_text_jni";
    private static final int OPTIONAL_FD_LENGTH = -1;
    private static final int OPTIONAL_FD_OFFSET = -1;

    public static TextSearcher createFromFileAndOptions(Context context, String modelPath, TextSearcherOptions options) throws IOException {
        try (AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(modelPath);){
            TextSearcher textSearcher = TextSearcher.createFromModelFdAndOptions(assetFileDescriptor.getParcelFileDescriptor().getFd(), assetFileDescriptor.getLength(), assetFileDescriptor.getStartOffset(), options);
            return textSearcher;
        }
    }

    public static TextSearcher createFromFileAndOptions(File modelFile, TextSearcherOptions options) throws IOException {
        try (ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);){
            TextSearcher textSearcher = TextSearcher.createFromModelFdAndOptions(descriptor.getFd(), -1L, -1L, options);
            return textSearcher;
        }
    }

    public static TextSearcher createFromBufferAndOptions(ByteBuffer modelBuffer, TextSearcherOptions options) throws IOException {
        if (!modelBuffer.isDirect() && !(modelBuffer instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
        }
        if (options.getSearcherOptions().getIndexFile() != null) {
            try (ParcelFileDescriptor indexDescriptor = ParcelFileDescriptor.open((File)options.getSearcherOptions().getIndexFile(), (int)0x10000000);){
                TextSearcher textSearcher = TextSearcher.createFromBufferAndOptionsImpl(modelBuffer, options, indexDescriptor.getFd());
                return textSearcher;
            }
        }
        return TextSearcher.createFromBufferAndOptionsImpl(modelBuffer, options, 0);
    }

    public static TextSearcher createFromBufferAndOptionsImpl(final ByteBuffer modelBuffer, final TextSearcherOptions options, final int indexFd) {
        return new TextSearcher(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                return TextSearcher.initJniWithByteBuffer(modelBuffer, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()), options.getSearcherOptions().getL2Normalize(), options.getSearcherOptions().getQuantize(), indexFd, options.getSearcherOptions().getMaxResults());
            }
        }, (String)TEXT_SEARCHER_NATIVE_LIB));
    }

    TextSearcher(long nativeHandle) {
        super(nativeHandle);
    }

    public List<NearestNeighbor> search(String text) {
        return TextSearcher.searchNative(this.getNativeHandle(), text);
    }

    private static TextSearcher createFromModelFdAndOptions(int modelDescriptor, long modelDescriptorLength, long modelDescriptorOffset, TextSearcherOptions options) throws IOException {
        if (options.getSearcherOptions().getIndexFile() != null) {
            try (ParcelFileDescriptor indexDescriptor = ParcelFileDescriptor.open((File)options.getSearcherOptions().getIndexFile(), (int)0x10000000);){
                TextSearcher textSearcher = TextSearcher.createFromModelFdAndOptionsImpl(modelDescriptor, modelDescriptorLength, modelDescriptorOffset, options, indexDescriptor.getFd());
                return textSearcher;
            }
        }
        return TextSearcher.createFromModelFdAndOptionsImpl(modelDescriptor, modelDescriptorLength, modelDescriptorOffset, options, 0);
    }

    private static TextSearcher createFromModelFdAndOptionsImpl(final int modelDescriptor, final long modelDescriptorLength, final long modelDescriptorOffset, final TextSearcherOptions options, final int indexFd) {
        long nativeHandle = TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                return TextSearcher.initJniWithModelFdAndOptions(modelDescriptor, modelDescriptorLength, modelDescriptorOffset, TaskJniUtils.createProtoBaseOptionsHandle((BaseOptions)options.getBaseOptions()), options.getSearcherOptions().getL2Normalize(), options.getSearcherOptions().getQuantize(), indexFd, options.getSearcherOptions().getMaxResults());
            }
        }, (String)TEXT_SEARCHER_NATIVE_LIB);
        return new TextSearcher(nativeHandle);
    }

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, long var5, boolean var7, boolean var8, int var9, int var10);

    private static native long initJniWithByteBuffer(ByteBuffer var0, long var1, boolean var3, boolean var4, int var5, int var6);

    private static native List<NearestNeighbor> searchNative(long var0, String var2);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    public static abstract class TextSearcherOptions {
        abstract BaseOptions getBaseOptions();

        abstract SearcherOptions getSearcherOptions();

        public static Builder builder() {
            return new AutoValue_TextSearcher_TextSearcherOptions.Builder().setBaseOptions(BaseOptions.builder().build()).setSearcherOptions(SearcherOptions.builder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            public abstract Builder setSearcherOptions(SearcherOptions var1);

            public abstract TextSearcherOptions build();
        }
    }
}

