/*
 * Copyright 2021 TiKV Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tikv.common.meta;

import java.io.Serializable;
import java.util.List;
import org.tikv.common.expression.Expression;

public class TiPartitionExpr implements Serializable {
  private final List<Expression> ranges;
  private final List<Expression> upperBound;
  private final Expression column;

  public TiPartitionExpr(List<Expression> ranges, List<Expression> upperBound, Expression column) {
    this.ranges = ranges;
    this.upperBound = upperBound;
    this.column = column;
  }

  public Expression getColumn() {
    return column;
  }

  public List<Expression> getUpperBound() {
    return upperBound;
  }

  public List<Expression> getRanges() {
    return ranges;
  }

  public boolean canPruned() {
    return column == null;
  }
}
