/*
 * Copyright 2021 TiKV Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tikv.service.failsafe;

import java.io.Closeable;

public interface CircuitBreakerMetrics extends Closeable {
  /** Record a successful call. */
  void recordSuccess();

  /** Record a failure call. */
  void recordFailure();

  /** Add metrics listener. */
  void addListener(MetricsListener metricsListener);
}
