/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.traceviewer;

import io.perfmark.tracewriter.TraceEventWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.tikv.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class TraceEventViewer {
    private static final Logger logger = Logger.getLogger(TraceEventViewer.class.getName());
    private static final String INLINE_TRACE_DATA = "    const traces = [];\n    const viewerDataScripts = Polymer.dom(document).querySelectorAll(\n        '#viewer-data');\n    for (let i = 0; i < viewerDataScripts.length; i++) {\n      let text = Polymer.dom(viewerDataScripts[i]).textContent;\n      // Trim leading newlines off the text. They happen during writing.\n      while (text[0] === '\\n') {\n        text = text.substring(1);\n      }\n      onResult(tr.b.Base64.atob(text));\n      viewer.updateDocumentFavicon();\n      viewer.globalMode = true;\n      viewer.viewTitle = document.title;\n      break;\n    }\n";

    @CanIgnoreReturnValue
    public static Path writeTraceHtml() throws IOException {
        Path path = Files.createTempFile("perfmark-trace-", ".html", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING);
             OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            TraceEventViewer.writeTraceHtml(w);
        }
        logger.log(Level.INFO, "Wrote PerfMark Trace file://{0}", new Object[]{path.toAbsolutePath()});
        return path;
    }

    public static void writeTraceHtml(Writer writer) throws IOException {
        InputStream indexStream = TraceEventViewer.class.getResourceAsStream("third_party/catapult/index.html");
        if (indexStream == null) {
            throw new IOException("unable to find index.html");
        }
        String index = TraceEventViewer.readAll(indexStream);
        InputStream webComponentsStream = TraceEventViewer.class.getResourceAsStream("third_party/polymer/webcomponents.min.js");
        if (webComponentsStream == null) {
            throw new IOException("unable to find webcomponents.min.js");
        }
        String webComponents = TraceEventViewer.readAll(webComponentsStream);
        InputStream traceViewerStream = TraceEventViewer.class.getResourceAsStream("third_party/catapult/trace_viewer_full.html");
        if (traceViewerStream == null) {
            throw new IOException("unable to find trace_viewer_full.html");
        }
        String traceViewer = TraceEventViewer.trimTraceViewer(TraceEventViewer.readAll(traceViewerStream));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
            TraceEventWriter.writeTraceEvents(w);
        }
        byte[] traceData64 = Base64.getEncoder().encode(baos.toByteArray());
        String indexWithWebComponents = TraceEventViewer.replaceIndexWebComponents(index, webComponents);
        String indexWithTraceViewer = TraceEventViewer.replaceIndexTraceImport(indexWithWebComponents, traceViewer, new String(traceData64, StandardCharsets.UTF_8));
        String fullIndex = TraceEventViewer.replaceIndexTraceData(indexWithTraceViewer, INLINE_TRACE_DATA);
        writer.write(fullIndex);
        writer.flush();
    }

    private static String replaceIndexTraceImport(String index, String replacement, @Nullable String inlineTraceData64) {
        int start = index.indexOf("IO_PERFMARK_TRACE_IMPORT");
        if (start == -1) {
            throw new IllegalArgumentException("index doesn't contain IO_PERFMARK_TRACE_IMPORT");
        }
        int line0pos = index.lastIndexOf(10, start);
        assert (line0pos != -1);
        int line1pos = index.indexOf(10, line0pos + 1);
        assert (line1pos != -1);
        int line2pos = index.indexOf(10, line1pos + 1);
        assert (line2pos != -1);
        int line3pos = index.indexOf(10, line2pos + 1);
        assert (line3pos != -1);
        String inlineTraceData = "";
        if (inlineTraceData64 != null) {
            inlineTraceData = "\n<script id=\"viewer-data\" type=\"text/plain\">" + inlineTraceData64 + "</script>";
        }
        return index.substring(0, line0pos + 1) + replacement + inlineTraceData + index.substring(line3pos);
    }

    private static String replaceIndexWebComponents(String index, String replacement) {
        int start = index.indexOf("IO_PERFMARK_WEBCOMPONENTS");
        if (start == -1) {
            throw new IllegalArgumentException("index doesn't contain IO_PERFMARK_WEBCOMPONENTS");
        }
        int line0pos = index.lastIndexOf(10, start);
        assert (line0pos != -1);
        int line1pos = index.indexOf(10, line0pos + 1);
        assert (line1pos != -1);
        return index.substring(0, line0pos + 1) + replacement + index.substring(line1pos);
    }

    private static String replaceIndexTraceData(String index, String replacement) {
        int start = index.indexOf("IO_PERFMARK_TRACE_URL");
        if (start == -1) {
            throw new IllegalArgumentException("index doesn't contain IO_PERFMARK_TRACE_URL");
        }
        int line0pos = index.lastIndexOf(10, start);
        assert (line0pos != -1);
        int line1pos = index.indexOf(10, line0pos + 1);
        assert (line1pos != -1);
        int line2pos = index.indexOf(10, line1pos + 1);
        assert (line2pos != -1);
        int line3pos = index.indexOf(10, line2pos + 1);
        assert (line3pos != -1);
        return index.substring(0, line0pos + 1) + replacement + index.substring(line3pos);
    }

    private static String trimTraceViewer(String traceViewer) {
        int startpos = traceViewer.indexOf("<template");
        int lastpos = traceViewer.lastIndexOf("</head>");
        return traceViewer.substring(startpos, lastpos);
    }

    private static String readAll(InputStream stream) throws IOException {
        int read;
        int available = stream.available();
        byte[] data = available > 0 ? new byte[available + 1] : new byte[4096];
        int pos = 0;
        while ((read = stream.read(data, pos, data.length - pos)) != -1) {
            if ((pos += read) != data.length) continue;
            data = Arrays.copyOf(data, data.length + (data.length >> 2));
        }
        return new String(data, 0, pos, StandardCharsets.UTF_8);
    }

    private TraceEventViewer() {
        throw new AssertionError((Object)"nope");
    }
}

