/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.sql.Timestamp;
import org.joda.time.DateTime;

public class ExtendedDateTime {
    private final DateTime dateTime;
    private final int microsOfMillis;

    public ExtendedDateTime(DateTime dateTime, int microsOfMillis) {
        this.dateTime = dateTime;
        this.microsOfMillis = microsOfMillis;
    }

    public ExtendedDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
        this.microsOfMillis = 0;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public int getMicrosOfSeconds() {
        return this.dateTime.getMillisOfSecond() * 1000 + this.microsOfMillis;
    }

    public int getMicrosOfMillis() {
        return this.microsOfMillis;
    }

    public Timestamp toTimeStamp() {
        Timestamp timestamp = new Timestamp(this.dateTime.getMillis() / 1000L * 1000L);
        timestamp.setNanos(this.dateTime.getMillisOfSecond() * 1000000 + this.microsOfMillis * 1000);
        return timestamp;
    }

    public long toEpochMicro() {
        return this.toTimeStamp().getTime() * 1000L + (long)this.getMicrosOfMillis();
    }
}

