/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.tikv.common.BytePairWrapper;
import org.tikv.common.KVClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.columnar.TiChunk;
import org.tikv.common.key.Key;
import org.tikv.common.meta.TiDAGRequest;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.operation.iterator.ConcreteScanIterator;
import org.tikv.common.operation.iterator.CoprocessorIterator;
import org.tikv.common.operation.iterator.IndexScanIterator;
import org.tikv.common.row.Row;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.RangeSplitter;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;

public class Snapshot {
    private final TiTimestamp timestamp;
    private final TiSession session;

    public Snapshot(@Nonnull TiTimestamp timestamp, TiSession session) {
        this.timestamp = timestamp;
        this.session = session;
    }

    public TiSession getSession() {
        return this.session;
    }

    public long getVersion() {
        return this.timestamp.getVersion();
    }

    public TiTimestamp getTimestamp() {
        return this.timestamp;
    }

    public byte[] get(byte[] key) {
        ByteString keyString = ByteString.copyFrom(key);
        ByteString value = this.get(keyString);
        return value.toByteArray();
    }

    public ByteString get(ByteString key) {
        try (KVClient client = new KVClient(this.session, this.session.getRegionStoreClientBuilder());){
            ByteString byteString = client.get(key, this.timestamp.getVersion());
            return byteString;
        }
    }

    public List<BytePairWrapper> batchGet(int backOffer, List<byte[]> keys) {
        ArrayList<ByteString> list = new ArrayList<ByteString>();
        for (byte[] key : keys) {
            list.add(ByteString.copyFrom(key));
        }
        try (KVClient client = new KVClient(this.session, this.session.getRegionStoreClientBuilder());){
            List<Kvrpcpb.KvPair> kvPairList = client.batchGet(ConcreteBackOffer.newCustomBackOff(backOffer, this.session.getPDClient().getClusterId()), list, this.timestamp.getVersion());
            List<BytePairWrapper> list2 = kvPairList.stream().map(kvPair -> new BytePairWrapper(kvPair.getKey().toByteArray(), kvPair.getValue().toByteArray())).collect(Collectors.toList());
            return list2;
        }
    }

    public Iterator<TiChunk> tableReadChunk(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks, int numOfRows) {
        if (dagRequest.isDoubleRead()) {
            throw new UnsupportedOperationException("double read case should first read handle in row-wise fashion");
        }
        return CoprocessorIterator.getTiChunkIterator(dagRequest, tasks, this.getSession(), numOfRows);
    }

    public Iterator<Row> tableReadRow(TiDAGRequest dagRequest, long physicalId) {
        return this.tableReadRow(dagRequest, RangeSplitter.newSplitter(this.session.getRegionManager()).splitRangeByRegion(dagRequest.getRangesByPhysicalId(physicalId), dagRequest.getStoreType()));
    }

    private Iterator<Row> tableReadRow(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        if (dagRequest.isDoubleRead()) {
            CoprocessorIterator<Long> iter = CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.getSession());
            return new IndexScanIterator(this, dagRequest, iter);
        }
        return CoprocessorIterator.getRowIterator(dagRequest, tasks, this.getSession());
    }

    public Iterator<Long> indexHandleRead(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        return CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.session);
    }

    public Iterator<Kvrpcpb.KvPair> scan(ByteString startKey) {
        return new ConcreteScanIterator(this.session.getConf(), this.session.getRegionStoreClientBuilder(), startKey, this.timestamp.getVersion(), Integer.MAX_VALUE);
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix(ByteString prefix) {
        ByteString nextPrefix = Key.toRawKey(prefix).nextPrefix().toByteString();
        return new ConcreteScanIterator(this.session.getConf(), this.session.getRegionStoreClientBuilder(), prefix, nextPrefix, this.timestamp.getVersion());
    }

    public TiConfiguration getConf() {
        return this.session.getConf();
    }
}

