/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.tikv.shade.com.google.protobuf.ByteString;

public class CodecDataInput
implements DataInput {
    protected final DataInputStream inputStream;
    protected final UnSyncByteArrayInputStream backingStream;
    protected final byte[] backingBuffer;

    public CodecDataInput(ByteString data) {
        this(data.toByteArray());
    }

    public CodecDataInput(byte[] buf) {
        this.backingBuffer = buf;
        this.backingStream = new UnSyncByteArrayInputStream(buf){

            @Override
            public void mark(int givenPos) {
                this.mark = givenPos;
            }
        };
        this.inputStream = new DataInputStream(this.backingStream);
    }

    @Override
    public void readFully(@Nonnull byte[] b) {
        try {
            this.inputStream.readFully(b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readFully(@Nonnull byte[] b, int off, int len) {
        try {
            this.inputStream.readFully(b, off, len);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int skipBytes(int n) {
        try {
            return this.inputStream.skipBytes(n);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.inputStream.readBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() {
        try {
            return this.inputStream.readByte();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.inputStream.readUnsignedByte();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.inputStream.readShort();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedShort() {
        try {
            return this.inputStream.readUnsignedShort();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int readPartialUnsignedShort() {
        try {
            byte[] readBuffer = new byte[2];
            this.inputStream.read(readBuffer, 0, 2);
            return ((readBuffer[0] & 0xFF) << 8) + ((readBuffer[1] & 0xFF) << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char readChar() {
        try {
            return this.inputStream.readChar();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.inputStream.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.inputStream.readLong();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.inputStream.readFloat();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.inputStream.readDouble();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readLine() {
        try {
            return this.inputStream.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public String readUTF() {
        try {
            return this.inputStream.readUTF();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int peekByte() {
        this.mark(this.currentPos());
        int b = this.readByte() & 0xFF;
        this.reset();
        return b;
    }

    public int currentPos() {
        return this.size() - this.available();
    }

    public void mark(int givenPos) {
        this.backingStream.mark(givenPos);
    }

    public void reset() {
        this.backingStream.reset();
    }

    public boolean eof() {
        return this.backingStream.available() == 0;
    }

    public int size() {
        return this.backingBuffer.length;
    }

    public int available() {
        return this.backingStream.available();
    }

    public byte[] toByteArray() {
        return this.backingBuffer;
    }

    private static class UnSyncByteArrayInputStream
    extends InputStream {
        protected byte[] buf;
        protected int pos;
        protected int mark = 0;
        protected int count;

        UnSyncByteArrayInputStream(byte[] buf) {
            this.buf = buf;
            this.pos = 0;
            this.count = buf.length;
        }

        @Override
        public int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int avail = this.count - this.pos;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            long k = this.count - this.pos;
            if (n < k) {
                k = n < 0L ? 0L : n;
            }
            this.pos = (int)((long)this.pos + k);
            return k;
        }

        @Override
        public int available() {
            return this.count - this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

