/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.event;

import java.io.Serializable;

public class CacheInvalidateEvent
implements Serializable {
    private final long regionId;
    private final long storeId;
    private final CacheType cacheType;
    private boolean invalidateRegion;
    private boolean invalidateStore;

    public CacheInvalidateEvent(long regionId, long storeId, boolean updateRegion, boolean updateStore, CacheType type) {
        this.regionId = regionId;
        this.storeId = storeId;
        this.cacheType = type;
        if (updateRegion) {
            this.invalidateRegion();
        }
        if (updateStore) {
            this.invalidateStore();
        }
    }

    public long getRegionId() {
        return this.regionId;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CacheInvalidateEvent) {
            CacheInvalidateEvent event = (CacheInvalidateEvent)obj;
            return event.getRegionId() == this.getRegionId() && event.getStoreId() == this.getStoreId() && event.getCacheType() == this.getCacheType();
        }
        return false;
    }

    public int hashCode() {
        int result = 1106;
        result = (int)((long)result + ((long)(result * 31) + this.getStoreId()));
        result = (int)((long)result + ((long)(result * 31) + this.getRegionId()));
        result += result * 31 + this.getCacheType().name().hashCode();
        return result;
    }

    public void invalidateRegion() {
        this.invalidateRegion = true;
    }

    public void invalidateStore() {
        this.invalidateStore = true;
    }

    public boolean shouldUpdateRegion() {
        return this.invalidateRegion;
    }

    public boolean shouldUpdateStore() {
        return this.invalidateStore;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public String toString() {
        return String.format("RegionId=%d,StoreId=%d,Type=%s", this.regionId, this.storeId, this.cacheType.name());
    }

    public static enum CacheType implements Serializable
    {
        REGION_STORE,
        REQ_FAILED,
        LEADER;

    }
}

