/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import java.io.Serializable;
import java.util.Objects;

public class TiTimestamp
implements Serializable {
    private static final int PHYSICAL_SHIFT_BITS = 18;
    private final long physical;
    private final long logical;

    public TiTimestamp(long p, long l) {
        this.physical = p;
        this.logical = l;
    }

    public static long extractPhysical(long ts) {
        return ts >> 18;
    }

    public long getVersion() {
        return (this.physical << 18) + this.logical;
    }

    public long getPhysical() {
        return this.physical;
    }

    public long getLogical() {
        return this.logical;
    }

    public TiTimestamp getPrevious() {
        return new TiTimestamp(this.physical, this.logical - 1L);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TiTimestamp)) {
            return false;
        }
        return this.getVersion() == ((TiTimestamp)other).getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.getVersion());
    }

    public String toString() {
        return "TiTimestamp(" + this.getVersion() + ")";
    }
}

