/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.util.concurrent.ThreadLocalRandom;
import org.tikv.common.util.BackOffer;

public class BackOffFunction {
    private final int base;
    private final int cap;
    private final BackOffer.BackOffStrategy strategy;
    private long lastSleep;
    private int attempts;

    private BackOffFunction(int base, int cap, BackOffer.BackOffStrategy strategy) {
        this.base = base;
        this.cap = cap;
        this.strategy = strategy;
        this.lastSleep = base;
    }

    public static BackOffFunction create(int base, int cap, BackOffer.BackOffStrategy strategy) {
        return new BackOffFunction(base, cap, strategy);
    }

    long getSleepMs(long maxSleepMs) {
        long sleep = 0L;
        long v = this.expo(this.base, this.cap, this.attempts);
        switch (this.strategy) {
            case NoJitter: {
                sleep = v;
                break;
            }
            case FullJitter: {
                sleep = ThreadLocalRandom.current().nextLong(v);
                break;
            }
            case EqualJitter: {
                sleep = v / 2L + ThreadLocalRandom.current().nextLong(v / 2L);
                break;
            }
            case DecorrJitter: {
                sleep = Math.min((long)this.cap, (long)this.base + ThreadLocalRandom.current().nextLong(this.lastSleep * 3L - (long)this.base));
            }
        }
        if (maxSleepMs > 0L && sleep > maxSleepMs) {
            sleep = maxSleepMs;
        }
        ++this.attempts;
        this.lastSleep = sleep;
        return this.lastSleep;
    }

    private int expo(int base, int cap, int n) {
        return (int)Math.min((double)cap, (double)base * Math.pow(2.0, n));
    }

    public static enum BackOffFuncType {
        BoTiKVRPC,
        BoTxnLock,
        BoTxnLockFast,
        BoPDRPC,
        BoRegionMiss,
        BoUpdateLeader,
        BoServerBusy,
        BoTxnNotFound,
        BoCheckTimeout,
        BoCheckHealth;

    }
}

