/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import org.tikv.shade.com.google.protobuf.ByteString;

public class ScanOption {
    private final ByteString startKey;
    private final ByteString endKey;
    private final int limit;
    private final boolean keyOnly;

    private ScanOption(ByteString startKey, ByteString endKey, int limit, boolean keyOnly) {
        this.startKey = startKey;
        this.endKey = endKey;
        this.limit = limit;
        this.keyOnly = keyOnly;
    }

    public static ScanOptionBuilder newBuilder() {
        return new ScanOptionBuilder();
    }

    public ByteString getStartKey() {
        return this.startKey;
    }

    public ByteString getEndKey() {
        return this.endKey;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isKeyOnly() {
        return this.keyOnly;
    }

    public static class ScanOptionBuilder {
        private ByteString startKey = ByteString.EMPTY;
        private ByteString endKey = ByteString.EMPTY;
        private int limit = 0;
        private boolean keyOnly = false;

        private ScanOptionBuilder() {
        }

        public ScanOption build() {
            return new ScanOption(this.startKey, this.endKey, this.limit, this.keyOnly);
        }

        public ScanOptionBuilder setStartKey(ByteString startKey) {
            this.startKey = startKey;
            return this;
        }

        public ScanOptionBuilder setEndKey(ByteString endKey) {
            this.endKey = endKey;
            return this;
        }

        public ScanOptionBuilder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ScanOptionBuilder setKeyOnly(boolean keyOnly) {
            this.keyOnly = keyOnly;
            return this;
        }
    }
}

