/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.secure.sslcert;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.plugin.backend.spi.BackendGuiDescriptor;
import org.webpieces.plugin.secure.sslcert.InstallSslCertConfig;
import org.webpieces.plugin.secure.sslcert.InstallSslCertGuiDescriptor;
import org.webpieces.plugin.secure.sslcert.PortType;
import org.webpieces.plugin.secure.sslcert.WebSSLFactory;

public class InstallSslCertModule
extends AbstractModule {
    private InstallSslCertConfig config;

    public InstallSslCertModule(InstallSslCertConfig config) {
        this.config = config;
    }

    protected void configure() {
        Multibinder backendBinder = Multibinder.newSetBinder((Binder)this.binder(), BackendGuiDescriptor.class);
        backendBinder.addBinding().to(InstallSslCertGuiDescriptor.class);
        this.binder().bind(InstallSslCertConfig.class).toInstance((Object)this.config);
        PortType type = this.config.getHttpsPortType();
        PortType backEndType = this.config.getBackendType();
        if (type == PortType.HTTPS) {
            this.binder().bind(SSLEngineFactory.class).to(WebSSLFactory.class);
        }
        if (backEndType == PortType.HTTPS) {
            this.binder().bind(SSLEngineFactory.class).annotatedWith((Annotation)Names.named((String)"backendSsl")).to(WebSSLFactory.class);
        }
    }
}

