/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.secure.sslcert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.digitalforge.sneakythrow.SneakyThrow;
import org.jose4j.base64url.Base64;
import org.shredzone.acme4j.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.router.api.extensions.NeedsSimpleStorage;
import org.webpieces.router.api.extensions.SimpleStorage;
import org.webpieces.util.futures.XFuture;

public class WebSSLFactory
implements SSLEngineFactory,
NeedsSimpleStorage {
    private static final Logger log = LoggerFactory.getLogger(WebSSLFactory.class);
    private String serverKeystore = "/keystore.jks";
    private String password = "password";
    private char[] passphrase = this.password.toCharArray();
    private SimpleStorage storage;
    private KeyPair accountKeyPair;
    private X509Certificate[] certChain;

    @Inject
    public WebSSLFactory(SimpleStorage storage) {
        try (InputStream keySt = WebSSLFactory.class.getResourceAsStream(this.serverKeystore);){
            if (keySt == null) {
                throw new IllegalStateException("keystore was not found");
            }
        }
        catch (IOException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public XFuture<Void> init(SimpleStorage storage) {
        log.info("intializing storage=" + storage);
        this.storage = storage;
        XFuture future = storage.read("org.webpieces.plugin.sslcert");
        return future.thenApply(props -> this.setupCert((Map<String, String>)props));
    }

    private Void setupCert(Map<String, String> properties) {
        String cert = properties.get("certChain0");
        if (cert == null) {
            log.warn("No cert for SSL installed yet, using self signed cert");
            return null;
        }
        String accountKeyPairString = properties.get("accountKeyPair");
        try (StringReader reader = new StringReader(accountKeyPairString);){
            this.accountKeyPair = KeyPairUtils.readKeyPair((Reader)reader);
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            int i = 0;
            while (true) {
                String base64Cert = properties.get("certChain" + i);
                ++i;
                if (base64Cert == null) break;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)base64Cert)));
                certs.add(certificate);
            }
            this.certChain = certs.toArray(new X509Certificate[0]);
        }
        catch (IOException | CertificateException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
        return null;
    }

    public SSLEngine createSslEngine() {
        try {
            if (this.certChain != null) {
                return this.createSslEngineFromCert();
            }
            XFuture future = XFuture.completedFuture(new HashMap());
            if (this.storage != null) {
                future = this.storage.read("org.webpieces.plugin.sslcert");
            }
            future.thenApply(props -> this.setupCert((Map<String, String>)props)).exceptionally(t -> {
                log.error("Exception reading and we swallow it here.  we default then to self-signed cert", t);
                return null;
            });
            return this.createFromSelfSignedCert();
        }
        catch (Exception e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    private SSLEngine createFromSelfSignedCert() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        try (InputStream keySt = WebSSLFactory.class.getResourceAsStream(this.serverKeystore);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keySt, this.passphrase);
            SSLEngine sSLEngine = this.createFromKeystore(ks);
            return sSLEngine;
        }
    }

    private SSLEngine createSslEngineFromCert() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, this.passphrase);
        ks.setKeyEntry("alias", this.accountKeyPair.getPrivate(), this.passphrase, this.certChain);
        return this.createFromKeystore(ks);
    }

    private SSLEngine createFromKeystore(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, this.passphrase);
        sslContext.init(kmf.getKeyManagers(), null, null);
        SSLEngine engine = sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }
}

