/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.secure.sslcert.acme;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.digitalforge.sneakythrow.SneakyThrow;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.AccountBuilder;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Metadata;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.util.CSRBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugin.secure.sslcert.CertAndSigningRequest;
import org.webpieces.plugin.secure.sslcert.ChallengeInBadStateException;
import org.webpieces.plugin.secure.sslcert.InstallSslCertConfig;
import org.webpieces.plugin.secure.sslcert.acme.AcmeInfo;
import org.webpieces.plugin.secure.sslcert.acme.ProxyAuthorization;
import org.webpieces.plugin.secure.sslcert.acme.ProxyOrder;
import org.webpieces.util.futures.XFuture;
import org.webpieces.util.futures.XFutureCollector;

public class AcmeClientProxy {
    private static final Logger log = LoggerFactory.getLogger(AcmeClientProxy.class);
    private InstallSslCertConfig config;

    @Inject
    public AcmeClientProxy(InstallSslCertConfig config) {
        this.config = config;
    }

    public XFuture<AcmeInfo> fetchRemoteInfo() {
        try {
            Session session = new Session(this.config.getProviderLocation());
            Metadata metadata = session.getMetadata();
            URI termsOfServiceUri = metadata.getTermsOfService();
            URL website = metadata.getWebsite();
            return XFuture.completedFuture((Object)new AcmeInfo(termsOfServiceUri, website));
        }
        catch (AcmeException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public XFuture<URL> openAccount(String email, KeyPair accountKeyPair) {
        try {
            log.info("open account");
            Session session = new Session("acme://letsencrypt.org/staging");
            Account account = new AccountBuilder().addContact("mailto:" + email).agreeToTermsOfService().useKeyPair(accountKeyPair).create(session);
            URL location = account.getLocation();
            log.info("account location=" + location);
            return XFuture.completedFuture((Object)location);
        }
        catch (AcmeException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public XFuture<ProxyOrder> placeOrder(URL accountUrl, KeyPair accountKeyPair) {
        try {
            log.info("reestablish account from location=" + accountUrl + " and keypair");
            Session session = new Session("acme://letsencrypt.org/staging");
            Login login = session.login(accountUrl, accountKeyPair);
            Account account = login.getAccount();
            log.info("create an order");
            String domainTemp = "something.com";
            Order order = account.newOrder().domain(domainTemp).create();
            this.checkAuthStatii(order);
            ArrayList<ProxyAuthorization> auths = new ArrayList<ProxyAuthorization>();
            for (Authorization auth : order.getAuthorizations()) {
                auths.add(new ProxyAuthorization(auth));
            }
            return XFuture.completedFuture((Object)new ProxyOrder(order, auths));
        }
        catch (AcmeException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public XFuture<CertAndSigningRequest> finalizeOrder(ProxyOrder order, KeyPair accountKeyPair, String email, String domain, String organization) {
        Stream stream = order.getOrder().getAuthorizations().stream();
        Stream<XFuture> futures = stream.map(auth -> this.processChallenge((Authorization)auth));
        XFuture results = (XFuture)futures.collect(XFutureCollector.allOf());
        return results.thenCompose(nothing -> this.finalizeOrder(order, domain, organization, accountKeyPair));
    }

    private XFuture<CertAndSigningRequest> finalizeOrder(ProxyOrder proxyOrder, String domain, String organization, KeyPair accountKeyPair) {
        XFuture xFuture;
        StringWriter writer = new StringWriter();
        try {
            Order order = proxyOrder.getOrder();
            CSRBuilder csrb = new CSRBuilder();
            csrb.addDomain(domain);
            csrb.setOrganization(organization);
            csrb.sign(accountKeyPair);
            byte[] csr = csrb.getEncoded();
            order.execute(csr);
            while (order.getStatus() != Status.VALID) {
                Thread.sleep(3000L);
                order.update();
            }
            csrb.write((Writer)writer);
            Certificate cert = order.getCertificate();
            xFuture = XFuture.completedFuture((Object)new CertAndSigningRequest(writer.toString(), cert.getCertificateChain()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException | AcmeException e) {
                throw SneakyThrow.sneak((Throwable)e);
            }
        }
        writer.close();
        return xFuture;
    }

    private XFuture<Void> processChallenge(Authorization auth) {
        try {
            Http01Challenge challenge = (Http01Challenge)auth.findChallenge("http-01");
            log.info("tell remote end to trigger a call now. status=" + auth.getStatus() + " domain=" + auth.getIdentifier().getDomain() + " expires=" + auth.getExpires());
            challenge.trigger();
            log.info("status after=" + auth.getStatus());
            while (auth.getStatus() != Status.VALID) {
                Thread.sleep(3000L);
                log.info("reupdate status");
                auth.update();
                log.info("updated to status=" + auth.getStatus());
            }
            return null;
        }
        catch (InterruptedException | AcmeException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    private void checkAuthStatii(Order order) {
        for (Authorization auth : order.getAuthorizations()) {
            Status status = auth.getStatus();
            log.info("checking auth=" + auth.getIdentifier().getDomain() + " status=" + status + " location=" + auth.getLocation() + " expires=" + auth.getExpires());
            if (status == Status.PENDING) continue;
            throw new ChallengeInBadStateException("challenge in bad state=" + auth.getJSON());
        }
    }
}

