/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.equivalence;

import java.io.IOException;
import javax.xml.transform.Source;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.xml.sax.SAXException;
import org.xmlmatchers.transform.IdentityTransformer;
import org.xmlmatchers.transform.StringResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEquivalentTo
extends TypeSafeMatcher<Source> {
    private final IdentityTransformer identity = new IdentityTransformer();
    private String control;

    private IsEquivalentTo(Source control) {
        this.control = this.convertToString(control);
    }

    public boolean matchesSafely(Source source) {
        String test = this.convertToString(source);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        try {
            return new Diff(this.control, test).identical();
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String convertToString(Source source) {
        StringResult result = new StringResult();
        this.identity.transform(source, result);
        return result.toString();
    }

    public void describeTo(Description description) {
        description.appendText("an XML document equivalent to " + this.control);
    }

    @Factory
    public static Matcher<Source> isEquivalentTo(Source control) {
        return new IsEquivalentTo(control);
    }

    @Factory
    public static Matcher<Source> equivalentTo(Source control) {
        return new IsEquivalentTo(control);
    }
}

