/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.MainThread;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.AdaptivePlusSDK;
import plus.adaptive.sdk.core.analytics.APAnalytics;
import plus.adaptive.sdk.core.managers.APSDKManager;
import plus.adaptive.sdk.core.providers.RepositoryProviderKt;
import plus.adaptive.sdk.core.providers.ViewControllerProviderKt;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.listeners.APSplashScreenListener;
import plus.adaptive.sdk.data.models.APAnalyticsEvent;
import plus.adaptive.sdk.data.models.APLocation;
import plus.adaptive.sdk.data.models.APUser;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.ui.splashscreen.APSplashScreenViewController;
import plus.adaptive.sdk.utils.APUserUtilsKt;
import plus.adaptive.sdk.utils.APViewUtilsKt;
import plus.adaptive.sdk.utils.QAAppUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0007\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u00020\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u001e\u001a\u00020\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010 \u001a\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0016J\u001e\u0010\"\u001a\u00020\u00012\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0001H\u0017J\b\u0010&\u001a\u00020\u0001H\u0017J\u0010\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\fH\u0017J\b\u0010(\u001a\u00020\u0001H\u0017J\b\u0010)\u001a\u00020\u0001H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lplus/adaptive/sdk/AdaptivePlusSDKImpl;", "Lplus/adaptive/sdk/AdaptivePlusSDK;", "context", "Landroid/content/Context;", "sdkManager", "Lplus/adaptive/sdk/core/managers/APSDKManager;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Landroid/content/Context;Lplus/adaptive/sdk/core/managers/APSDKManager;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "splashScreenListener", "Lplus/adaptive/sdk/data/listeners/APSplashScreenListener;", "userIdIsChanged", "", "init", "", "setBaseSdkUrl", "setBaseSdkUrlFromManifest", "setEnvName", "url", "", "setIsDebuggable", "isDebuggable", "setLocale", "locale", "Ljava/util/Locale;", "setLocation", "location", "Lplus/adaptive/sdk/data/models/APLocation;", "setOptions", "setQaBaseUrl", "setSplashScreenListener", "listener", "setUserId", "userId", "setUserProperties", "userProperties", "", "showMockSplashScreen", "showSplashScreen", "hasDrafts", "start", "stop", "Companion", "sdk_release"})
public final class AdaptivePlusSDKImpl
implements AdaptivePlusSDK {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final APSDKManager sdkManager;
    @NotNull
    private final APUserRepository userRepository;
    @Nullable
    private APSplashScreenListener splashScreenListener;
    private boolean userIdIsChanged;
    @Nullable
    private static String externalUserId;
    @Nullable
    private static Map<String, String> userProperties;
    @Nullable
    private static APLocation userLocation;

    public AdaptivePlusSDKImpl(@NotNull Context context, @NotNull APSDKManager sdkManager, @NotNull APUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkManager, (String)"sdkManager");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.context = context;
        this.sdkManager = sdkManager;
        this.userRepository = userRepository;
    }

    private final void init() {
        APUserRepository aPUserRepository = this.userRepository;
        boolean bl = false;
        boolean bl2 = false;
        APUserRepository $this$init_u24lambda_u2d0 = aPUserRepository;
        boolean bl3 = false;
        $this$init_u24lambda_u2d0.setExternalUserId(externalUserId);
        $this$init_u24lambda_u2d0.setUserProperties(userProperties);
        $this$init_u24lambda_u2d0.setUserLocation(userLocation);
        String string2 = APUserUtilsKt.getDeviceId(this.context);
        String string3 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MANUFACTURER");
        String string4 = string3;
        string3 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MODEL");
        String string5 = string3;
        APUser.Device.Type type = APUserUtilsKt.getDeviceType(this.context);
        string3 = APConstantsKt.getLOCALE().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"LOCALE.language");
        String string6 = string3;
        string3 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"RELEASE");
        String string7 = string3;
        string3 = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.packageName");
        String string8 = string3;
        string3 = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.packageName");
        $this$init_u24lambda_u2d0.setUserDevice(new APUser.Device(string2, string4, string5, type, string6, "android", string7, string8, string3, APUserUtilsKt.getAppVersion(this.context), "2.3.5", false, APUserUtilsKt.getMobileOperatorName(this.context), APUserUtilsKt.getMobileCountryCode(this.context), APUserUtilsKt.getMobileNetworkCode(this.context), 2048, null));
        APViewUtilsKt.countDpiAndSteKoef(this.context);
        APAnalytics.Companion.init(this.userRepository, RepositoryProviderKt.provideAPAnalyticsRepository(this.context));
    }

    @Override
    @MainThread
    @NotNull
    public AdaptivePlusSDK start() {
        this.init();
        if (!this.sdkManager.isStarted()) {
            APAnalytics.Companion.logEvent(new APAnalyticsEvent("launch-sdk", null, null, null, null, null, 62, null));
            this.sdkManager.start();
        }
        this.setBaseSdkUrl();
        this.sdkManager.authorize(this.userIdIsChanged, null);
        this.setOptions();
        return this;
    }

    private final void setOptions() {
        String string2 = this.userRepository.getBrandColor();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            APConstantsKt.setBRAND_COLOR(it);
        }
    }

    private final void setBaseSdkUrl() {
        if (Intrinsics.areEqual((Object)this.context.getPackageName(), (Object)"plus.adaptive.qaapp")) {
            Unit unit;
            Unit unit2;
            String string2 = APConstantsKt.getQA_API_URL();
            if (string2 == null) {
                unit2 = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                APConstantsKt.setSDK_API_URL(it);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                this.setBaseSdkUrlFromManifest();
            }
        } else {
            this.setBaseSdkUrlFromManifest();
        }
    }

    private final void setBaseSdkUrlFromManifest() {
        String string2;
        ApplicationInfo applicationInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.getApplicationInfo(\n            context.packageName,\n            PackageManager.GET_META_DATA\n        )");
        ApplicationInfo appInfo = applicationInfo;
        Bundle bundle = appInfo.metaData;
        String string3 = applicationInfo = bundle == null ? null : bundle.getString("adaptiveBaseApiUrl");
        if (applicationInfo == null) {
            string2 = "";
        } else {
            ApplicationInfo applicationInfo2 = applicationInfo;
            boolean bl = false;
            boolean bl2 = false;
            ApplicationInfo url = applicationInfo2;
            boolean bl3 = false;
            bundle = url;
            string2 = bundle;
        }
        APConstantsKt.setSDK_API_URL(string2);
    }

    @Override
    @MainThread
    @NotNull
    public AdaptivePlusSDK stop() {
        this.sdkManager.stop();
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setUserId(@Nullable String userId) {
        if (!Intrinsics.areEqual((Object)this.userRepository.getExternalUserId(), (Object)userId)) {
            this.userIdIsChanged = true;
        }
        externalUserId = userId;
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setUserProperties(@Nullable Map<String, String> userProperties) {
        AdaptivePlusSDKImpl.userProperties = userProperties;
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setLocation(@Nullable APLocation location) {
        userLocation = location;
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setLocale(@Nullable Locale locale) {
        AdaptivePlusSDK.Companion.setLocale(locale);
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setIsDebuggable(boolean isDebuggable) {
        AdaptivePlusSDK.Companion.setIsDebuggable(isDebuggable);
        return this;
    }

    @Override
    @MainThread
    @NotNull
    public AdaptivePlusSDK showSplashScreen() {
        return this.showSplashScreen(false);
    }

    @Override
    @MainThread
    @NotNull
    public AdaptivePlusSDK showSplashScreen(boolean hasDrafts) {
        this.start();
        APSplashScreenViewController aPSplashScreenViewController = ViewControllerProviderKt.provideAPSplashScreenViewController(this.context);
        boolean bl = false;
        boolean bl2 = false;
        APSplashScreenViewController $this$showSplashScreen_u24lambda_u2d4 = aPSplashScreenViewController;
        boolean bl3 = false;
        $this$showSplashScreen_u24lambda_u2d4.setSplashScreenListener(this.splashScreenListener);
        $this$showSplashScreen_u24lambda_u2d4.show(hasDrafts);
        return this;
    }

    @Override
    @MainThread
    @NotNull
    public AdaptivePlusSDK showMockSplashScreen() {
        if (QAAppUtilsKt.isQAApp(this.context)) {
            APSplashScreenViewController aPSplashScreenViewController = ViewControllerProviderKt.provideAPSplashScreenViewController(this.context);
            boolean bl = false;
            boolean bl2 = false;
            APSplashScreenViewController $this$showMockSplashScreen_u24lambda_u2d5 = aPSplashScreenViewController;
            boolean bl3 = false;
            $this$showMockSplashScreen_u24lambda_u2d5.setSplashScreenListener(this.splashScreenListener);
            $this$showMockSplashScreen_u24lambda_u2d5.showMock();
        }
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setSplashScreenListener(@Nullable APSplashScreenListener listener) {
        this.splashScreenListener = listener;
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setQaBaseUrl(@Nullable String url) {
        APConstantsKt.setQA_API_URL(url);
        return this;
    }

    @Override
    @NotNull
    public AdaptivePlusSDK setEnvName(@Nullable String url) {
        String string2 = url;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            APConstantsKt.setENV_NAME(it);
        }
        return this;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lplus/adaptive/sdk/AdaptivePlusSDKImpl$Companion;", "", "()V", "externalUserId", "", "userLocation", "Lplus/adaptive/sdk/data/models/APLocation;", "userProperties", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

