/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.analytics;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.models.APAnalyticsEvent;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.models.network.RequestState;
import plus.adaptive.sdk.data.models.story.APAnalyticsEventBuffer;
import plus.adaptive.sdk.data.repositories.APAnalyticsRepository;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.utils.AsyncUtilsKt;
import plus.adaptive.sdk.utils.DateTimeUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lplus/adaptive/sdk/core/analytics/APAnalytics;", "", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "analyticsRepository", "Lplus/adaptive/sdk/data/repositories/APAnalyticsRepository;", "(Lplus/adaptive/sdk/data/repositories/APUserRepository;Lplus/adaptive/sdk/data/repositories/APAnalyticsRepository;)V", "lastErrorTime", "", "lastSubmitTime", "submitRequestState", "Lplus/adaptive/sdk/data/models/network/RequestState;", "task", "Lkotlin/Function0;", "", "getInstance", "Lplus/adaptive/sdk/data/models/story/APAnalyticsEventBuffer;", "logEvent", "event", "Lplus/adaptive/sdk/data/models/APAnalyticsEvent;", "logEvents", "events", "", "runCheckTask", "isError", "", "saveEventBufferToSharedPref", "analyticBuffer", "submitEvents", "submitOrSave", "Companion", "sdk_release"})
public final class APAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final APUserRepository userRepository;
    @NotNull
    private final APAnalyticsRepository analyticsRepository;
    @NotNull
    private volatile RequestState submitRequestState;
    private long lastSubmitTime;
    private long lastErrorTime;
    @NotNull
    private final Function0<Unit> task;
    @NotNull
    public static final String AP_ANALYTICS_BUFFER = "ap_analytics_buffer";
    @NotNull
    public static final String TAG = "APAnalytics";
    private static final long ERROR_STATE_TIMEOUT = 15000L;
    private static long SUBMIT_REQUEST_TIMEOUT = 120000L;
    private static int EVENTS_SUBMIT_COUNT = 25;
    @Nullable
    private static APAnalytics analyticsInstance;
    @Nullable
    private static volatile APAnalyticsEventBuffer instance;

    private APAnalytics(APUserRepository userRepository, APAnalyticsRepository analyticsRepository) {
        this.userRepository = userRepository;
        this.analyticsRepository = analyticsRepository;
        this.submitRequestState = RequestState.NONE;
        this.task = (Function0)new Function0<Unit>(this){
            final /* synthetic */ APAnalytics this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                long currentTime = System.currentTimeMillis();
                if (currentTime - APAnalytics.access$getLastSubmitTime$p(this.this$0) > APAnalytics.access$getSUBMIT_REQUEST_TIMEOUT$cp() - (long)200) {
                    APAnalytics.access$submitEvents(this.this$0);
                } else {
                    APAnalytics.runCheckTask$default(this.this$0, false, 1, null);
                }
            }
        };
        this.lastSubmitTime = System.currentTimeMillis();
        new Thread(() -> APAnalytics._init_$lambda-0(this)).start();
    }

    private final APAnalyticsEventBuffer getInstance() {
        APAnalyticsEventBuffer aPAnalyticsEventBuffer;
        if (instance == null) {
            instance = this.userRepository.getAnalyticsBuffer();
        }
        if ((aPAnalyticsEventBuffer = instance) == null) {
            throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.story.APAnalyticsEventBuffer");
        }
        return aPAnalyticsEventBuffer;
    }

    private final void saveEventBufferToSharedPref(APAnalyticsEventBuffer analyticBuffer) {
        this.userRepository.saveAnalyticsBuffer(analyticBuffer);
    }

    private final void logEvent(APAnalyticsEvent event) {
        if (this.userRepository.getIsEventTrackingDisabled()) {
            return;
        }
        event.setCreatedAt(DateTimeUtilsKt.getCurrentTimeString$default(null, 1, null));
        ((ArrayList)this.getInstance().getNotSubmittedEvents()).add(event);
        this.submitOrSave();
    }

    private final void logEvents(List<APAnalyticsEvent> events) {
        if (this.userRepository.getIsEventTrackingDisabled()) {
            return;
        }
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            APAnalyticsEvent it = (APAnalyticsEvent)element$iv;
            boolean bl = false;
            it.setCreatedAt(DateTimeUtilsKt.getCurrentTimeString$default(null, 1, null));
        }
        ((ArrayList)this.getInstance().getNotSubmittedEvents()).addAll((Collection)events);
        this.submitOrSave();
    }

    private final void submitOrSave() {
        if (this.getInstance().getNotSubmittedEvents().size() >= EVENTS_SUBMIT_COUNT) {
            this.submitEvents();
        } else {
            this.saveEventBufferToSharedPref(this.getInstance());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void submitEvents() {
        void $this$mapTo$iv$iv;
        long currentTime = System.currentTimeMillis();
        if (this.submitRequestState == RequestState.IN_PROCESS || currentTime - this.lastErrorTime < 14950L) {
            return;
        }
        if (this.getInstance().getNotSubmittedEvents().isEmpty()) {
            APAnalytics.runCheckTask$default(this, false, 1, null);
            return;
        }
        this.submitRequestState = RequestState.IN_PROCESS;
        Iterable $this$map$iv = this.getInstance().getNotSubmittedEvents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it;
            boolean bl;
            boolean bl2;
            String string2;
            void event;
            APAnalyticsEvent aPAnalyticsEvent = (APAnalyticsEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Map map = MapsKt.toMutableMap(event.getParams());
            boolean bl4 = false;
            boolean bl5 = false;
            Map $this$submitEvents_u24lambda_u2d6_u24lambda_u2d5 = map;
            boolean bl6 = false;
            $this$submitEvents_u24lambda_u2d6_u24lambda_u2d5.put("eventName", event.getName());
            String string3 = event.getApViewId();
            if (string3 != null) {
                string2 = string3;
                bl2 = false;
                bl = false;
                it = string2;
                boolean bl7 = false;
                $this$submitEvents_u24lambda_u2d6_u24lambda_u2d5.put("apViewId", it);
            }
            string3 = event.getCampaignId();
            if (string3 != null) {
                string2 = string3;
                bl2 = false;
                bl = false;
                it = string2;
                boolean bl8 = false;
                $this$submitEvents_u24lambda_u2d6_u24lambda_u2d5.put("campaignId", it);
            }
            string3 = event.getCreatedAt();
            if (string3 != null) {
                string2 = string3;
                bl2 = false;
                bl = false;
                it = string2;
                boolean bl9 = false;
                $this$submitEvents_u24lambda_u2d6_u24lambda_u2d5.put("createdAt", it);
            }
            Map map2 = map;
            collection.add(map2);
        }
        List events = (List)destination$iv$iv;
        this.analyticsRepository.submitAnalytics(events, new RequestResultCallback<Object>(this){
            final /* synthetic */ APAnalytics this$0;
            {
                this.this$0 = $receiver;
            }

            public void success(@Nullable Object response) {
                APAnalytics.access$getInstance(this.this$0).clear();
                APAnalytics.access$saveEventBufferToSharedPref(this.this$0, APAnalytics.access$getInstance(this.this$0));
                APAnalytics.access$setSubmitRequestState$p(this.this$0, RequestState.SUCCESS);
                APAnalytics.access$setLastSubmitTime$p(this.this$0, System.currentTimeMillis());
                APAnalytics.runCheckTask$default(this.this$0, false, 1, null);
            }

            public void failure(@Nullable APError error) {
                APAnalytics.access$setSubmitRequestState$p(this.this$0, RequestState.ERROR);
                APAnalytics.access$setLastErrorTime$p(this.this$0, System.currentTimeMillis());
                APAnalytics.access$runCheckTask(this.this$0, true);
            }
        });
    }

    private final void runCheckTask(boolean isError) {
        if (isError) {
            AsyncUtilsKt.runDelayedTask(this.task, 15000L);
        } else {
            Looper looper;
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            if ((looper = Looper.getMainLooper()) != null) {
                Looper looper2 = looper;
                boolean bl = false;
                boolean bl2 = false;
                Looper looper3 = looper2;
                boolean bl3 = false;
                new Handler(looper3).postDelayed(() -> APAnalytics.runCheckTask$lambda-8$lambda-7(this), SUBMIT_REQUEST_TIMEOUT);
            }
        }
    }

    static /* synthetic */ void runCheckTask$default(APAnalytics aPAnalytics, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        aPAnalytics.runCheckTask(bl);
    }

    private static final void _init_$lambda-0(APAnalytics this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        APAnalytics.runCheckTask$default(this$0, false, 1, null);
    }

    private static final void runCheckTask$lambda-8$lambda-7(APAnalytics this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.task.invoke();
    }

    public /* synthetic */ APAnalytics(APUserRepository userRepository, APAnalyticsRepository analyticsRepository, DefaultConstructorMarker $constructor_marker) {
        this(userRepository, analyticsRepository);
    }

    public static final /* synthetic */ APAnalyticsEventBuffer access$getInstance(APAnalytics $this) {
        return $this.getInstance();
    }

    public static final /* synthetic */ void access$saveEventBufferToSharedPref(APAnalytics $this, APAnalyticsEventBuffer analyticBuffer) {
        $this.saveEventBufferToSharedPref(analyticBuffer);
    }

    public static final /* synthetic */ void access$setSubmitRequestState$p(APAnalytics $this, RequestState requestState) {
        $this.submitRequestState = requestState;
    }

    public static final /* synthetic */ void access$setLastSubmitTime$p(APAnalytics $this, long l) {
        $this.lastSubmitTime = l;
    }

    public static final /* synthetic */ void access$setLastErrorTime$p(APAnalytics $this, long l) {
        $this.lastErrorTime = l;
    }

    public static final /* synthetic */ void access$runCheckTask(APAnalytics $this, boolean isError) {
        $this.runCheckTask(isError);
    }

    public static final /* synthetic */ long access$getLastSubmitTime$p(APAnalytics $this) {
        return $this.lastSubmitTime;
    }

    public static final /* synthetic */ long access$getSUBMIT_REQUEST_TIMEOUT$cp() {
        return SUBMIT_REQUEST_TIMEOUT;
    }

    public static final /* synthetic */ void access$submitEvents(APAnalytics $this) {
        $this.submitEvents();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J\u001f\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lplus/adaptive/sdk/core/analytics/APAnalytics$Companion;", "", "()V", "AP_ANALYTICS_BUFFER", "", "ERROR_STATE_TIMEOUT", "", "EVENTS_SUBMIT_COUNT", "", "SUBMIT_REQUEST_TIMEOUT", "TAG", "analyticsInstance", "Lplus/adaptive/sdk/core/analytics/APAnalytics;", "instance", "Lplus/adaptive/sdk/data/models/story/APAnalyticsEventBuffer;", "init", "", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "analyticsRepository", "Lplus/adaptive/sdk/data/repositories/APAnalyticsRepository;", "logEvent", "event", "Lplus/adaptive/sdk/data/models/APAnalyticsEvent;", "logEvents", "events", "", "reset", "updateConfig", "timeout", "eventCount", "(Ljava/lang/Long;Ljava/lang/Integer;)V", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void reset() {
            SUBMIT_REQUEST_TIMEOUT = 120000L;
            EVENTS_SUBMIT_COUNT = 25;
            analyticsInstance = null;
        }

        public final void init(@NotNull APUserRepository userRepository, @NotNull APAnalyticsRepository analyticsRepository) {
            Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
            Intrinsics.checkNotNullParameter((Object)analyticsRepository, (String)"analyticsRepository");
            analyticsInstance = new APAnalytics(userRepository, analyticsRepository, null);
        }

        public final void logEvent(@NotNull APAnalyticsEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Thread thread2 = new Thread(() -> Companion.logEvent$lambda-0(event));
            thread2.start();
            thread2.join();
        }

        public final void logEvents(@NotNull List<APAnalyticsEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Thread thread2 = new Thread(() -> Companion.logEvents$lambda-1(events));
            thread2.start();
            thread2.join();
        }

        public final void updateConfig(@Nullable Long timeout, @Nullable Integer eventCount) {
            boolean bl;
            boolean bl2;
            Long l;
            Number number = timeout;
            if (number != null) {
                l = number;
                bl2 = false;
                bl = false;
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                SUBMIT_REQUEST_TIMEOUT = it;
            }
            number = eventCount;
            if (number != null) {
                l = number;
                bl2 = false;
                bl = false;
                int it = ((Number)l).intValue();
                boolean bl4 = false;
                EVENTS_SUBMIT_COUNT = it;
            }
        }

        private static final void logEvent$lambda-0(APAnalyticsEvent $event) {
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            APAnalytics aPAnalytics = analyticsInstance;
            if (aPAnalytics != null) {
                aPAnalytics.logEvent($event);
            }
        }

        private static final void logEvents$lambda-1(List $events) {
            Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
            APAnalytics aPAnalytics = analyticsInstance;
            if (aPAnalytics != null) {
                aPAnalytics.logEvents($events);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

