/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.glide;

import android.graphics.drawable.Drawable;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.glide.GlideWrappingTarget;
import plus.adaptive.sdk.core.glide.OkHttpProgressGlideModule;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\u00020\u0004B\u001d\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0014J\b\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\rH\u0014J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u0012\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001c\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J'\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00028\u00012\u0010\u0010 \u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0001\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\rH\u0002J\u0017\u0010$\u001a\u00020%2\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006'"}, d2={"Lplus/adaptive/sdk/core/glide/GlideProgressTarget;", "T", "Z", "Lplus/adaptive/sdk/core/glide/GlideWrappingTarget;", "Lplus/adaptive/sdk/core/glide/OkHttpProgressGlideModule$UIProgressListener;", "model", "target", "Lcom/bumptech/glide/request/target/Target;", "(Ljava/lang/Object;Lcom/bumptech/glide/request/target/Target;)V", "ignoreProgress", "", "Ljava/lang/Object;", "cleanup", "", "getGranularityPercentage", "", "onConnecting", "onDelivered", "onDownloaded", "onDownloading", "bytesRead", "", "expectedLength", "onLoadCleared", "placeholder", "Landroid/graphics/drawable/Drawable;", "onLoadFailed", "errorDrawable", "onLoadStarted", "onProgress", "onResourceReady", "resource", "transition", "Lcom/bumptech/glide/request/transition/Transition;", "(Ljava/lang/Object;Lcom/bumptech/glide/request/transition/Transition;)V", "start", "toUrlString", "", "(Ljava/lang/Object;)Ljava/lang/String;", "sdk_release"})
public class GlideProgressTarget<T, Z>
extends GlideWrappingTarget<Z>
implements OkHttpProgressGlideModule.UIProgressListener {
    @Nullable
    private T model;
    private boolean ignoreProgress;

    public GlideProgressTarget(@Nullable T model, @NotNull Target<Z> target2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        super(target2);
        this.model = model;
        this.ignoreProgress = true;
    }

    protected void onConnecting() {
    }

    protected void onDownloading(long bytesRead, long expectedLength) {
    }

    protected void onDownloaded() {
    }

    protected void onDelivered() {
    }

    private final String toUrlString(T model) {
        String string = String.valueOf(model);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueOf(model)");
        return string;
    }

    @Override
    public void onProgress(long bytesRead, long expectedLength) {
        if (this.ignoreProgress) {
            return;
        }
        if (expectedLength == Long.MAX_VALUE) {
            this.onConnecting();
        } else if (bytesRead == expectedLength) {
            this.onDownloaded();
        } else {
            this.onDownloading(bytesRead, expectedLength);
        }
    }

    @Override
    public float getGranularityPercentage() {
        return 0.1f;
    }

    private final void start() {
        OkHttpProgressGlideModule.Companion.expect(this.toUrlString(this.model), this);
        this.ignoreProgress = false;
        this.onProgress(0L, Long.MAX_VALUE);
    }

    private final void cleanup() {
        this.ignoreProgress = true;
        T model = this.model;
        this.onDelivered();
        OkHttpProgressGlideModule.Companion.forget(this.toUrlString(model));
        this.model = null;
    }

    @Override
    public void onLoadStarted(@Nullable Drawable placeholder) {
        super.onLoadStarted(placeholder);
        this.start();
    }

    @Override
    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        this.cleanup();
        super.onLoadFailed(errorDrawable);
    }

    @Override
    public void onResourceReady(Z resource, @Nullable Transition<? super Z> transition) {
        this.cleanup();
        super.onResourceReady(resource, transition);
    }

    @Override
    public void onLoadCleared(@Nullable Drawable placeholder) {
        this.cleanup();
        super.onLoadCleared(placeholder);
    }
}

