/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.managers;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import androidx.fragment.app.DialogFragment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APActionsManager;
import plus.adaptive.sdk.data.listeners.APCustomActionListener;
import plus.adaptive.sdk.data.models.APStory;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.models.actions.APCallPhoneAction;
import plus.adaptive.sdk.data.models.actions.APCustomAction;
import plus.adaptive.sdk.data.models.actions.APOpenWebLinkAction;
import plus.adaptive.sdk.data.models.actions.APSendSMSAction;
import plus.adaptive.sdk.data.models.actions.APShowStoryAction;
import plus.adaptive.sdk.ui.ViewControllerDelegateProtocol;
import plus.adaptive.sdk.ui.apview.vm.APViewVMDelegateProtocol;
import plus.adaptive.sdk.ui.dialogs.WebViewDialog;
import plus.adaptive.sdk.ui.stories.APStoriesDialog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001cH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lplus/adaptive/sdk/core/managers/APActionsManagerImpl;", "Lplus/adaptive/sdk/core/managers/APActionsManager;", "viewControllerDelegate", "Lplus/adaptive/sdk/ui/ViewControllerDelegateProtocol;", "apViewVMDelegate", "Lplus/adaptive/sdk/ui/apview/vm/APViewVMDelegateProtocol;", "(Lplus/adaptive/sdk/ui/ViewControllerDelegateProtocol;Lplus/adaptive/sdk/ui/apview/vm/APViewVMDelegateProtocol;)V", "apCustomActionListener", "Lplus/adaptive/sdk/data/listeners/APCustomActionListener;", "apStories", "", "Lplus/adaptive/sdk/data/models/APStory;", "callPhone", "", "action", "Lplus/adaptive/sdk/data/models/actions/APCallPhoneAction;", "openWebView", "Lplus/adaptive/sdk/data/models/actions/APOpenWebLinkAction;", "runAPCustomAction", "Lplus/adaptive/sdk/data/models/actions/APCustomAction;", "runAction", "Lplus/adaptive/sdk/data/models/actions/APAction;", "sendSms", "Lplus/adaptive/sdk/data/models/actions/APSendSMSAction;", "setAPCustomActionListener", "listener", "setAPStories", "showAPStory", "Lplus/adaptive/sdk/data/models/actions/APShowStoryAction;", "sdk_release"})
public final class APActionsManagerImpl
implements APActionsManager {
    @NotNull
    private final ViewControllerDelegateProtocol viewControllerDelegate;
    @Nullable
    private final APViewVMDelegateProtocol apViewVMDelegate;
    @Nullable
    private APCustomActionListener apCustomActionListener;
    @Nullable
    private List<APStory> apStories;

    public APActionsManagerImpl(@NotNull ViewControllerDelegateProtocol viewControllerDelegate, @Nullable APViewVMDelegateProtocol apViewVMDelegate) {
        Intrinsics.checkNotNullParameter((Object)viewControllerDelegate, (String)"viewControllerDelegate");
        this.viewControllerDelegate = viewControllerDelegate;
        this.apViewVMDelegate = apViewVMDelegate;
    }

    @Override
    public void setAPStories(@Nullable List<APStory> apStories) {
        this.apStories = apStories;
    }

    @Override
    public void setAPCustomActionListener(@Nullable APCustomActionListener listener) {
        this.apCustomActionListener = listener;
    }

    @Override
    public void runAction(@NotNull APAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        APAction aPAction = action;
        if (aPAction instanceof APOpenWebLinkAction) {
            this.openWebView((APOpenWebLinkAction)action);
        } else if (aPAction instanceof APCustomAction) {
            this.runAPCustomAction((APCustomAction)action);
        } else if (aPAction instanceof APShowStoryAction) {
            this.showAPStory((APShowStoryAction)action);
        } else if (aPAction instanceof APSendSMSAction) {
            this.sendSms((APSendSMSAction)action);
        } else if (aPAction instanceof APCallPhoneAction) {
            this.callPhone((APCallPhoneAction)action);
        }
    }

    private final void openWebView(APOpenWebLinkAction action) {
        if (Intrinsics.areEqual((Object)action.isWebView(), (Object)true)) {
            APViewVMDelegateProtocol aPViewVMDelegateProtocol = this.apViewVMDelegate;
            if (aPViewVMDelegateProtocol != null) {
                aPViewVMDelegateProtocol.pauseAPStories();
            }
            WebViewDialog webViewDialog = WebViewDialog.Companion.newInstance(action.getUrl());
            boolean bl = false;
            boolean bl2 = false;
            WebViewDialog $this$openWebView_u24lambda_u2d1 = webViewDialog;
            boolean bl3 = false;
            $this$openWebView_u24lambda_u2d1.addOnDismissListener(() -> APActionsManagerImpl.openWebView$lambda-1$lambda-0(this));
            WebViewDialog webViewDialog2 = webViewDialog;
            this.viewControllerDelegate.showDialog((DialogFragment)webViewDialog2);
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)action.getUrl()));
                this.viewControllerDelegate.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private final void runAPCustomAction(APCustomAction action) {
        HashMap<String, Object> hashMap = action.getParameters();
        if (hashMap != null) {
            HashMap<String, Object> hashMap2 = hashMap;
            boolean bl = false;
            boolean bl2 = false;
            HashMap<String, Object> it = hashMap2;
            boolean bl3 = false;
            this.viewControllerDelegate.dismissAllDialogs();
            APCustomActionListener aPCustomActionListener = this.apCustomActionListener;
            if (aPCustomActionListener != null) {
                aPCustomActionListener.onRun(action);
            }
        }
    }

    private final void showAPStory(APShowStoryAction action) {
        List<APStory> list = this.apStories;
        if (list != null) {
            int storyIndex;
            List<APStory> stories;
            block4: {
                int n;
                List<APStory> list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                stories = list2;
                boolean bl3 = false;
                List<APStory> $this$indexOfFirst$iv = stories;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<APStory> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    APStory item$iv;
                    APStory it = item$iv = iterator.next();
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)action.getStory().getId())) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = storyIndex = -1;
            }
            if (storyIndex != -1 && this.apViewVMDelegate != null) {
                APStoriesDialog apStoriesDialog = APStoriesDialog.Companion.newInstance(stories, storyIndex, this.apViewVMDelegate);
                this.viewControllerDelegate.showDialog(apStoriesDialog);
            }
        }
    }

    private final void sendSms(APSendSMSAction action) {
        Uri uri = Uri.parse((String)Intrinsics.stringPlus((String)"smsto:", (Object)action.getPhoneNumber()));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", action.getMessage());
        this.viewControllerDelegate.startActivity(intent);
    }

    private final void callPhone(APCallPhoneAction action) {
        Uri uri = Uri.parse((String)Intrinsics.stringPlus((String)"tel:", (Object)action.getPhoneNumber()));
        Intent intent = new Intent("android.intent.action.DIAL", uri);
        this.viewControllerDelegate.startActivity(intent);
    }

    private static final void openWebView$lambda-1$lambda-0(APActionsManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        APViewVMDelegateProtocol aPViewVMDelegateProtocol = this$0.apViewVMDelegate;
        if (aPViewVMDelegateProtocol != null) {
            aPViewVMDelegateProtocol.resumeAPStories();
        }
    }
}

