/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.managers;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APCacheManager;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APSplashScreenViewDataModel;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.utils.GsonUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u0007\u001a\u00020\b2#\u0010\t\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J-\u0010\u000f\u001a\u00020\b2#\u0010\t\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J-\u0010\u0010\u001a\u00020\b2#\u0010\t\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J5\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142#\u0010\t\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J \u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lplus/adaptive/sdk/core/managers/APCacheManagerImpl;", "Lplus/adaptive/sdk/core/managers/APCacheManager;", "context", "Landroid/content/Context;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Landroid/content/Context;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "loadAPSplashScreenViewDataModelFromAssets", "", "onResult", "Lkotlin/Function1;", "Lplus/adaptive/sdk/data/models/APSplashScreenViewDataModel;", "Lkotlin/ParameterName;", "name", "dataModel", "loadAPSplashScreenViewDataModelFromCache", "loadAPTemplateViewDataModelFromAssets", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "loadAPTemplateViewDataModelFromCache", "apViewId", "", "removeAPSplashScreenViewDataModelFromCache", "saveAPSplashScreenViewDataModelToCache", "onSuccess", "Lkotlin/Function0;", "saveAPTemplateViewDataModelToCache", "sdk_release"})
public final class APCacheManagerImpl
implements APCacheManager {
    @NotNull
    private final Context context;
    @NotNull
    private final APUserRepository userRepository;

    public APCacheManagerImpl(@NotNull Context context, @NotNull APUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.context = context;
        this.userRepository = userRepository;
    }

    @Override
    public void loadAPTemplateViewDataModelFromCache(@NotNull String apViewId, @NotNull Function1<? super APTemplateDataModel, Unit> onResult) {
        Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        try {
            File dataModelFile;
            File file = dataModelFile = new File(this.context.getCacheDir(), APConstantsKt.getENV_NAME() + "_template_" + apViewId + ".json");
            boolean bl = false;
            InputStream inputStream = new FileInputStream(file);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String json = new String(buffer, charset);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson templateGson = gsonBuilder.create();
            APTemplateDataModel dataModel = (APTemplateDataModel)templateGson.fromJson(json, APTemplateDataModel.class);
            onResult.invoke((Object)dataModel);
        }
        catch (FileNotFoundException ex) {
            onResult.invoke(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            onResult.invoke(null);
        }
    }

    @Override
    public void saveAPTemplateViewDataModelToCache(@NotNull String apViewId, @NotNull APTemplateDataModel dataModel) {
        Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
        Intrinsics.checkNotNullParameter((Object)dataModel, (String)"dataModel");
        try {
            new Thread(() -> APCacheManagerImpl.saveAPTemplateViewDataModelToCache$lambda-0(this, apViewId, dataModel)).start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void loadAPSplashScreenViewDataModelFromAssets(@NotNull Function1<? super APSplashScreenViewDataModel, Unit> onResult) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        try {
            InputStream inputStream = this.context.getAssets().open("splashscreen.json");
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"splashscreen.json\")");
            InputStream inputStream2 = inputStream;
            int size = inputStream2.available();
            byte[] buffer = new byte[size];
            inputStream2.read(buffer);
            inputStream2.close();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String json = new String(buffer, charset);
            APSplashScreenViewDataModel dataModel = GsonUtilsKt.getDeserializedUnprocessedAPSplashScreenViewDataModel(json);
            onResult.invoke((Object)dataModel);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            onResult.invoke(null);
        }
    }

    @Override
    public void loadAPTemplateViewDataModelFromAssets(@NotNull Function1<? super APTemplateDataModel, Unit> onResult) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        try {
            InputStream inputStream = this.context.getAssets().open("stories.json");
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"stories.json\")");
            InputStream inputStream2 = inputStream;
            int size = inputStream2.available();
            byte[] buffer = new byte[size];
            inputStream2.read(buffer);
            inputStream2.close();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String json = new String(buffer, charset);
            APTemplateDataModel dataModel = GsonUtilsKt.getDeserializedUnprocessedAPTemplateViewDataModel(json);
            onResult.invoke((Object)dataModel);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            onResult.invoke(null);
        }
    }

    @Override
    public void loadAPSplashScreenViewDataModelFromCache(@NotNull Function1<? super APSplashScreenViewDataModel, Unit> onResult) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        try {
            File dataModelFile;
            File file = dataModelFile = new File(this.context.getCacheDir(), Intrinsics.stringPlus((String)APConstantsKt.getENV_NAME(), (Object)"_splashscreen.json"));
            boolean bl = false;
            InputStream inputStream = new FileInputStream(file);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String json = new String(buffer, charset);
            APSplashScreenViewDataModel dataModel = GsonUtilsKt.getDeserializedProcessedAPSplashScreenViewDataModel(json);
            onResult.invoke((Object)dataModel);
        }
        catch (FileNotFoundException ex) {
            onResult.invoke(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            onResult.invoke(null);
        }
    }

    @Override
    public void saveAPSplashScreenViewDataModelToCache(@NotNull APSplashScreenViewDataModel dataModel, @Nullable Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)dataModel, (String)"dataModel");
        try {
            File dataModelFile = new File(this.context.getCacheDir(), Intrinsics.stringPlus((String)APConstantsKt.getENV_NAME(), (Object)"_splashscreen.json"));
            dataModelFile.createNewFile();
            File file = dataModelFile;
            boolean bl = false;
            OutputStream outputStream = new FileOutputStream(file);
            Function0<Unit> json = GsonUtilsKt.getSerializedProcessedAPSplashScreenViewDataModel(dataModel);
            if (json != null) {
                Function0<Unit> function0 = json;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                byte[] byArray = function0.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
                function0 = onSuccess;
                if (function0 != null) {
                    function0.invoke();
                }
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeAPSplashScreenViewDataModelFromCache() {
        try {
            String string2 = this.userRepository.getAPUserId();
            String userId = string2 == null ? "" : string2;
            File dataModelFile = new File(this.context.getCacheDir(), Intrinsics.stringPlus((String)userId, (Object)"_splashscreen.json"));
            dataModelFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static final void saveAPTemplateViewDataModelToCache$lambda-0(APCacheManagerImpl this$0, String $apViewId, APTemplateDataModel $dataModel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$apViewId, (String)"$apViewId");
        Intrinsics.checkNotNullParameter((Object)$dataModel, (String)"$dataModel");
        File dataModelFile = new File(this$0.context.getCacheDir(), APConstantsKt.getENV_NAME() + "_template_" + $apViewId + ".json");
        dataModelFile.createNewFile();
        File file = dataModelFile;
        boolean bl = false;
        OutputStream outputStream = new FileOutputStream(file);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson apTemplateGson = gsonBuilder.create();
        String json = apTemplateGson.toJson((Object)$dataModel);
        if (json != null) {
            String string2 = json;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            outputStream.write(byArray);
        }
        outputStream.flush();
        outputStream.close();
    }
}

