/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.managers;

import androidx.annotation.MainThread;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APSDKManager;
import plus.adaptive.sdk.core.managers.NetworkServiceManager;
import plus.adaptive.sdk.core.managers.OnTokenResponse;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.AuthTokenData;
import plus.adaptive.sdk.data.models.network.APBrandColorsResponseBody;
import plus.adaptive.sdk.data.models.network.APConfigsResponseBody;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.models.network.RequestState;
import plus.adaptive.sdk.data.repositories.APAuthRepository;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0017J\b\u0010\u0011\u001a\u00020\bH\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lplus/adaptive/sdk/core/managers/APSDKManagerImpl;", "Lplus/adaptive/sdk/core/managers/APSDKManager;", "networkServiceManager", "Lplus/adaptive/sdk/core/managers/NetworkServiceManager;", "authRepository", "Lplus/adaptive/sdk/data/repositories/APAuthRepository;", "(Lplus/adaptive/sdk/core/managers/NetworkServiceManager;Lplus/adaptive/sdk/data/repositories/APAuthRepository;)V", "authorize", "", "isForced", "", "callback", "Lplus/adaptive/sdk/core/managers/OnTokenResponse;", "isStarted", "requestAPBrandColor", "requestAPConfigs", "start", "stop", "Companion", "sdk_release"})
public final class APSDKManagerImpl
implements APSDKManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final NetworkServiceManager networkServiceManager;
    @Nullable
    private final APAuthRepository authRepository;
    private static volatile boolean isStarted;
    @NotNull
    private static RequestState tokenRequestState;

    public APSDKManagerImpl(@Nullable NetworkServiceManager networkServiceManager, @Nullable APAuthRepository authRepository) {
        this.networkServiceManager = networkServiceManager;
        this.authRepository = authRepository;
    }

    @Override
    @MainThread
    public void start() {
        isStarted = true;
        tokenRequestState = RequestState.NONE;
    }

    @Override
    @MainThread
    public void stop() {
        isStarted = false;
        tokenRequestState = RequestState.NONE;
    }

    @Override
    public boolean isStarted() {
        return isStarted;
    }

    @Override
    public void authorize(boolean isForced, @Nullable OnTokenResponse callback2) {
        Object object;
        if (!isStarted || !isForced && tokenRequestState == RequestState.IN_PROCESS) {
            return;
        }
        if (!isForced && !Intrinsics.areEqual((Object)((object = this.networkServiceManager) == null ? null : Boolean.valueOf(object.isTokenExpired())), (Object)true)) {
            Object object2;
            Object object3 = this.networkServiceManager;
            Object object4 = object3 == null ? null : (object = (object2 = object3.getTokenLiveData()) == null ? null : (AuthTokenData)object2.getValue());
            if (object != null && (object3 = ((AuthTokenData)object).getToken()) != null) {
                object2 = object3;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                APConstantsKt.setAUTHORIZATION_TOKEN(it);
            }
            this.requestAPConfigs();
            return;
        }
        tokenRequestState = RequestState.IN_PROCESS;
        object = this.authRepository;
        if (object != null) {
            ((APAuthRepository)object).requestToken(new RequestResultCallback<String>(this, callback2){
                final /* synthetic */ APSDKManagerImpl this$0;
                final /* synthetic */ OnTokenResponse $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                }

                public void success(@NotNull String response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    APSDKManagerImpl.access$setTokenRequestState$cp(RequestState.SUCCESS);
                    APSDKManagerImpl.access$requestAPConfigs(this.this$0);
                    APConstantsKt.setAUTHORIZATION_TOKEN(response);
                    OnTokenResponse onTokenResponse = this.$callback;
                    if (onTokenResponse != null) {
                        onTokenResponse.onTokenResponse(response);
                    }
                }

                public void failure(@Nullable APError error) {
                    APSDKManagerImpl.access$setTokenRequestState$cp(RequestState.ERROR);
                }
            });
        }
    }

    private final void requestAPConfigs() {
        APAuthRepository aPAuthRepository = this.authRepository;
        if (aPAuthRepository != null) {
            aPAuthRepository.requestAPConfigs(new RequestResultCallback<APConfigsResponseBody>(this){
                final /* synthetic */ APSDKManagerImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void success(@NotNull APConfigsResponseBody response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    APSDKManagerImpl.access$requestAPBrandColor(this.this$0);
                }

                public void failure(@Nullable APError error) {
                }
            });
        }
    }

    private final void requestAPBrandColor() {
        APAuthRepository aPAuthRepository = this.authRepository;
        if (aPAuthRepository != null) {
            aPAuthRepository.requestAPBrandColor(new RequestResultCallback<APBrandColorsResponseBody>(){

                public void success(@NotNull APBrandColorsResponseBody response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    CharSequence charSequence = response.getBrandColor();
                    boolean bl = false;
                    boolean bl2 = false;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        APConstantsKt.setBRAND_COLOR(response.getBrandColor());
                    }
                }

                public void failure(@Nullable APError error) {
                }
            });
        }
    }

    public static final /* synthetic */ void access$setTokenRequestState$cp(RequestState requestState) {
        tokenRequestState = requestState;
    }

    public static final /* synthetic */ void access$requestAPConfigs(APSDKManagerImpl $this) {
        $this.requestAPConfigs();
    }

    public static final /* synthetic */ void access$requestAPBrandColor(APSDKManagerImpl $this) {
        $this.requestAPBrandColor();
    }

    static {
        tokenRequestState = RequestState.NONE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lplus/adaptive/sdk/core/managers/APSDKManagerImpl$Companion;", "", "()V", "isStarted", "", "tokenRequestState", "Lplus/adaptive/sdk/data/models/network/RequestState;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

