/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.managers;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.story.APBookmarkSnapList;
import plus.adaptive.sdk.data.models.story.Snap;
import plus.adaptive.sdk.utils.BookmarkUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\rJ\u0010\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\rJ\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\"2\u0006\u0010#\u001a\u00020\rJ\u0016\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010%\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\rJ \u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010)\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010*\u001a\u00020\tJ\u0016\u0010+\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0013J\u0016\u0010,\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0015J\u0016\u0010-\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0017J\u0018\u0010.\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010/\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rJ\u0016\u00100\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0015J\u0010\u00102\u001a\u00020'2\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0010\u00103\u001a\u00020'2\b\u0010\u001e\u001a\u0004\u0018\u00010\rJ\u000e\u00104\u001a\u00020'2\u0006\u0010 \u001a\u00020\rJ\u0016\u00105\u001a\u00020'2\u0006\u0010#\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "changeSnapSaved", "", "snap", "Lplus/adaptive/sdk/data/models/APSnap;", "publicationId", "", "getBookmarkSnaps", "Lplus/adaptive/sdk/data/models/story/APBookmarkSnapList;", "getBoolean", "key", "getFloat", "", "getInt", "", "getLong", "", "getString", "getWatchedBannerCount", "bannerId", "getWatchedInstructionCount", "instructionId", "getWatchedPopupIdCount", "popupId", "getWatchedStoryCount", "storyId", "getWatchedStoryIds", "", "userId", "isSnapSaved", "remove", "removeSnapBookMark", "", "bookmarkList", "saveBoolean", "value", "saveFloat", "saveInt", "saveLong", "saveSnapBookMark", "saveString", "saveWatchedBannerIdCount", "count", "saveWatchedInstructionCount", "saveWatchedPopupIdCount", "saveWatchedStoryCount", "saveWatchedStoryId", "Companion", "sdk_release"})
public final class APSharedPreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences preferences;
    @NotNull
    private static final String PREF_ADAPTIVE_PLUS = "adaptive_plus_sdk_preferences";
    @NotNull
    public static final String AUTH_TOKEN = "auth_token";
    @NotNull
    public static final String AUTH_TOKEN_EXPIRATION_DATE = "auth_token_expiration_date";
    @NotNull
    public static final String AP_USER_ID = "ap_user_id";
    @NotNull
    public static final String EXTERNAL_USER_ID = "external_user_id";
    @NotNull
    public static final String IS_CAMPAIGN_WATCHED = "is_campaign_watched";
    @NotNull
    public static final String IS_EVENT_TRACKING_DISABLED = "is_event_tracking_disabled";
    @NotNull
    public static final String CAMPAIGN_WATCHED_COUNT = "campaign_watched_count";
    @NotNull
    public static final String POLL_CHOSEN_ANSWER_ID = "poll_chosen_answer_id";
    @NotNull
    public static final String POLL_DATA = "poll_data";
    @NotNull
    public static final String AP_BOOKMARK = "book_mark_snaps";
    @NotNull
    public static final String AP_BRAND_COLOR = "brand_color";

    public APSharedPreferences(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preferences = context.getSharedPreferences(PREF_ADAPTIVE_PLUS, 0);
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getString(key, null);
    }

    public final boolean saveString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$saveString_u24lambda_u2d0 = editor;
        boolean bl3 = false;
        $this$saveString_u24lambda_u2d0.putString(key, value);
        return $this$saveString_u24lambda_u2d0.commit();
    }

    public final int getInt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getInt(key, -1);
    }

    public final boolean saveInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$saveInt_u24lambda_u2d1 = editor;
        boolean bl3 = false;
        $this$saveInt_u24lambda_u2d1.putInt(key, value);
        return $this$saveInt_u24lambda_u2d1.commit();
    }

    public final long getLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getLong(key, -1L);
    }

    public final boolean saveLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$saveLong_u24lambda_u2d2 = editor;
        boolean bl3 = false;
        $this$saveLong_u24lambda_u2d2.putLong(key, value);
        return $this$saveLong_u24lambda_u2d2.commit();
    }

    public final float getFloat(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getFloat(key, -1.0f);
    }

    public final boolean saveFloat(@NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$saveFloat_u24lambda_u2d3 = editor;
        boolean bl3 = false;
        $this$saveFloat_u24lambda_u2d3.putFloat(key, value);
        return $this$saveFloat_u24lambda_u2d3.commit();
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getBoolean(key, false);
    }

    public final boolean saveBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$saveBoolean_u24lambda_u2d4 = editor;
        boolean bl3 = false;
        $this$saveBoolean_u24lambda_u2d4.putBoolean(key, value);
        return $this$saveBoolean_u24lambda_u2d4.commit();
    }

    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.preferences.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$remove_u24lambda_u2d5 = editor;
        boolean bl3 = false;
        $this$remove_u24lambda_u2d5.remove(key);
        return $this$remove_u24lambda_u2d5.commit();
    }

    @Nullable
    public final Set<String> getWatchedStoryIds(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.preferences.getStringSet(userId, null);
    }

    public final void saveWatchedStoryId(@NotNull String userId, @NotNull String value) {
        Set watchedSet;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Set set = this.getWatchedStoryIds(userId);
        Set set2 = watchedSet = set == null ? (Set)new HashSet() : set;
        if (!((HashSet)watchedSet).contains(value)) {
            this.saveWatchedStoryCount(value);
        }
        watchedSet.add(value);
        this.preferences.edit().putStringSet(userId, watchedSet).apply();
    }

    public final int getWatchedStoryCount(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return this.preferences.getInt(APConstantsKt.getENV_NAME() + " story " + storyId, 0);
    }

    public final void saveWatchedStoryCount(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        int count = this.getWatchedStoryCount(storyId);
        this.preferences.edit().putInt(APConstantsKt.getENV_NAME() + " story " + storyId, count + 1).apply();
    }

    public final int getWatchedBannerCount(@NotNull String bannerId) {
        Intrinsics.checkNotNullParameter((Object)bannerId, (String)"bannerId");
        return this.preferences.getInt(APConstantsKt.getENV_NAME() + " banner " + bannerId, 0);
    }

    public final void saveWatchedBannerIdCount(@NotNull String bannerId, int count) {
        Intrinsics.checkNotNullParameter((Object)bannerId, (String)"bannerId");
        this.preferences.edit().putInt(APConstantsKt.getENV_NAME() + " banner " + bannerId, count).apply();
    }

    public final int getWatchedInstructionCount(@Nullable String instructionId) {
        return this.preferences.getInt(APConstantsKt.getENV_NAME() + " instruction " + instructionId, 0);
    }

    public final void saveWatchedInstructionCount(@Nullable String instructionId) {
        int count = this.getWatchedInstructionCount(instructionId);
        this.preferences.edit().putInt(APConstantsKt.getENV_NAME() + " instruction " + instructionId, count + 1).apply();
    }

    public final int getWatchedPopupIdCount(@Nullable String popupId) {
        return this.preferences.getInt(APConstantsKt.getENV_NAME() + " popup " + popupId, 0);
    }

    public final void saveWatchedPopupIdCount(@Nullable String popupId) {
        int count = this.getWatchedPopupIdCount(popupId);
        this.preferences.edit().putInt(APConstantsKt.getENV_NAME() + " popup " + popupId, count + 1).apply();
    }

    private final void saveSnapBookMark(APSnap snap, String publicationId) {
        APBookmarkSnapList aPBookmarkSnapList;
        boolean bl;
        APBookmarkSnapList aPBookmarkSnapList2;
        Snap newModelSnap = BookmarkUtilsKt.createSnapFromApSnap(snap);
        Object object = this.getBookmarkSnaps(publicationId);
        if (object == null) {
            aPBookmarkSnapList2 = null;
        } else {
            APBookmarkSnapList aPBookmarkSnapList3 = object;
            bl = false;
            boolean bl2 = false;
            APBookmarkSnapList it = aPBookmarkSnapList3;
            boolean bl3 = false;
            it.getSnaps().add(newModelSnap);
            aPBookmarkSnapList2 = it;
        }
        APBookmarkSnapList aPBookmarkSnapList4 = aPBookmarkSnapList2;
        if (aPBookmarkSnapList4 == null) {
            object = this;
            boolean bl4 = false;
            bl = false;
            APSharedPreferences $this$saveSnapBookMark_u24lambda_u2d8 = (APSharedPreferences)object;
            boolean bl5 = false;
            ArrayList<Snap> arrayList = new ArrayList<Snap>();
            boolean bl6 = false;
            boolean bl7 = false;
            ArrayList<Snap> $this$saveSnapBookMark_u24lambda_u2d8_u24lambda_u2d7 = arrayList;
            boolean bl8 = false;
            $this$saveSnapBookMark_u24lambda_u2d8_u24lambda_u2d7.add(newModelSnap);
            Unit unit = Unit.INSTANCE;
            ArrayList<Snap> arrayList2 = arrayList;
            aPBookmarkSnapList = new APBookmarkSnapList(arrayList2);
        } else {
            aPBookmarkSnapList = aPBookmarkSnapList4;
        }
        APBookmarkSnapList snapList = aPBookmarkSnapList;
        String jsonToSave = new Gson().toJson(snapList);
        this.preferences.edit().putString(Intrinsics.stringPlus((String)AP_BOOKMARK, (Object)publicationId), jsonToSave).apply();
    }

    private final void removeSnapBookMark(APSnap snap, APBookmarkSnapList bookmarkList, String publicationId) {
        if (bookmarkList.getSnaps().size() > 1) {
            bookmarkList.removeSnap(snap);
            String jsonToSave = new Gson().toJson((Object)bookmarkList);
            this.preferences.edit().putString(Intrinsics.stringPlus((String)AP_BOOKMARK, (Object)publicationId), jsonToSave).apply();
        } else {
            this.preferences.edit().remove(Intrinsics.stringPlus((String)AP_BOOKMARK, (Object)publicationId)).apply();
        }
    }

    public final boolean isSnapSaved(@NotNull APSnap snap, @NotNull String publicationId) {
        Intrinsics.checkNotNullParameter((Object)snap, (String)"snap");
        Intrinsics.checkNotNullParameter((Object)publicationId, (String)"publicationId");
        Object object = this.getBookmarkSnaps(publicationId);
        if (object != null) {
            APBookmarkSnapList aPBookmarkSnapList = object;
            boolean bl = false;
            boolean bl2 = false;
            APBookmarkSnapList it = aPBookmarkSnapList;
            boolean bl3 = false;
            return it.hasSnap(snap);
        }
        Object var3_13 = null;
        object = this;
        boolean bl = false;
        boolean bl4 = false;
        APSharedPreferences $this$isSnapSaved_u24lambda_u2d10 = (APSharedPreferences)object;
        boolean bl5 = false;
        return false;
    }

    public final boolean changeSnapSaved(@NotNull APSnap snap, @NotNull String publicationId) {
        Intrinsics.checkNotNullParameter((Object)snap, (String)"snap");
        Intrinsics.checkNotNullParameter((Object)publicationId, (String)"publicationId");
        Object object = this.getBookmarkSnaps(publicationId);
        if (object != null) {
            boolean bl;
            APBookmarkSnapList aPBookmarkSnapList = object;
            boolean bl2 = false;
            boolean bl3 = false;
            APBookmarkSnapList it = aPBookmarkSnapList;
            boolean bl4 = false;
            if (it.hasSnap(snap)) {
                this.removeSnapBookMark(snap, it, publicationId);
                bl = true;
            } else {
                this.saveSnapBookMark(snap, publicationId);
                bl = false;
            }
            return bl;
        }
        Object var3_13 = null;
        object = this;
        boolean bl = false;
        boolean bl5 = false;
        APSharedPreferences $this$changeSnapSaved_u24lambda_u2d12 = (APSharedPreferences)object;
        boolean bl6 = false;
        $this$changeSnapSaved_u24lambda_u2d12.saveSnapBookMark(snap, publicationId);
        return false;
    }

    @Nullable
    public final APBookmarkSnapList getBookmarkSnaps(@NotNull String publicationId) {
        APBookmarkSnapList aPBookmarkSnapList;
        boolean bl;
        APBookmarkSnapList aPBookmarkSnapList2;
        Intrinsics.checkNotNullParameter((Object)publicationId, (String)"publicationId");
        Object object = this.preferences.getString(Intrinsics.stringPlus((String)AP_BOOKMARK, (Object)publicationId), null);
        if (object == null) {
            aPBookmarkSnapList2 = null;
        } else {
            String string2 = object;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            aPBookmarkSnapList2 = (APBookmarkSnapList)new Gson().fromJson(it, APBookmarkSnapList.class);
        }
        APBookmarkSnapList aPBookmarkSnapList3 = aPBookmarkSnapList2;
        if (aPBookmarkSnapList3 == null) {
            object = this;
            boolean bl4 = false;
            bl = false;
            APSharedPreferences $this$getBookmarkSnaps_u24lambda_u2d14 = (APSharedPreferences)object;
            boolean bl5 = false;
            aPBookmarkSnapList = null;
        } else {
            aPBookmarkSnapList = aPBookmarkSnapList3;
        }
        return aPBookmarkSnapList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lplus/adaptive/sdk/core/managers/APSharedPreferences$Companion;", "", "()V", "AP_BOOKMARK", "", "AP_BRAND_COLOR", "AP_USER_ID", "AUTH_TOKEN", "AUTH_TOKEN_EXPIRATION_DATE", "CAMPAIGN_WATCHED_COUNT", "EXTERNAL_USER_ID", "IS_CAMPAIGN_WATCHED", "IS_EVENT_TRACKING_DISABLED", "POLL_CHOSEN_ANSWER_ID", "POLL_DATA", "PREF_ADAPTIVE_PLUS", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

