/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.core.managers;

import android.os.Build;
import androidx.annotation.MainThread;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.factories.Tls12SocketFactory;
import plus.adaptive.sdk.core.managers.APSharedPreferences;
import plus.adaptive.sdk.core.managers.NetworkServiceManager;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.AuthTokenData;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.utils.DateTimeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J!\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lplus/adaptive/sdk/core/managers/NetworkServiceManagerImpl;", "Lplus/adaptive/sdk/core/managers/NetworkServiceManager;", "preferences", "Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Lplus/adaptive/sdk/core/managers/APSharedPreferences;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "enableTls12OnPreLollipop", "Lokhttp3/OkHttpClient$Builder;", "builder", "getOkHttpClient", "getTokenLiveData", "Landroidx/lifecycle/LiveData;", "Lplus/adaptive/sdk/data/models/AuthTokenData;", "isTokenExpired", "", "provideOkHttpClient", "provideOkHttpClientBuilder", "tokenInstance", "", "updateToken", "", "token", "expiresIn", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "Companion", "sdk_release"})
public final class NetworkServiceManagerImpl
implements NetworkServiceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final APSharedPreferences preferences;
    @Nullable
    private final APUserRepository userRepository;
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private static String token;
    @NotNull
    private static final MutableLiveData<AuthTokenData> tokenLiveData;

    public NetworkServiceManagerImpl(@Nullable APSharedPreferences preferences, @Nullable APUserRepository userRepository) {
        this.preferences = preferences;
        this.userRepository = userRepository;
    }

    public /* synthetic */ NetworkServiceManagerImpl(APSharedPreferences aPSharedPreferences, APUserRepository aPUserRepository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            aPSharedPreferences = null;
        }
        if ((n & 2) != 0) {
            aPUserRepository = null;
        }
        this(aPSharedPreferences, aPUserRepository);
    }

    private final String tokenInstance() {
        if (token == null) {
            String string2;
            APUserRepository aPUserRepository = this.userRepository;
            if (aPUserRepository == null) {
                string2 = null;
            } else {
                String string3 = aPUserRepository.getAPUserId();
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    String userId = string4;
                    boolean bl3 = false;
                    APSharedPreferences aPSharedPreferences = this.preferences;
                    string2 = aPSharedPreferences == null ? null : aPSharedPreferences.getString(Intrinsics.stringPlus((String)userId, (Object)"_auth_token"));
                }
            }
            token = string2;
            if (token != null) {
                tokenLiveData.postValue((Object)new AuthTokenData(token, true));
            }
        }
        return token;
    }

    @Override
    public void updateToken(@Nullable String token, @Nullable Integer expiresIn) {
        String string2;
        NetworkServiceManagerImpl.token = token;
        Object object = (AuthTokenData)tokenLiveData.getValue();
        if (!Intrinsics.areEqual((Object)(object == null ? null : ((AuthTokenData)object).getToken()), (Object)token)) {
            tokenLiveData.postValue((Object)new AuthTokenData(token, false, 2, null));
        }
        if ((object = this.userRepository) != null && (string2 = ((APUserRepository)object).getAPUserId()) != null) {
            APSharedPreferences aPSharedPreferences;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String userId = string3;
            boolean bl3 = false;
            if (token == null) {
                aPSharedPreferences = this.preferences;
                if (aPSharedPreferences != null) {
                    aPSharedPreferences.remove(Intrinsics.stringPlus((String)userId, (Object)"_auth_token"));
                }
            } else {
                aPSharedPreferences = this.preferences;
                if (aPSharedPreferences != null) {
                    aPSharedPreferences.saveString(Intrinsics.stringPlus((String)userId, (Object)"_auth_token"), token);
                }
            }
            if (token == null || expiresIn == null) {
                aPSharedPreferences = this.preferences;
                if (aPSharedPreferences != null) {
                    aPSharedPreferences.remove(Intrinsics.stringPlus((String)userId, (Object)"_auth_token_expiration_date"));
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                boolean bl4 = false;
                boolean bl5 = false;
                Calendar $this$updateToken_u24lambda_u2d2_u24lambda_u2d1 = calendar;
                boolean bl6 = false;
                $this$updateToken_u24lambda_u2d2_u24lambda_u2d1.add(13, expiresIn);
                Calendar expirationDate = calendar;
                Object object2 = expirationDate.getTime();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"expirationDate.time");
                String expirationDateStr = DateTimeUtilsKt.formatDateToString$default((Date)object2, null, 2, null);
                object2 = this.preferences;
                if (object2 != null) {
                    ((APSharedPreferences)object2).saveString(Intrinsics.stringPlus((String)userId, (Object)"_auth_token_expiration_date"), expirationDateStr);
                }
            }
        }
    }

    @Override
    @MainThread
    @NotNull
    public LiveData<AuthTokenData> getTokenLiveData() {
        AuthTokenData authTokenData = (AuthTokenData)tokenLiveData.getValue();
        if (!Intrinsics.areEqual((Object)(authTokenData == null ? null : authTokenData.getToken()), (Object)token)) {
            boolean bl;
            authTokenData = (AuthTokenData)tokenLiveData.getValue();
            tokenLiveData.setValue((Object)new AuthTokenData(token, authTokenData == null ? false : (bl = authTokenData.isFromCache())));
        }
        return (LiveData)tokenLiveData;
    }

    @Override
    public boolean isTokenExpired() {
        Date date;
        String string2;
        Object object = this.userRepository;
        String string3 = string2 = object == null ? null : ((APUserRepository)object).getAPUserId();
        if (string2 == null) {
            date = null;
        } else {
            Object object2 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String userId = object2;
            boolean bl3 = false;
            APSharedPreferences aPSharedPreferences = this.preferences;
            object = aPSharedPreferences == null ? null : aPSharedPreferences.getString(Intrinsics.stringPlus((String)userId, (Object)"_auth_token_expiration_date"));
            if (object == null) {
                date = null;
            } else {
                object2 = object;
                bl = false;
                bl2 = false;
                Object it = object2;
                boolean bl4 = false;
                date = DateTimeUtilsKt.parseDateString$default((String)it, null, 2, null);
            }
        }
        Date expiresAt = date;
        Date now = Calendar.getInstance().getTime();
        return this.tokenInstance() == null || expiresAt == null || expiresAt.before(now);
    }

    @Override
    @NotNull
    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = this.provideOkHttpClient();
        }
        OkHttpClient okHttpClient = this.okHttpClient;
        Intrinsics.checkNotNull((Object)okHttpClient);
        return okHttpClient;
    }

    private final OkHttpClient provideOkHttpClient() {
        OkHttpClient.Builder builder;
        OkHttpClient.Builder this_$iv = builder = this.provideOkHttpClientBuilder();
        boolean bl = false;
        this_$iv.addNetworkInterceptor(new Interceptor(this){
            final /* synthetic */ NetworkServiceManagerImpl this$0;
            {
                this.this$0 = networkServiceManagerImpl;
            }

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                String string2 = NetworkServiceManagerImpl.access$tokenInstance(this.this$0);
                if (string2 == null) {
                    response = null;
                } else {
                    String string3 = string2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String token = string3;
                    boolean bl4 = false;
                    Request originalRequest = chain2.request();
                    String authValue = Intrinsics.stringPlus((String)"Bearer ", (Object)token);
                    Request newRequest = originalRequest.newBuilder().header("Authorization", authValue).build();
                    response = chain2.proceed(newRequest);
                }
                Response response2 = response;
                return response2 == null ? chain2.proceed(chain2.request()) : response2;
            }
        });
        this_$iv = builder;
        bl = false;
        this_$iv.addNetworkInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                String string2 = APConstantsKt.getCUSTOM_IP_ADDRESS();
                if (string2 == null) {
                    response = null;
                } else {
                    String string3 = string2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String ipAddress = string3;
                    boolean bl4 = false;
                    Request originalRequest = chain2.request();
                    Request newRequest = originalRequest.newBuilder().header("x-forwarded-for", ipAddress).build();
                    response = chain2.proceed(newRequest);
                }
                Response response2 = response;
                return response2 == null ? chain2.proceed(chain2.request()) : response2;
            }
        });
        return builder.build();
    }

    private final OkHttpClient.Builder provideOkHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().writeTimeout(APConstantsKt.getREQUEST_TIMEOUT(), TimeUnit.SECONDS).readTimeout(APConstantsKt.getREQUEST_TIMEOUT(), TimeUnit.SECONDS).connectTimeout(APConstantsKt.getREQUEST_TIMEOUT(), TimeUnit.SECONDS);
        if (APConstantsKt.getIS_DEBUGGABLE()) {
            HttpLoggingInterceptor httpLoggingInterceptor1 = new HttpLoggingInterceptor(null, 1, null);
            httpLoggingInterceptor1.level(HttpLoggingInterceptor.Level.BODY);
            builder.addNetworkInterceptor((Interceptor)httpLoggingInterceptor1);
        }
        return this.enableTls12OnPreLollipop(builder);
    }

    private final OkHttpClient.Builder enableTls12OnPreLollipop(OkHttpClient.Builder builder) {
        int n = Build.VERSION.SDK_INT;
        boolean bl = 16 <= n ? n <= 21 : false;
        if (bl) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                boolean bl2 = trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager;
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string2 = Intrinsics.stringPlus((String)"Unexpected default trust managers:", (Object)Arrays.toString(trustManagers));
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                TrustManager trustManager = trustManagers[0];
                if (trustManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
                }
                X509TrustManager trustManager2 = (X509TrustManager)trustManager;
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                Object object = new TrustManager[]{trustManager2};
                sc.init(null, (TrustManager[])object, null);
                object = sc.getSocketFactory();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sc.socketFactory");
                builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory((SSLSocketFactory)object), trustManager2);
                TlsVersion[] bl5 = new TlsVersion[]{TlsVersion.TLS_1_2};
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(bl5).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                builder.connectionSpecs((List)specs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder;
    }

    public NetworkServiceManagerImpl() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ String access$tokenInstance(NetworkServiceManagerImpl $this) {
        return $this.tokenInstance();
    }

    static {
        tokenLiveData = new MutableLiveData();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lplus/adaptive/sdk/core/managers/NetworkServiceManagerImpl$Companion;", "", "()V", "token", "", "tokenLiveData", "Landroidx/lifecycle/MutableLiveData;", "Lplus/adaptive/sdk/data/models/AuthTokenData;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

