/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.data.repositories;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.constant.Constable;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.analytics.APAnalytics;
import plus.adaptive.sdk.core.managers.APAuthCredentialsManager;
import plus.adaptive.sdk.core.managers.NetworkServiceManager;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.network.APBrandColorsResponseBody;
import plus.adaptive.sdk.data.models.network.APConfigsResponseBody;
import plus.adaptive.sdk.data.models.network.BaseResponseBody;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.repositories.APAuthRepository$requestAPBrandColor$;
import plus.adaptive.sdk.data.repositories.APAuthRepository$requestAPConfigs$;
import plus.adaptive.sdk.data.repositories.APBaseRepository;
import plus.adaptive.sdk.data.repositories.APUserRepository;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0011\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\u0014\u0010\u0012\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lplus/adaptive/sdk/data/repositories/APAuthRepository;", "Lplus/adaptive/sdk/data/repositories/APBaseRepository;", "networkManager", "Lplus/adaptive/sdk/core/managers/NetworkServiceManager;", "authCredentialsManager", "Lplus/adaptive/sdk/core/managers/APAuthCredentialsManager;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Lplus/adaptive/sdk/core/managers/NetworkServiceManager;Lplus/adaptive/sdk/core/managers/APAuthCredentialsManager;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "applyAPConfigs", "", "configs", "Lplus/adaptive/sdk/data/models/network/APConfigsResponseBody;", "requestAPBrandColor", "callback", "Lplus/adaptive/sdk/data/models/network/RequestResultCallback;", "Lplus/adaptive/sdk/data/models/network/APBrandColorsResponseBody;", "requestAPConfigs", "requestToken", "", "sdk_release"})
public final class APAuthRepository
extends APBaseRepository {
    @NotNull
    private final APUserRepository userRepository;

    public APAuthRepository(@NotNull NetworkServiceManager networkManager, @NotNull APAuthCredentialsManager authCredentialsManager, @NotNull APUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)authCredentialsManager, (String)"authCredentialsManager");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        super(networkManager, authCredentialsManager, userRepository, null, 8, null);
        this.userRepository = userRepository;
    }

    public final void requestToken(@NotNull RequestResultCallback<String> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.authorize(callback2);
    }

    public final void requestAPConfigs(@NotNull RequestResultCallback<APConfigsResponseBody> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Request request = new Request.Builder().url(Intrinsics.stringPlus((String)APConstantsKt.getSDK_API_URL(), (Object)"/configs")).build();
        boolean isReauthorizationOn$iv = false;
        boolean $i$f$executeRequest = false;
        RequestResultCallback<String> authRequestResultCallback$iv = new RequestResultCallback<String>((APBaseRepository)this, request, this, callback2, callback2){
            final /* synthetic */ APBaseRepository this$0$inline_fun;
            final /* synthetic */ Request $request;
            final /* synthetic */ APAuthRepository this$0;
            final /* synthetic */ RequestResultCallback $callback$inlined;
            final /* synthetic */ RequestResultCallback $callback$inlined$1;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = aPAuthRepository;
                this.$callback$inlined = requestResultCallback;
                this.$callback$inlined$1 = requestResultCallback2;
            }

            /*
             * WARNING - void declaration
             */
            public void success(@NotNull String response) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                Request request$iv = this.$request;
                boolean $i$f$executeRequest = false;
                String string2 = request$iv.url().uri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUri().toString()");
                String url$iv = string2;
                Thread thread$iv = new Thread(new Runnable((APBaseRepository)this_$iv, request$iv, this.this$0, this.$callback$inlined, this.$callback$inlined$1){
                    final /* synthetic */ APBaseRepository this$0$inline_fun;
                    final /* synthetic */ Request $request;
                    final /* synthetic */ APAuthRepository this$0;
                    final /* synthetic */ RequestResultCallback $callback$inlined;
                    final /* synthetic */ RequestResultCallback $callback$inlined$1;
                    {
                        this.this$0$inline_fun = $receiver;
                        this.$request = $request;
                        this.this$0 = aPAuthRepository;
                        this.$callback$inlined = requestResultCallback;
                        this.$callback$inlined$1 = requestResultCallback2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                        Request request$iv = this.$request;
                        boolean $i$f$makeRequest = false;
                        try {
                            void this_$iv;
                            Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                            if (response$iv.isSuccessful()) {
                                Type dataType$iv = new TypeToken<BaseResponseBody<APConfigsResponseBody>>(){}.getType();
                                Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                                BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                                if (responseBody$iv.getCode() == 0) {
                                    APConfigsResponseBody response = (APConfigsResponseBody)responseBody$iv.getData();
                                    boolean bl = false;
                                    APAuthRepository.access$applyAPConfigs(this.this$0, response);
                                    this.$callback$inlined.success(response);
                                } else {
                                    APError error = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                                    boolean bl = false;
                                    this.$callback$inlined$1.failure(error);
                                }
                            } else {
                                APError error = new APError(response$iv.code(), response$iv.message());
                                boolean bl = false;
                                this.$callback$inlined$1.failure(error);
                            }
                        }
                        catch (Exception e$iv) {
                            e$iv.printStackTrace();
                            APError error = null;
                            boolean bl = false;
                            this.$callback$inlined$1.failure(error);
                        }
                        catch (IllegalStateException stateException$iv) {
                            stateException$iv.printStackTrace();
                            APError error = null;
                            boolean bl = false;
                            this.$callback$inlined$1.failure(error);
                        }
                    }
                });
                thread$iv.start();
                if (StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
                    thread$iv.join();
                }
            }

            public void failure(@Nullable APError error) {
                APError error2 = error;
                boolean bl = false;
                this.$callback$inlined$1.failure(error2);
            }
        };
        APBaseRepository this_$iv$iv = this;
        boolean $i$f$executeRequest2 = false;
        String string2 = request.url().uri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUri().toString()");
        String url$iv$iv = string2;
        Thread thread$iv$iv = new Thread(new Runnable(this_$iv$iv, request, isReauthorizationOn$iv, this, authRequestResultCallback$iv, this, callback2, callback2){
            final /* synthetic */ APBaseRepository this$0$inline_fun;
            final /* synthetic */ Request $request;
            final /* synthetic */ boolean $isReauthorizationOn$inlined;
            final /* synthetic */ APBaseRepository this$0$inline_fun$1;
            final /* synthetic */ requestAPConfigs$$inlined$executeRequest$default$1 $authRequestResultCallback$inlined;
            final /* synthetic */ APAuthRepository this$0;
            final /* synthetic */ RequestResultCallback $callback$inlined;
            final /* synthetic */ RequestResultCallback $callback$inlined$1;
            {
                this.$request = $request;
                this.$isReauthorizationOn$inlined = bl;
                this.this$0$inline_fun$1 = aPBaseRepository;
                this.$authRequestResultCallback$inlined = var5_5;
                this.this$0 = aPAuthRepository;
                this.$callback$inlined = requestResultCallback;
                this.$callback$inlined$1 = requestResultCallback2;
                this.this$0$inline_fun = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                Request request$iv = this.$request;
                boolean $i$f$makeRequest = false;
                try {
                    void this_$iv;
                    Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                    if (response$iv.isSuccessful()) {
                        Type dataType$iv = new TypeToken<BaseResponseBody<APConfigsResponseBody>>(){}.getType();
                        Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                        BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                        if (responseBody$iv.getCode() == 0) {
                            APConfigsResponseBody response = (APConfigsResponseBody)responseBody$iv.getData();
                            boolean bl = false;
                            APAuthRepository.access$applyAPConfigs(this.this$0, response);
                            this.$callback$inlined.success(response);
                            return;
                        }
                        APError error = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                        boolean bl = false;
                        if (this.$isReauthorizationOn$inlined) {
                            APError aPError = error;
                            int n = 401;
                            if (aPError.getCode() == n) {
                                APBaseRepository.access$authorize(this.this$0$inline_fun$1, this.$authRequestResultCallback$inlined);
                                return;
                            }
                        }
                        APError error2 = error;
                        boolean bl2 = false;
                        this.$callback$inlined$1.failure(error2);
                        return;
                    }
                    APError error = new APError(response$iv.code(), response$iv.message());
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                        if (aPError.getCode() == n) {
                            APBaseRepository.access$authorize(this.this$0$inline_fun$1, this.$authRequestResultCallback$inlined);
                            return;
                        }
                    }
                    APError error3 = error;
                    boolean bl3 = false;
                    this.$callback$inlined$1.failure(error3);
                    return;
                }
                catch (Exception e$iv) {
                    e$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError error4 = error;
                    boolean bl4 = false;
                    this.$callback$inlined$1.failure(error4);
                    return;
                }
                catch (IllegalStateException stateException$iv) {
                    stateException$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError error5 = error;
                    boolean bl5 = false;
                    this.$callback$inlined$1.failure(error5);
                }
            }
        });
        thread$iv$iv.start();
        if (StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
            thread$iv$iv.join();
        }
    }

    public final void requestAPBrandColor(@NotNull RequestResultCallback<APBrandColorsResponseBody> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Request request = new Request.Builder().addHeader("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)APConstantsKt.getAUTHORIZATION_TOKEN())).url(Intrinsics.stringPlus((String)APConstantsKt.getSDK_API_URL(), (Object)"/merchant-settings/sdk")).build();
        boolean isReauthorizationOn$iv = false;
        boolean $i$f$executeRequest = false;
        RequestResultCallback<String> authRequestResultCallback$iv = new RequestResultCallback<String>((APBaseRepository)this, request, this, callback2, callback2){
            final /* synthetic */ APBaseRepository this$0$inline_fun;
            final /* synthetic */ Request $request;
            final /* synthetic */ APAuthRepository this$0;
            final /* synthetic */ RequestResultCallback $callback$inlined;
            final /* synthetic */ RequestResultCallback $callback$inlined$1;
            {
                this.this$0$inline_fun = $receiver;
                this.$request = $request;
                this.this$0 = aPAuthRepository;
                this.$callback$inlined = requestResultCallback;
                this.$callback$inlined$1 = requestResultCallback2;
            }

            /*
             * WARNING - void declaration
             */
            public void success(@NotNull String response) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                Request request$iv = this.$request;
                boolean $i$f$executeRequest = false;
                String string2 = request$iv.url().uri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUri().toString()");
                String url$iv = string2;
                Thread thread$iv = new Thread(new Runnable((APBaseRepository)this_$iv, request$iv, this.this$0, this.$callback$inlined, this.$callback$inlined$1){
                    final /* synthetic */ APBaseRepository this$0$inline_fun;
                    final /* synthetic */ Request $request;
                    final /* synthetic */ APAuthRepository this$0;
                    final /* synthetic */ RequestResultCallback $callback$inlined;
                    final /* synthetic */ RequestResultCallback $callback$inlined$1;
                    {
                        this.this$0$inline_fun = $receiver;
                        this.$request = $request;
                        this.this$0 = aPAuthRepository;
                        this.$callback$inlined = requestResultCallback;
                        this.$callback$inlined$1 = requestResultCallback2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                        Request request$iv = this.$request;
                        boolean $i$f$makeRequest = false;
                        try {
                            void this_$iv;
                            Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                            if (response$iv.isSuccessful()) {
                                Type dataType$iv = new TypeToken<BaseResponseBody<APBrandColorsResponseBody>>(){}.getType();
                                Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                                BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                                if (responseBody$iv.getCode() == 0) {
                                    APBrandColorsResponseBody response = (APBrandColorsResponseBody)responseBody$iv.getData();
                                    boolean bl = false;
                                    APAuthRepository.access$getUserRepository$p(this.this$0).updateBrandColor(response);
                                    this.$callback$inlined.success(response);
                                } else {
                                    APError error = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                                    boolean bl = false;
                                    this.$callback$inlined$1.failure(error);
                                }
                            } else {
                                APError error = new APError(response$iv.code(), response$iv.message());
                                boolean bl = false;
                                this.$callback$inlined$1.failure(error);
                            }
                        }
                        catch (Exception e$iv) {
                            e$iv.printStackTrace();
                            APError error = null;
                            boolean bl = false;
                            this.$callback$inlined$1.failure(error);
                        }
                        catch (IllegalStateException stateException$iv) {
                            stateException$iv.printStackTrace();
                            APError error = null;
                            boolean bl = false;
                            this.$callback$inlined$1.failure(error);
                        }
                    }
                });
                thread$iv.start();
                if (StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
                    thread$iv.join();
                }
            }

            public void failure(@Nullable APError error) {
                APError error2 = error;
                boolean bl = false;
                this.$callback$inlined$1.failure(error2);
            }
        };
        APBaseRepository this_$iv$iv = this;
        boolean $i$f$executeRequest2 = false;
        String string2 = request.url().uri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUri().toString()");
        String url$iv$iv = string2;
        Thread thread$iv$iv = new Thread(new Runnable(this_$iv$iv, request, isReauthorizationOn$iv, this, authRequestResultCallback$iv, this, callback2, callback2){
            final /* synthetic */ APBaseRepository this$0$inline_fun;
            final /* synthetic */ Request $request;
            final /* synthetic */ boolean $isReauthorizationOn$inlined;
            final /* synthetic */ APBaseRepository this$0$inline_fun$1;
            final /* synthetic */ requestAPBrandColor$$inlined$executeRequest$default$1 $authRequestResultCallback$inlined;
            final /* synthetic */ APAuthRepository this$0;
            final /* synthetic */ RequestResultCallback $callback$inlined;
            final /* synthetic */ RequestResultCallback $callback$inlined$1;
            {
                this.$request = $request;
                this.$isReauthorizationOn$inlined = bl;
                this.this$0$inline_fun$1 = aPBaseRepository;
                this.$authRequestResultCallback$inlined = var5_5;
                this.this$0 = aPAuthRepository;
                this.$callback$inlined = requestResultCallback;
                this.$callback$inlined$1 = requestResultCallback2;
                this.this$0$inline_fun = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                Request request$iv = this.$request;
                boolean $i$f$makeRequest = false;
                try {
                    void this_$iv;
                    Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                    if (response$iv.isSuccessful()) {
                        Type dataType$iv = new TypeToken<BaseResponseBody<APBrandColorsResponseBody>>(){}.getType();
                        Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                        BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                        if (responseBody$iv.getCode() == 0) {
                            APBrandColorsResponseBody response = (APBrandColorsResponseBody)responseBody$iv.getData();
                            boolean bl = false;
                            APAuthRepository.access$getUserRepository$p(this.this$0).updateBrandColor(response);
                            this.$callback$inlined.success(response);
                            return;
                        }
                        APError error = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                        boolean bl = false;
                        if (this.$isReauthorizationOn$inlined) {
                            APError aPError = error;
                            int n = 401;
                            if (aPError.getCode() == n) {
                                APBaseRepository.access$authorize(this.this$0$inline_fun$1, this.$authRequestResultCallback$inlined);
                                return;
                            }
                        }
                        APError error2 = error;
                        boolean bl2 = false;
                        this.$callback$inlined$1.failure(error2);
                        return;
                    }
                    APError error = new APError(response$iv.code(), response$iv.message());
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                        if (aPError.getCode() == n) {
                            APBaseRepository.access$authorize(this.this$0$inline_fun$1, this.$authRequestResultCallback$inlined);
                            return;
                        }
                    }
                    APError error3 = error;
                    boolean bl3 = false;
                    this.$callback$inlined$1.failure(error3);
                    return;
                }
                catch (Exception e$iv) {
                    e$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError error4 = error;
                    boolean bl4 = false;
                    this.$callback$inlined$1.failure(error4);
                    return;
                }
                catch (IllegalStateException stateException$iv) {
                    stateException$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError error5 = error;
                    boolean bl5 = false;
                    this.$callback$inlined$1.failure(error5);
                }
            }
        });
        thread$iv$iv.start();
        if (StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
            thread$iv$iv.join();
        }
    }

    private final void applyAPConfigs(APConfigsResponseBody configs) {
        double it;
        boolean bl;
        boolean bl2;
        Double d;
        Long l;
        APAnalytics.Companion companion = APAnalytics.Companion;
        Constable constable = configs.getEventsSubmitPeriod();
        if (constable == null) {
            l = null;
        } else {
            d = constable;
            bl2 = false;
            bl = false;
            double d2 = ((Number)d).doubleValue();
            APAnalytics.Companion companion2 = companion;
            boolean bl3 = false;
            Long l2 = (long)(it * (double)1000);
            companion = companion2;
            l = l2;
        }
        companion.updateConfig(l, configs.getEventsSubmitCount());
        constable = configs.getRequestTimeout();
        if (constable != null) {
            d = constable;
            bl2 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            boolean bl4 = false;
            APConstantsKt.setREQUEST_TIMEOUT((long)it);
        }
        constable = configs.getImageRequestTimeout();
        if (constable != null) {
            d = constable;
            bl2 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            boolean bl5 = false;
            APConstantsKt.setGLIDE_TIMEOUT((int)(it * (double)1000));
        }
        constable = configs.isEventTrackingDisabled();
        if (constable != null) {
            d = constable;
            bl2 = false;
            bl = false;
            boolean it2 = (Boolean)((Object)d);
            boolean bl6 = false;
            this.userRepository.setIsEventTrackingDisabled(it2);
        }
    }

    public static final /* synthetic */ void access$applyAPConfigs(APAuthRepository $this, APConfigsResponseBody configs) {
        $this.applyAPConfigs(configs);
    }

    public static final /* synthetic */ APUserRepository access$getUserRepository$p(APAuthRepository $this) {
        return $this.userRepository;
    }
}

