/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.data.repositories;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APAuthCredentialsManager;
import plus.adaptive.sdk.core.managers.NetworkServiceManager;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.APLog;
import plus.adaptive.sdk.data.models.network.BaseResponseBody;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.repositories.APBaseRepository;
import plus.adaptive.sdk.data.repositories.APCrashlyticsRepository$submitLog$;
import plus.adaptive.sdk.data.repositories.APUserRepository;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lplus/adaptive/sdk/data/repositories/APCrashlyticsRepository;", "Lplus/adaptive/sdk/data/repositories/APBaseRepository;", "networkManager", "Lplus/adaptive/sdk/core/managers/NetworkServiceManager;", "authCredentialsManager", "Lplus/adaptive/sdk/core/managers/APAuthCredentialsManager;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Lplus/adaptive/sdk/core/managers/NetworkServiceManager;Lplus/adaptive/sdk/core/managers/APAuthCredentialsManager;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "submitLog", "", "log", "Lplus/adaptive/sdk/data/models/APLog;", "sdk_release"})
public final class APCrashlyticsRepository
extends APBaseRepository {
    public APCrashlyticsRepository(@NotNull NetworkServiceManager networkManager, @NotNull APAuthCredentialsManager authCredentialsManager, @NotNull APUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)authCredentialsManager, (String)"authCredentialsManager");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        super(networkManager, authCredentialsManager, userRepository, null, 8, null);
    }

    public final void submitLog(@NotNull APLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String string2 = new Gson().toJson((Object)CollectionsKt.listOf((Object)log));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Gson().toJson(listOf(log))");
        RequestBody body = RequestBody.Companion.create(string2, APBaseRepository.getJSON_MEDIA_TYPE());
        Request request = new Request.Builder().url(Intrinsics.stringPlus((String)APConstantsKt.getSDK_API_URL(), (Object)"/channel-logs")).post(body).build();
        boolean isReauthorizationOn$iv = false;
        boolean $i$f$executeRequest = false;
        RequestResultCallback<String> authRequestResultCallback$iv = new RequestResultCallback<String>((APBaseRepository)this, request){
            final /* synthetic */ APBaseRepository this$0;
            final /* synthetic */ Request $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
            }

            /*
             * WARNING - void declaration
             */
            public void success(@NotNull String response) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                APBaseRepository aPBaseRepository = this.this$0;
                Request request$iv = this.$request;
                boolean $i$f$executeRequest = false;
                String string2 = request$iv.url().uri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUri().toString()");
                String url$iv = string2;
                Thread thread$iv = new Thread(new Runnable((APBaseRepository)this_$iv, request$iv){
                    final /* synthetic */ APBaseRepository this$0;
                    final /* synthetic */ Request $request;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        APBaseRepository aPBaseRepository = this.this$0;
                        Request request$iv = this.$request;
                        boolean $i$f$makeRequest = false;
                        try {
                            void this_$iv;
                            Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                            if (response$iv.isSuccessful()) {
                                Type dataType$iv = new TypeToken<BaseResponseBody<Object>>(){}.getType();
                                Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                                BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                                if (responseBody$iv.getCode() == 0) {
                                    T it = responseBody$iv.getData();
                                    boolean bl = false;
                                } else {
                                    APError it = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                                    boolean bl = false;
                                }
                            } else {
                                APError it = new APError(response$iv.code(), response$iv.message());
                                boolean bl = false;
                            }
                        }
                        catch (Exception e$iv) {
                            e$iv.printStackTrace();
                            APError it = null;
                            boolean bl = false;
                        }
                        catch (IllegalStateException stateException$iv) {
                            stateException$iv.printStackTrace();
                            APError it = null;
                            boolean bl = false;
                        }
                    }
                });
                thread$iv.start();
                if (StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
                    thread$iv.join();
                }
            }

            public void failure(@Nullable APError error) {
                APError it = error;
                boolean bl = false;
            }
        };
        APBaseRepository this_$iv$iv = this;
        boolean $i$f$executeRequest2 = false;
        String string3 = request.url().uri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"request.url.toUri().toString()");
        String url$iv$iv = string3;
        Thread thread$iv$iv = new Thread(new Runnable(this_$iv$iv, request, isReauthorizationOn$iv, this, authRequestResultCallback$iv){
            final /* synthetic */ APBaseRepository this$0$inline_fun;
            final /* synthetic */ Request $request;
            final /* synthetic */ boolean $isReauthorizationOn$inlined;
            final /* synthetic */ APBaseRepository this$0;
            final /* synthetic */ submitLog$$inlined$executeRequest$default$1 $authRequestResultCallback$inlined;
            {
                this.$request = $request;
                this.$isReauthorizationOn$inlined = bl;
                this.this$0 = aPBaseRepository;
                this.$authRequestResultCallback$inlined = var5_5;
                this.this$0$inline_fun = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void run() {
                APBaseRepository aPBaseRepository = this.this$0$inline_fun;
                Request request$iv = this.$request;
                boolean $i$f$makeRequest = false;
                try {
                    void this_$iv;
                    Response response$iv = APBaseRepository.access$getNetworkManager$p((APBaseRepository)this_$iv).getOkHttpClient().newCall(request$iv).execute();
                    if (response$iv.isSuccessful()) {
                        Type dataType$iv = new TypeToken<BaseResponseBody<Object>>(){}.getType();
                        Gson gson = APBaseRepository.access$getCustomGson$p((APBaseRepository)this_$iv);
                        BaseResponseBody responseBody$iv = (BaseResponseBody)(gson == null ? new Gson() : gson).fromJson((gson = response$iv.body()) == null ? null : gson.string(), dataType$iv);
                        if (responseBody$iv.getCode() == 0) {
                            T it = responseBody$iv.getData();
                            return;
                        }
                        APError error = new APError(responseBody$iv.getCode(), responseBody$iv.getMessage());
                        boolean bl = false;
                        if (this.$isReauthorizationOn$inlined) {
                            APError aPError = error;
                            int n = 401;
                            if (aPError.getCode() == n) {
                                APBaseRepository.access$authorize(this.this$0, this.$authRequestResultCallback$inlined);
                                return;
                            }
                        }
                        APError it = error;
                        return;
                    }
                    APError error = new APError(response$iv.code(), response$iv.message());
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                        if (aPError.getCode() == n) {
                            APBaseRepository.access$authorize(this.this$0, this.$authRequestResultCallback$inlined);
                            return;
                        }
                    }
                    APError it = error;
                    return;
                }
                catch (Exception e$iv) {
                    e$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError it = error;
                    return;
                }
                catch (IllegalStateException stateException$iv) {
                    stateException$iv.printStackTrace();
                    APError error = null;
                    boolean bl = false;
                    if (this.$isReauthorizationOn$inlined) {
                        APError aPError = error;
                        int n = 401;
                    }
                    APError it = error;
                    return;
                }
            }
        });
        thread$iv$iv.start();
        if (StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"token", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url$iv$iv, (CharSequence)"config", (boolean)false, (int)2, null)) {
            thread$iv$iv.join();
        }
    }
}

