/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.apview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import androidx.core.os.BundleKt;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.R;
import plus.adaptive.sdk.core.managers.APActionsManager;
import plus.adaptive.sdk.core.managers.NetworkServiceManager;
import plus.adaptive.sdk.core.managers.OnTokenResponse;
import plus.adaptive.sdk.core.providers.AppServiceProviderKt;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.listeners.APCustomActionListener;
import plus.adaptive.sdk.data.models.AuthTokenData;
import plus.adaptive.sdk.data.models.EventObserver;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.models.story.APBookmarkSnapList;
import plus.adaptive.sdk.data.models.story.APOuterStyles;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.TemplateViewType;
import plus.adaptive.sdk.ext.ViewExtensionKt;
import plus.adaptive.sdk.ui.ViewControllerDelegateProtocol;
import plus.adaptive.sdk.ui.apview.APViewFragment;
import plus.adaptive.sdk.ui.apview.CampaignAdapter;
import plus.adaptive.sdk.ui.apview.CirclePagerIndicatorDecoration;
import plus.adaptive.sdk.ui.apview.SpaceDecoration;
import plus.adaptive.sdk.ui.apview.vm.APViewVMDelegateProtocol;
import plus.adaptive.sdk.ui.apview.vm.APViewViewModel;
import plus.adaptive.sdk.ui.apview.vm.APViewViewModelFactory;
import plus.adaptive.sdk.utils.APCrashlyticsUtilsKt;
import plus.adaptive.sdk.utils.APViewUtilsKt;
import plus.adaptive.sdk.utils.AsyncUtilsKt;
import plus.adaptive.sdk.utils.BookmarkUtilsKt;
import plus.adaptive.sdk.utils.ViewUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 Q2\u00020\u00012\u00020\u0002:\u0001QB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020$H\u0002J\u0018\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0018H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020$H\u0016J\"\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u00182\b\b\u0002\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u0018H\u0002J\u0012\u00106\u001a\u00020$2\b\u00107\u001a\u0004\u0018\u000108H\u0016J&\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u0010?\u001a\u00020$H\u0016J\u001a\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020:2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0006\u0010B\u001a\u00020$J\u0006\u0010C\u001a\u00020$J\b\u0010D\u001a\u00020$H\u0002J\u000e\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020\u0016J\u000e\u0010G\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020\nJ\b\u0010J\u001a\u00020$H\u0002J\b\u0010K\u001a\u00020$H\u0002J\u0010\u0010L\u001a\u00020$2\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020$H\u0002J\b\u0010P\u001a\u00020$H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lplus/adaptive/sdk/ui/apview/APViewFragment;", "Landroidx/fragment/app/Fragment;", "Lplus/adaptive/sdk/ui/ViewControllerDelegateProtocol;", "()V", "actionEventObserver", "Lplus/adaptive/sdk/data/models/EventObserver;", "Lplus/adaptive/sdk/data/models/actions/APAction;", "apActionsManager", "Lplus/adaptive/sdk/core/managers/APActionsManager;", "apHasDrafts", "", "Ljava/lang/Boolean;", "apViewFragmentLayoutChangeListener", "Landroid/view/View$OnLayoutChangeListener;", "apViewId", "", "campaignsAdapter", "Lplus/adaptive/sdk/ui/apview/CampaignAdapter;", "canAutoScroll", "circleItemDecoration", "Lplus/adaptive/sdk/ui/apview/CirclePagerIndicatorDecoration;", "customActionListener", "Lplus/adaptive/sdk/data/listeners/APCustomActionListener;", "firstItemWidth", "", "Ljava/lang/Integer;", "handler", "Landroid/os/Handler;", "isResponded", "Lplus/adaptive/sdk/core/managers/OnTokenResponse;", "templateDataModelObserver", "Landroidx/lifecycle/Observer;", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "viewModel", "Lplus/adaptive/sdk/ui/apview/vm/APViewViewModel;", "autoMagnetize", "", "autoScroll", "autoScrollForFullWidthBanner", "autoScrollForOtherView", "checkBookmarks", "template", "checkCampaignVisibilityAndSendEvents", "countHorizontalPositionAndScroll", "width", "last", "createAndExecuteHandlerForAutoScroll", "period", "", "dismissAllDialogs", "magnetizeToPosition", "adapterPosition", "isSmoothly", "snap", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onPause", "onViewCreated", "view", "refresh", "scrollToStart", "sendShownEvents", "setAPCustomActionListener", "listener", "setAPViewId", "setHasDrafts", "hasDrafts", "setupAPEntryPointsRecyclerView", "setupObservers", "showDialog", "dialogFragment", "Landroidx/fragment/app/DialogFragment;", "updateStoriesViewOptions", "updateStoriesVisibility", "Companion", "sdk_release"})
public final class APViewFragment
extends Fragment
implements ViewControllerDelegateProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private APViewViewModel viewModel;
    private String apViewId;
    @Nullable
    private Boolean apHasDrafts;
    private CampaignAdapter campaignsAdapter;
    @Nullable
    private Handler handler;
    @Nullable
    private APActionsManager apActionsManager;
    @Nullable
    private APCustomActionListener customActionListener;
    private boolean canAutoScroll = true;
    @Nullable
    private Integer firstItemWidth;
    @NotNull
    private CirclePagerIndicatorDecoration circleItemDecoration = new CirclePagerIndicatorDecoration();
    @NotNull
    private final OnTokenResponse isResponded = arg_0 -> APViewFragment.isResponded$lambda-5(this, arg_0);
    @NotNull
    private final Observer<APTemplateDataModel> templateDataModelObserver = arg_0 -> APViewFragment.templateDataModelObserver$lambda-7(this, arg_0);
    @NotNull
    private final View.OnLayoutChangeListener apViewFragmentLayoutChangeListener = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> APViewFragment.apViewFragmentLayoutChangeListener$lambda-9(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8);
    @NotNull
    private final EventObserver<APAction> actionEventObserver = new EventObserver((Function1)new Function1<APAction, Unit>(this){
        final /* synthetic */ APViewFragment this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull APAction it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            APActionsManager aPActionsManager = APViewFragment.access$getApActionsManager$p(this.this$0);
            if (aPActionsManager != null) {
                aPActionsManager.runAction(it);
            }
        }
    });
    private static final float MILLISECONDS_PER_INCH = 100.0f;
    @NotNull
    private static final String EXTRA_AP_VIEW_ID = "extra_ap_view_id";
    @NotNull
    private static final String EXTRA_AP_HAS_DRAFTS = "extra_ap_has_drafts";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        String string2;
        Bundle bundle;
        super.onCreate(savedInstanceState);
        if (this.apViewId == null) {
            bundle = this.getArguments();
            String string3 = bundle == null ? "" : (this.apViewId = (string2 = bundle.getString(EXTRA_AP_VIEW_ID)) == null ? "" : string2);
        }
        if (this.apHasDrafts == null) {
            bundle = this.getArguments();
            Boolean bl = this.apHasDrafts = bundle == null ? null : Boolean.valueOf(bundle.getBoolean(EXTRA_AP_HAS_DRAFTS, false));
        }
        if ((bundle = this.getActivity()) != null) {
            string2 = bundle;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            APViewViewModelFactory viewModelFactory = new APViewViewModelFactory((Context)it);
            Object object = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)viewModelFactory).get(APViewViewModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ViewModelProvider(this, viewModelFactory).get(APViewViewModel::class.java)");
            this.viewModel = (APViewViewModel)object;
            object = this.viewModel;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            this.apActionsManager = AppServiceProviderKt.provideAPActionsManager(this, (APViewVMDelegateProtocol)object);
            object = this.customActionListener;
            if (object != null) {
                Object object2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Object callback2 = object2;
                boolean bl6 = false;
                APActionsManager aPActionsManager = this.apActionsManager;
                if (aPActionsManager != null) {
                    aPActionsManager.setAPCustomActionListener((APCustomActionListener)callback2);
                }
            }
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.ap_fragment_ap_view, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.setupObservers();
        boolean bl = false;
        APViewViewModel aPViewViewModel = this.viewModel;
        if (aPViewViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            throw null;
        }
        this.campaignsAdapter = new CampaignAdapter(CollectionsKt.emptyList(), aPViewViewModel);
        this.setupAPEntryPointsRecyclerView();
        aPViewViewModel = this.getView();
        ((LinearLayout)(aPViewViewModel == null ? null : aPViewViewModel.findViewById(R.id.apViewFragmentLayout))).addOnLayoutChangeListener(this.apViewFragmentLayoutChangeListener);
        this.refresh();
        this.autoScroll();
    }

    public void onPause() {
        APViewViewModel aPViewViewModel = this.viewModel;
        if (aPViewViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            throw null;
        }
        aPViewViewModel.onPause();
        super.onPause();
    }

    @Override
    public void showDialog(@NotNull DialogFragment dialogFragment) {
        Intrinsics.checkNotNullParameter((Object)dialogFragment, (String)"dialogFragment");
        dialogFragment.show(this.getChildFragmentManager(), dialogFragment.getTag());
    }

    @Override
    public void dismissAllDialogs() {
        try {
            for (Fragment fragment : this.getChildFragmentManager().getFragments()) {
                if (fragment == null || !(fragment instanceof DialogFragment)) continue;
                ((DialogFragment)fragment).dismiss();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private final void setupObservers() {
        View view = this.getView();
        if (view != null) {
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            NetworkServiceManager networkManager = AppServiceProviderKt.provideNetworkServiceManager(this.getContext());
            APViewViewModel aPViewViewModel = this.viewModel;
            if (aPViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            aPViewViewModel.getTemplateDataModelLiveData().observe(this.getViewLifecycleOwner(), this.templateDataModelObserver);
            aPViewViewModel = this.viewModel;
            if (aPViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            aPViewViewModel.getActionEventLiveData().observe(this.getViewLifecycleOwner(), (Observer)this.actionEventObserver);
            aPViewViewModel = this.viewModel;
            if (aPViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            aPViewViewModel.getNeedToCheckBookmark().observe(this.getViewLifecycleOwner(), arg_0 -> APViewFragment.setupObservers$lambda-4$lambda-3(this, arg_0));
        }
    }

    private final void autoScroll() {
        APTemplateDataModel.Options options;
        Object object = this.viewModel;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            throw null;
        }
        Serializable serializable = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
        APTemplateDataModel.Options options2 = options = serializable == null ? null : serializable.getOptions();
        if (options != null && (serializable = options.getAutoScroll()) != null) {
            object = serializable;
            boolean bl = false;
            boolean bl2 = false;
            double it = ((Number)object).doubleValue();
            boolean bl3 = false;
            this.createAndExecuteHandlerForAutoScroll(2.0);
        }
    }

    private final void createAndExecuteHandlerForAutoScroll(double period) {
        APCrashlyticsUtilsKt.safeRun$default(null, (Function0)new Function0<Unit>(this, period){
            final /* synthetic */ APViewFragment this$0;
            final /* synthetic */ double $period;
            {
                this.this$0 = $receiver;
                this.$period = $period;
                super(0);
            }

            public final void invoke() {
                Looper looper;
                if (APViewFragment.access$getHandler$p(this.this$0) == null && (looper = Looper.myLooper()) != null) {
                    Looper looper2 = looper;
                    APViewFragment aPViewFragment = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    Looper $this$invoke_u24lambda_u2d0 = looper2;
                    boolean bl3 = false;
                    APViewFragment.access$setHandler$p(aPViewFragment, new Handler($this$invoke_u24lambda_u2d0));
                }
                if ((looper = APViewFragment.access$getHandler$p(this.this$0)) != null) {
                    looper.postDelayed(() -> createAndExecuteHandlerForAutoScroll.1.invoke$lambda-1(this.this$0), (long)(this.$period * (double)1000));
                }
            }

            private static final void invoke$lambda-1(APViewFragment this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Object object = APViewFragment.access$getViewModel$p(this$0);
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    throw null;
                }
                APTemplateDataModel aPTemplateDataModel = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
                if (Intrinsics.areEqual(aPTemplateDataModel == null ? null : ((object = aPTemplateDataModel.getOptions()) == null ? null : ((APTemplateDataModel.Options)object).getShowIndicators()), (Object)true)) {
                    APViewFragment.access$autoScrollForFullWidthBanner(this$0);
                } else {
                    APViewFragment.access$autoScrollForOtherView(this$0);
                }
                APViewFragment.access$autoScroll(this$0);
            }
        }, 1, null);
    }

    private final void autoScrollForOtherView() {
        View view = this.getView();
        RecyclerView recyclerView = (RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView));
        if (recyclerView != null) {
            view = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            View $this$autoScrollForOtherView_u24lambda_u2d12 = view;
            boolean bl3 = false;
            if (this.canAutoScroll) {
                Object object;
                Object object2 = $this$autoScrollForOtherView_u24lambda_u2d12.getLayoutManager();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                }
                int last = ((LinearLayoutManager)object2).findLastCompletelyVisibleItemPosition();
                if (this.firstItemWidth == null) {
                    object2 = $this$autoScrollForOtherView_u24lambda_u2d12.findViewHolderForLayoutPosition(0);
                    Integer n = object2 == null ? null : (this.firstItemWidth = (object = object2.itemView) == null ? null : Integer.valueOf(object.getWidth()));
                }
                if ((object2 = this.firstItemWidth) != null) {
                    object = object2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int it = ((Number)object).intValue();
                    boolean bl6 = false;
                    this.countHorizontalPositionAndScroll(it, last);
                }
            }
        }
    }

    private final void countHorizontalPositionAndScroll(int width, int last) {
        View view = this.getView();
        RecyclerView recyclerView = (RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView));
        if (recyclerView != null) {
            view = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            View $this$countHorizontalPositionAndScroll_u24lambda_u2d14 = view;
            boolean bl3 = false;
            Object object = this.campaignsAdapter;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                throw null;
            }
            if (object.getItemCount() > 0) {
                object = this.campaignsAdapter;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                    throw null;
                }
                if (last == object.getItemCount() - 1) {
                    $this$countHorizontalPositionAndScroll_u24lambda_u2d14.smoothScrollToPosition(0);
                } else {
                    Object object2 = this.viewModel;
                    if (object2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        throw null;
                    }
                    object = (APTemplateDataModel)((APViewViewModel)object2).getTemplateDataModelLiveData().getValue();
                    if (object != null && (object2 = ((APTemplateDataModel)object).getOptions()) != null) {
                        Object object3 = object2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Object it = object3;
                        boolean bl6 = false;
                        $this$countHorizontalPositionAndScroll_u24lambda_u2d14.smoothScrollBy(width + (int)((APTemplateDataModel.Options)it).getSpacing(), 0, (Interpolator)new LinearInterpolator());
                    }
                }
                this.checkCampaignVisibilityAndSendEvents();
            }
        }
    }

    private final void autoScrollForFullWidthBanner() {
        View view;
        RecyclerView recyclerView;
        if (this.canAutoScroll && (recyclerView = (RecyclerView)((view = this.getView()) == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView))) != null) {
            view = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            View it = view;
            boolean bl3 = false;
            Object object = it.getLayoutManager();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
            }
            int current = ((LinearLayoutManager)object).findFirstVisibleItemPosition() + 1;
            object = this.campaignsAdapter;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                throw null;
            }
            if (current == object.getItemCount()) {
                this.circleItemDecoration.setCanSetActive(false);
                object = this.getView();
                ((RecyclerView)(object == null ? null : object.findViewById(R.id.apEntryPointsRecyclerView))).smoothScrollToPosition(0);
            } else {
                object = this.getView();
                ((RecyclerView)(object == null ? null : object.findViewById(R.id.apEntryPointsRecyclerView))).smoothScrollToPosition(current);
            }
            this.checkCampaignVisibilityAndSendEvents();
        }
    }

    private final void setupAPEntryPointsRecyclerView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        Object object = this.getView();
        ((RecyclerView)(object == null ? null : object.findViewById(R.id.apEntryPointsRecyclerView))).setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        object = this.getView();
        ((RecyclerView)(object == null ? null : object.findViewById(R.id.apEntryPointsRecyclerView))).addOnScrollListener(new RecyclerView.OnScrollListener(this){
            final /* synthetic */ APViewFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                int n = newState;
                switch (n) {
                    case 0: {
                        int n2;
                        APViewFragment.access$setCanAutoScroll$p(this.this$0, true);
                        APViewFragment.access$autoMagnetize(this.this$0);
                        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                        if (layoutManager == null) {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                        }
                        int n3 = n2 = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                        APViewFragment aPViewFragment = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = n3;
                        boolean bl3 = false;
                        CampaignAdapter campaignAdapter = APViewFragment.access$getCampaignsAdapter$p(aPViewFragment);
                        if (campaignAdapter == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                            throw null;
                        }
                        if (it == campaignAdapter.getItemCount() - 1) break;
                        APViewFragment.access$getCircleItemDecoration$p(aPViewFragment).setCanSetActive(true);
                        break;
                    }
                    case 1: {
                        APViewFragment.access$checkCampaignVisibilityAndSendEvents(this.this$0);
                        APViewFragment.access$getCircleItemDecoration$p(this.this$0).setCanSetActive(true);
                        APViewFragment.access$setCanAutoScroll$p(this.this$0, false);
                        APViewViewModel aPViewViewModel = APViewFragment.access$getViewModel$p(this.this$0);
                        if (aPViewViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            throw null;
                        }
                        aPViewViewModel.onPause();
                    }
                }
            }
        });
        object = this.getView();
        View view = object == null ? null : object.findViewById(R.id.apEntryPointsRecyclerView);
        object = this.campaignsAdapter;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
            throw null;
        }
        ((RecyclerView)view).setAdapter((RecyclerView.Adapter)object);
    }

    private final void checkBookmarks(APTemplateDataModel template) {
        APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this, template){
            final /* synthetic */ APViewFragment this$0;
            final /* synthetic */ APTemplateDataModel $template;
            {
                this.this$0 = $receiver;
                this.$template = $template;
                super(0);
            }

            public final void invoke() {
                block9: {
                    Unit unit;
                    Object it;
                    Unit unit2;
                    Object object = APViewFragment.access$getViewModel$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        throw null;
                    }
                    Object object2 = ((APViewViewModel)object).getBookmark(this.$template.getId());
                    if (object2 == null) {
                        unit2 = null;
                    } else {
                        object = object2;
                        APTemplateDataModel aPTemplateDataModel = this.$template;
                        APViewFragment aPViewFragment = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        it = object;
                        boolean bl3 = false;
                        Collection collection = ((APBookmarkSnapList)it).getSnaps();
                        boolean bl4 = false;
                        if (!collection.isEmpty()) {
                            Campaign campaign = BookmarkUtilsKt.createCampaignForBookmarks(aPTemplateDataModel, (APBookmarkSnapList)it);
                            ArrayList campaignList = (ArrayList)aPTemplateDataModel.getCampaigns();
                            aPTemplateDataModel.setCampaigns((List<Campaign>)BookmarkUtilsKt.removeOrSwapBookmarkCampaign(campaignList, campaign));
                            Object object3 = APViewFragment.access$getCampaignsAdapter$p(aPViewFragment);
                            if (object3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                                throw null;
                            }
                            ((CampaignAdapter)((Object)object3)).updateDataSet(campaignList, (object3 = aPTemplateDataModel.getOptions().getShowBorder()) == null ? false : (Boolean)object3);
                            object3 = APViewFragment.access$getApActionsManager$p(aPViewFragment);
                            if (object3 != null) {
                                object3.setAPStories(APViewUtilsKt.getAPStoriesList(aPTemplateDataModel));
                            }
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block9;
                    object2 = this.this$0;
                    object = this.$template;
                    boolean bl = false;
                    boolean bl5 = false;
                    Object $this$invoke_u24lambda_u2d1 = object2;
                    boolean bl6 = false;
                    it = ((APTemplateDataModel)object).getCampaigns();
                    boolean bl7 = false;
                    if (!it.isEmpty()) {
                        ArrayList campaignList = (ArrayList)((APTemplateDataModel)object).getCampaigns();
                        ((APTemplateDataModel)object).setCampaigns(BookmarkUtilsKt.removeOrSwapBookmarkCampaign$default(campaignList, null, 2, null));
                        Object object4 = APViewFragment.access$getCampaignsAdapter$p((APViewFragment)$this$invoke_u24lambda_u2d1);
                        if (object4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                            throw null;
                        }
                        ((CampaignAdapter)((Object)object4)).updateDataSet(((APTemplateDataModel)object).getCampaigns(), (object4 = ((APTemplateDataModel)object).getOptions().getShowBorder()) == null ? false : (Boolean)object4);
                        object4 = APViewFragment.access$getApActionsManager$p((APViewFragment)$this$invoke_u24lambda_u2d1);
                        if (object4 != null) {
                            object4.setAPStories(APViewUtilsKt.getAPStoriesList((APTemplateDataModel)object));
                        }
                    }
                }
            }
        }, 1, null);
    }

    private final void autoMagnetize() {
        APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ APViewFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Object object = APViewFragment.access$getViewModel$p(this.this$0);
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    throw null;
                }
                APTemplateDataModel aPTemplateDataModel = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
                if (Intrinsics.areEqual(aPTemplateDataModel == null ? null : ((object = aPTemplateDataModel.getOptions()) == null ? null : Boolean.valueOf(((APTemplateDataModel.Options)object).getMagnetize())), (Object)true)) {
                    View view = this.this$0.getView();
                    object = ((RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView))).getLayoutManager();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                    }
                    int positionFirst = ((LinearLayoutManager)object).findFirstVisibleItemPosition();
                    View view2 = this.this$0.getView();
                    view = ((RecyclerView)(view2 == null ? null : view2.findViewById(R.id.apEntryPointsRecyclerView))).getLayoutManager();
                    if (view == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                    }
                    int positionLast = ((LinearLayoutManager)view).findLastVisibleItemPosition();
                    Rect rectFirst = new Rect();
                    Rect rectLast = new Rect();
                    View view3 = this.this$0.getView();
                    RecyclerView.LayoutManager layoutManager = ((RecyclerView)(view3 == null ? null : view3.findViewById(R.id.apEntryPointsRecyclerView))).getLayoutManager();
                    if (layoutManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                    }
                    View view4 = ((LinearLayoutManager)layoutManager).findViewByPosition(positionFirst);
                    if (view4 != null) {
                        view4.getGlobalVisibleRect(rectFirst);
                    }
                    view3 = this.this$0.getView();
                    layoutManager = ((RecyclerView)(view3 == null ? null : view3.findViewById(R.id.apEntryPointsRecyclerView))).getLayoutManager();
                    if (layoutManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                    }
                    view4 = ((LinearLayoutManager)layoutManager).findViewByPosition(positionLast);
                    if (view4 != null) {
                        view4.getGlobalVisibleRect(rectLast);
                    }
                    if (rectFirst.width() > rectLast.width()) {
                        APViewFragment.magnetizeToPosition$default(this.this$0, positionFirst, false, -1, 2, null);
                    } else if (rectFirst.width() < rectLast.width()) {
                        APViewFragment.magnetizeToPosition$default(this.this$0, positionLast, false, 1, 2, null);
                    }
                }
            }
        }, 1, null);
    }

    private final void magnetizeToPosition(int adapterPosition, boolean isSmoothly, int snap) {
        APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this, isSmoothly, adapterPosition, snap){
            final /* synthetic */ APViewFragment this$0;
            final /* synthetic */ boolean $isSmoothly;
            final /* synthetic */ int $adapterPosition;
            final /* synthetic */ int $snap;
            {
                this.this$0 = $receiver;
                this.$isSmoothly = $isSmoothly;
                this.$adapterPosition = $adapterPosition;
                this.$snap = $snap;
                super(0);
            }

            public final void invoke() {
                Context context = this.this$0.getContext();
                if (context != null) {
                    LinearLayoutManager layoutManager;
                    Context context2 = context;
                    APViewFragment aPViewFragment = this.this$0;
                    boolean bl = this.$isSmoothly;
                    int n = this.$adapterPosition;
                    int n2 = this.$snap;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Context it = context2;
                    boolean bl4 = false;
                    View view = aPViewFragment.getView();
                    RecyclerView recyclerView = (RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView));
                    RecyclerView.LayoutManager layoutManager2 = recyclerView == null ? null : recyclerView.getLayoutManager();
                    LinearLayoutManager linearLayoutManager = layoutManager = layoutManager2 instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager2 : null;
                    if (bl) {
                        recyclerView = aPViewFragment.getContext();
                        LinearSmoothScroller smoothScroller2 = new LinearSmoothScroller(n2, (Context)recyclerView){
                            final /* synthetic */ int $snap;
                            {
                                this.$snap = $snap;
                                super($super_call_param$1);
                            }

                            protected int getHorizontalSnapPreference() {
                                return this.$snap;
                            }

                            protected float calculateSpeedPerPixel(@NotNull DisplayMetrics displayMetrics) {
                                Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
                                return 100.0f / (float)displayMetrics.densityDpi;
                            }
                        };
                        smoothScroller2.setTargetPosition(n);
                        recyclerView = layoutManager;
                        if (recyclerView != null) {
                            recyclerView.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller2);
                        }
                    } else {
                        layoutManager2 = layoutManager;
                        if (layoutManager2 != null) {
                            layoutManager2.scrollToPosition(n);
                        }
                    }
                }
            }
        }, 1, null);
    }

    static /* synthetic */ void magnetizeToPosition$default(APViewFragment aPViewFragment, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = true;
        }
        aPViewFragment.magnetizeToPosition(n, bl, n2);
    }

    private final void checkCampaignVisibilityAndSendEvents() {
        AsyncUtilsKt.runDelayedTask((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ APViewFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ APViewFragment this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        String templateId;
                        String string2;
                        Object object;
                        int n;
                        int n2;
                        View view = this.this$0.getView();
                        RecyclerView recyclerView = (RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView));
                        RecyclerView.LayoutManager layoutManager = recyclerView == null ? null : recyclerView.getLayoutManager();
                        LinearLayoutManager layoutManager2 = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
                        recyclerView = layoutManager2;
                        int firstVisibleIndex = recyclerView == null ? -1 : (n2 = recyclerView.findFirstVisibleItemPosition());
                        view = layoutManager2;
                        int lastVisibleIndex = view == null ? -1 : (n = view.findLastVisibleItemPosition());
                        APViewViewModel aPViewViewModel = APViewFragment.access$getViewModel$p(this.this$0);
                        if (aPViewViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            throw null;
                        }
                        Object object2 = (APTemplateDataModel)aPViewViewModel.getTemplateDataModelLiveData().getValue();
                        Object object3 = object = object2 == null ? null : ((APTemplateDataModel)object2).getId();
                        if (object == null) {
                            object2 = APViewFragment.access$getViewModel$p(this.this$0);
                            if (object2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                                throw null;
                            }
                            string2 = ((APViewViewModel)object2).getAPViewId();
                        } else {
                            string2 = templateId = object;
                        }
                        if (firstVisibleIndex != -1 && lastVisibleIndex != -1) {
                            object = APViewFragment.access$getCampaignsAdapter$p(this.this$0);
                            if (object == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                                throw null;
                            }
                            ((CampaignAdapter)((Object)object)).chekVisibilityAndSendAnalyticsFor(firstVisibleIndex, lastVisibleIndex, templateId);
                        }
                    }
                }, 1, null);
            }
        }), 500L);
    }

    private final void sendShownEvents() {
        AsyncUtilsKt.runDelayedTask((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ APViewFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ APViewFragment this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        String templateId;
                        String string2;
                        Object object;
                        int n;
                        int n2;
                        View view = this.this$0.getView();
                        RecyclerView recyclerView = (RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView));
                        RecyclerView.LayoutManager layoutManager = recyclerView == null ? null : recyclerView.getLayoutManager();
                        LinearLayoutManager layoutManager2 = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
                        recyclerView = layoutManager2;
                        int firstVisibleIndex = recyclerView == null ? -1 : (n2 = recyclerView.findFirstVisibleItemPosition());
                        view = layoutManager2;
                        int lastVisibleIndex = view == null ? -1 : (n = view.findLastVisibleItemPosition());
                        APViewViewModel aPViewViewModel = APViewFragment.access$getViewModel$p(this.this$0);
                        if (aPViewViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            throw null;
                        }
                        Object object2 = (APTemplateDataModel)aPViewViewModel.getTemplateDataModelLiveData().getValue();
                        Object object3 = object = object2 == null ? null : ((APTemplateDataModel)object2).getId();
                        if (object == null) {
                            object2 = APViewFragment.access$getViewModel$p(this.this$0);
                            if (object2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                                throw null;
                            }
                            string2 = ((APViewViewModel)object2).getAPViewId();
                        } else {
                            string2 = templateId = object;
                        }
                        if (firstVisibleIndex != -1 && lastVisibleIndex != -1) {
                            object = APViewFragment.access$getCampaignsAdapter$p(this.this$0);
                            if (object == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                                throw null;
                            }
                            ((CampaignAdapter)((Object)object)).sendAnalyticsFor(firstVisibleIndex, lastVisibleIndex, templateId);
                        }
                    }
                }, 1, null);
            }
        }), 500L);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateStoriesVisibility() {
        View view;
        CampaignAdapter campaignAdapter;
        if (AppServiceProviderKt.provideAPSDKManager$default(null, 1, null).isStarted()) {
            campaignAdapter = this.campaignsAdapter;
            if (campaignAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                throw null;
            }
            if (campaignAdapter.getItemCount() != 0) {
                APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ APViewFragment this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        View view = this.this$0.getView();
                        LinearLayout linearLayout = (LinearLayout)(view == null ? null : view.findViewById(R.id.apViewFragmentLayout));
                        if (linearLayout != null) {
                            ViewExtensionKt.show((View)linearLayout);
                        }
                        APViewFragment.access$updateStoriesViewOptions(this.this$0);
                        APViewFragment.access$sendShownEvents(this.this$0);
                    }
                }, 1, null);
                return;
            }
        }
        if ((campaignAdapter = (LinearLayout)((view = this.getView()) == null ? null : view.findViewById(R.id.apViewFragmentLayout))) == null) {
            return;
        }
        ViewExtensionKt.hide((View)campaignAdapter);
    }

    private final void updateStoriesViewOptions() {
        Object object = this.viewModel;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            throw null;
        }
        APTemplateDataModel aPTemplateDataModel = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
        if (aPTemplateDataModel != null) {
            object = aPTemplateDataModel;
            boolean bl = false;
            boolean bl2 = false;
            Object template = object;
            boolean bl3 = false;
            double d = ((APTemplateDataModel)template).getOptions().getScreenWidth();
            double d2 = 0.001;
            boolean bl4 = false;
            double baseScreenWidth = Math.max(d, d2);
            Object object2 = this.getView();
            float scaleFactor = (float)((double)((LinearLayout)(object2 == null ? null : object2.findViewById(R.id.apViewFragmentLayout))).getWidth() / baseScreenWidth);
            object2 = ((APTemplateDataModel)template).getOptions().getPadding();
            int n = 0;
            boolean bl5 = false;
            View $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d16 = object2;
            boolean bl6 = false;
            View view = this.getView();
            ((RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView))).setPadding((int)($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d16.getLeft() * (double)scaleFactor), (int)($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d16.getTop() * (double)scaleFactor), (int)($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d16.getRight() * (double)scaleFactor), (int)($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d16.getBottom() * (double)scaleFactor));
            while (((RecyclerView)((object2 = this.getView()) == null ? null : object2.findViewById(R.id.apEntryPointsRecyclerView))).getItemDecorationCount() > 0) {
                object2 = this.getView();
                ((RecyclerView)(object2 == null ? null : object2.findViewById(R.id.apEntryPointsRecyclerView))).removeItemDecorationAt(0);
            }
            if (!Intrinsics.areEqual((Object)((APTemplateDataModel)template).getOptions().getShowIndicators(), (Object)true)) {
                object2 = this.getView();
                ((RecyclerView)(object2 == null ? null : object2.findViewById(R.id.apEntryPointsRecyclerView))).addItemDecoration((RecyclerView.ItemDecoration)new SpaceDecoration((int)(((APTemplateDataModel)template).getOptions().getSpacing() * (double)scaleFactor)));
            } else {
                object2 = this.campaignsAdapter;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                    throw null;
                }
                if (object2.getItemCount() > 1) {
                    object2 = this.getView();
                    ((RecyclerView)(object2 == null ? null : object2.findViewById(R.id.apEntryPointsRecyclerView))).addItemDecoration((RecyclerView.ItemDecoration)this.circleItemDecoration);
                }
            }
            object2 = ViewUtilsKt.getViewType((APTemplateDataModel)template);
            n = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n) {
                case 1: {
                    APTemplateDataModel.Options options = ((APTemplateDataModel)template).getOptions();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    APTemplateDataModel.Options $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d17 = options;
                    boolean bl9 = false;
                    CampaignAdapter campaignAdapter = this.campaignsAdapter;
                    if (campaignAdapter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                        throw null;
                    }
                    campaignAdapter.updateEntryOptions(new CampaignAdapter.StoriesOptions($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d17.getWidth(), $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d17.getHeight(), $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d17.getCornerRadius()), scaleFactor);
                    break;
                }
                case 2: {
                    APOuterStyles aPOuterStyles = ((APTemplateDataModel)template).getOptions().getOuterStyles();
                    if (aPOuterStyles == null) break;
                    APOuterStyles aPOuterStyles2 = aPOuterStyles;
                    boolean bl8 = false;
                    boolean bl10 = false;
                    APOuterStyles $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d18 = aPOuterStyles2;
                    boolean bl11 = false;
                    CampaignAdapter campaignAdapter = this.campaignsAdapter;
                    if (campaignAdapter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"campaignsAdapter");
                        throw null;
                    }
                    campaignAdapter.updateEntryOptions(new CampaignAdapter.StoriesOptions($this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d18.getWidth(), $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d18.getHeight(), $this$updateStoriesViewOptions_u24lambda_u2d19_u24lambda_u2d18.getCornerRadius()), scaleFactor);
                    APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ APViewFragment this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            APViewViewModel aPViewViewModel = APViewFragment.access$getViewModel$p(this.this$0);
                            if (aPViewViewModel == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                                throw null;
                            }
                            APViewViewModel aPViewViewModel2 = aPViewViewModel;
                            aPViewViewModel = this.this$0.requireContext();
                            Intrinsics.checkNotNullExpressionValue((Object)aPViewViewModel, (String)"requireContext()");
                            aPViewViewModel2.preloadAllSnapImages((Context)aPViewViewModel);
                        }
                    }, 1, null);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void refresh() {
        if (this.viewModel == null) {
            return;
        }
        NetworkServiceManager networkManager = AppServiceProviderKt.provideNetworkServiceManager(this.getContext());
        LiveData<AuthTokenData> tokenLiveData = networkManager.getTokenLiveData();
        Object object = (AuthTokenData)tokenLiveData.getValue();
        if ((object == null ? null : ((AuthTokenData)object).getToken()) == null) {
            object = this.getContext();
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                OnTokenResponse onTokenResponse = this.isResponded;
                AppServiceProviderKt.provideAPSDKManager((Context)it).authorize(true, onTokenResponse);
            }
        } else {
            object = this.viewModel;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            Object object3 = object;
            object = this.apViewId;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apViewId");
                throw null;
            }
            ((APViewViewModel)object3).requestTemplate((String)object, (object = this.apHasDrafts) == null ? false : (Boolean)object);
        }
    }

    public final void setAPCustomActionListener(@NotNull APCustomActionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.customActionListener = listener;
        APActionsManager aPActionsManager = this.apActionsManager;
        if (aPActionsManager != null) {
            aPActionsManager.setAPCustomActionListener(listener);
        }
    }

    public final void setAPViewId(@NotNull String apViewId) {
        Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
        this.apViewId = apViewId;
        this.refresh();
    }

    public final void setHasDrafts(boolean hasDrafts) {
        this.apHasDrafts = hasDrafts;
    }

    public final void scrollToStart() {
        View view = this.getView();
        ((RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView))).smoothScrollToPosition(0);
    }

    public void _$_clearFindViewByIdCache() {
    }

    private static final void setupObservers$lambda-4$lambda-3(APViewFragment this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Intrinsics.areEqual((Object)it, (Object)true)) {
            Object object = this$0.viewModel;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            APTemplateDataModel aPTemplateDataModel = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
            if (aPTemplateDataModel != null) {
                object = aPTemplateDataModel;
                boolean bl = false;
                boolean bl2 = false;
                Object it2 = object;
                boolean bl3 = false;
                this$0.checkBookmarks((APTemplateDataModel)it2);
                this$0.updateStoriesVisibility();
            }
        }
    }

    private static final void isResponded$lambda-5(APViewFragment this$0, String token) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Object object = this$0.viewModel;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            throw null;
        }
        APViewViewModel aPViewViewModel = object;
        object = this$0.apViewId;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apViewId");
            throw null;
        }
        aPViewViewModel.requestTemplate((String)object, (object = this$0.apHasDrafts) == null ? false : (Boolean)object);
        APConstantsKt.setAUTHORIZATION_TOKEN(token);
    }

    private static final void templateDataModelObserver$lambda-7(APViewFragment this$0, APTemplateDataModel dataModel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        APTemplateDataModel aPTemplateDataModel = dataModel;
        if (aPTemplateDataModel != null) {
            APTemplateDataModel aPTemplateDataModel2 = aPTemplateDataModel;
            boolean bl = false;
            boolean bl2 = false;
            APTemplateDataModel it = aPTemplateDataModel2;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)dataModel, (String)"dataModel");
            this$0.checkBookmarks(dataModel);
            this$0.updateStoriesVisibility();
        }
    }

    private static final void apViewFragmentLayoutChangeListener$lambda-9(APViewFragment this$0, View v, int $noName_1, int $noName_2, int $noName_3, int $noName_4, int oldLeft, int $noName_6, int oldRight, int $noName_8) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int oldWidth = oldRight - oldLeft;
        if (v.getWidth() != oldWidth) {
            Object object = this$0.viewModel;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                throw null;
            }
            APTemplateDataModel aPTemplateDataModel = (APTemplateDataModel)((APViewViewModel)object).getTemplateDataModelLiveData().getValue();
            if (aPTemplateDataModel != null) {
                object = aPTemplateDataModel;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                View view = this$0.getView();
                ((RecyclerView)(view == null ? null : view.findViewById(R.id.apEntryPointsRecyclerView))).scrollToPosition(0);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final APViewFragment newInstance(@NotNull String apViewId, boolean apHasDrafts) {
        return Companion.newInstance(apViewId, apHasDrafts);
    }

    public static final /* synthetic */ Handler access$getHandler$p(APViewFragment $this) {
        return $this.handler;
    }

    public static final /* synthetic */ void access$setHandler$p(APViewFragment $this, Handler handler) {
        $this.handler = handler;
    }

    public static final /* synthetic */ APViewViewModel access$getViewModel$p(APViewFragment $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ void access$autoScrollForFullWidthBanner(APViewFragment $this) {
        $this.autoScrollForFullWidthBanner();
    }

    public static final /* synthetic */ void access$autoScrollForOtherView(APViewFragment $this) {
        $this.autoScrollForOtherView();
    }

    public static final /* synthetic */ void access$autoScroll(APViewFragment $this) {
        $this.autoScroll();
    }

    public static final /* synthetic */ void access$setCanAutoScroll$p(APViewFragment $this, boolean bl) {
        $this.canAutoScroll = bl;
    }

    public static final /* synthetic */ void access$autoMagnetize(APViewFragment $this) {
        $this.autoMagnetize();
    }

    public static final /* synthetic */ void access$checkCampaignVisibilityAndSendEvents(APViewFragment $this) {
        $this.checkCampaignVisibilityAndSendEvents();
    }

    public static final /* synthetic */ CirclePagerIndicatorDecoration access$getCircleItemDecoration$p(APViewFragment $this) {
        return $this.circleItemDecoration;
    }

    public static final /* synthetic */ CampaignAdapter access$getCampaignsAdapter$p(APViewFragment $this) {
        return $this.campaignsAdapter;
    }

    public static final /* synthetic */ APActionsManager access$getApActionsManager$p(APViewFragment $this) {
        return $this.apActionsManager;
    }

    public static final /* synthetic */ void access$updateStoriesViewOptions(APViewFragment $this) {
        $this.updateStoriesViewOptions();
    }

    public static final /* synthetic */ void access$sendShownEvents(APViewFragment $this) {
        $this.sendShownEvents();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lplus/adaptive/sdk/ui/apview/APViewFragment$Companion;", "", "()V", "EXTRA_AP_HAS_DRAFTS", "", "EXTRA_AP_VIEW_ID", "MILLISECONDS_PER_INCH", "", "newInstance", "Lplus/adaptive/sdk/ui/apview/APViewFragment;", "apViewId", "apHasDrafts", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final APViewFragment newInstance(@NotNull String apViewId, boolean apHasDrafts) {
            Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
            APViewFragment aPViewFragment = new APViewFragment();
            boolean bl = false;
            boolean bl2 = false;
            APViewFragment $this$newInstance_u24lambda_u2d0 = aPViewFragment;
            boolean bl3 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APViewFragment.EXTRA_AP_VIEW_ID, (Object)apViewId), TuplesKt.to((Object)APViewFragment.EXTRA_AP_HAS_DRAFTS, (Object)apHasDrafts)};
            $this$newInstance_u24lambda_u2d0.setArguments(BundleKt.bundleOf((Pair[])pairArray));
            return aPViewFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TemplateViewType.values().length];
            nArray[TemplateViewType.BANNER.ordinal()] = 1;
            nArray[TemplateViewType.STORY.ordinal()] = 2;
            nArray[TemplateViewType.EMPTY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

