/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.apview;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u0004H\u0002J(\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\nH\u0002J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lplus/adaptive/sdk/ui/apview/CirclePagerIndicatorDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "()V", "canSetActive", "", "getCanSetActive", "()Z", "setCanSetActive", "(Z)V", "colorActive", "", "colorInactive", "mIndicatorHeight", "mIndicatorItemLength", "", "mIndicatorItemPadding", "mIndicatorStrokeWidth", "mInterpolator", "Landroid/view/animation/Interpolator;", "mPaint", "Landroid/graphics/Paint;", "drawHighlights", "", "c", "Landroid/graphics/Canvas;", "indicatorStartX", "indicatorPosY", "highlightPosition", "isLast", "drawInactiveIndicators", "itemCount", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDrawOver", "Companion", "sdk_release"})
public final class CirclePagerIndicatorDecoration
extends RecyclerView.ItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int colorActive = Color.parseColor((String)"#565A5F");
    private final int colorInactive = Color.parseColor((String)"#DFE2E7");
    private final int mIndicatorHeight = (int)(DP * (float)16);
    private final float mIndicatorStrokeWidth = DP * (float)3;
    private final float mIndicatorItemLength = DP * (float)3;
    private final float mIndicatorItemPadding = DP * (float)8;
    @NotNull
    private final Interpolator mInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
    @NotNull
    private final Paint mPaint = new Paint();
    private boolean canSetActive = true;
    private static final float DP = Resources.getSystem().getDisplayMetrics().density;

    public CirclePagerIndicatorDecoration() {
        this.mPaint.setStrokeWidth(this.mIndicatorStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
    }

    public final boolean getCanSetActive() {
        return this.canSetActive;
    }

    public final void setCanSetActive(boolean bl) {
        this.canSetActive = bl;
    }

    public void onDrawOver(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        View activeChild;
        int n;
        int activePosition;
        LinearLayoutManager layoutManager;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDrawOver(c, parent, state);
        RecyclerView.Adapter adapter = parent.getAdapter();
        Intrinsics.checkNotNull((Object)adapter);
        int itemCount = adapter.getItemCount();
        float totalLength = this.mIndicatorItemLength * (float)itemCount;
        float paddingBetweenItems = (float)RangesKt.coerceAtLeast((int)0, (int)(itemCount - 1)) * this.mIndicatorItemPadding;
        float indicatorTotalWidth = totalLength + paddingBetweenItems;
        float indicatorStartX = ((float)parent.getWidth() - indicatorTotalWidth) / 2.0f;
        float indicatorPosY = (float)parent.getHeight() - (float)this.mIndicatorHeight / 2.0f;
        this.drawInactiveIndicators(c, indicatorStartX, indicatorPosY, itemCount);
        LinearLayoutManager linearLayoutManager = layoutManager = (LinearLayoutManager)parent.getLayoutManager();
        int n2 = activePosition = linearLayoutManager == null ? 0 : (n = linearLayoutManager.findFirstVisibleItemPosition());
        if (activePosition == -1) {
            return;
        }
        LinearLayoutManager linearLayoutManager2 = layoutManager;
        View view = activeChild = linearLayoutManager2 == null ? null : linearLayoutManager2.findViewByPosition(activePosition);
        Integer left = view == null ? null : Integer.valueOf(view.getLeft());
        View view2 = activeChild;
        Integer width = view2 == null ? null : Integer.valueOf(view2.getWidth());
        boolean last = itemCount - 1 == activePosition;
        Integer n3 = width;
        if (n3 != null) {
            Integer n4 = n3;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n4).intValue();
            boolean bl3 = false;
            if (left != null) {
                this.drawHighlights(c, indicatorStartX, indicatorPosY, activePosition, last);
            }
        }
    }

    private final void drawInactiveIndicators(Canvas c, float indicatorStartX, float indicatorPosY, int itemCount) {
        this.mPaint.setColor(this.colorInactive);
        float itemWidth = this.mIndicatorItemLength + this.mIndicatorItemPadding;
        float start = indicatorStartX;
        int n = 0;
        if (n < itemCount) {
            do {
                int i2 = n++;
                c.drawCircle(start, indicatorPosY, this.mIndicatorItemLength / 2.0f, this.mPaint);
                start += itemWidth;
            } while (n < itemCount);
        }
    }

    private final void drawHighlights(Canvas c, float indicatorStartX, float indicatorPosY, int highlightPosition, boolean isLast) {
        this.mPaint.setColor(this.colorActive);
        float itemWidth = this.mIndicatorItemLength + this.mIndicatorItemPadding;
        float highlightStart = indicatorStartX + itemWidth * (float)highlightPosition;
        if (highlightPosition == 0) {
            this.canSetActive = true;
        }
        if (this.canSetActive) {
            c.drawCircle(highlightStart, indicatorPosY, this.mIndicatorItemLength / 2.0f, this.mPaint);
        }
    }

    static /* synthetic */ void drawHighlights$default(CirclePagerIndicatorDecoration circlePagerIndicatorDecoration, Canvas canvas, float f, float f2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        circlePagerIndicatorDecoration.drawHighlights(canvas, f, f2, n, bl);
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        outRect.bottom = this.mIndicatorHeight;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lplus/adaptive/sdk/ui/apview/CirclePagerIndicatorDecoration$Companion;", "", "()V", "DP", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

