/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.apview.vm;

import android.content.Context;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APCacheManager;
import plus.adaptive.sdk.core.managers.APSharedPreferences;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.APLayer;
import plus.adaptive.sdk.data.models.APUser;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.Layer;
import plus.adaptive.sdk.data.models.story.Snap;
import plus.adaptive.sdk.data.models.story.Story;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.data.repositories.APViewRepository;
import plus.adaptive.sdk.utils.APComponentUtilsKt;
import plus.adaptive.sdk.utils.APCrashlyticsUtilsKt;
import plus.adaptive.sdk.utils.AsyncUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011J\u0010\u0010 \u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u001a\u0010$\u001a\u00020\u000e2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lplus/adaptive/sdk/ui/apview/vm/APViewlessViewModel;", "Landroidx/lifecycle/ViewModel;", "apViewRepository", "Lplus/adaptive/sdk/data/repositories/APViewRepository;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "cacheManager", "Lplus/adaptive/sdk/core/managers/APCacheManager;", "preferences", "Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "(Lplus/adaptive/sdk/data/repositories/APViewRepository;Lplus/adaptive/sdk/data/repositories/APUserRepository;Lplus/adaptive/sdk/core/managers/APCacheManager;Lplus/adaptive/sdk/core/managers/APSharedPreferences;)V", "listener", "Lkotlin/Function1;", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "", "getDataModel", "apViewId", "", "getLocale", "getWatchedInstructionCount", "", "instructionId", "getWatchedPopupIdCount", "popupId", "loadTemplateFromCache", "preloadImages", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "requestTemplate", "hasDrafts", "", "saveInstructionShowCount", "saveWatchedPopupIdCount", "setDataModel", "dataModel", "appViewId", "setListener", "instructionListener", "Companion", "sdk_release"})
public final class APViewlessViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final APViewRepository apViewRepository;
    @NotNull
    private final APUserRepository userRepository;
    @NotNull
    private final APCacheManager cacheManager;
    @NotNull
    private final APSharedPreferences preferences;
    @Nullable
    private Function1<? super APTemplateDataModel, Unit> listener;
    @Nullable
    private static APTemplateDataModel dataModelForPopup;
    @Nullable
    private static String apId;

    public APViewlessViewModel(@NotNull APViewRepository apViewRepository, @NotNull APUserRepository userRepository, @NotNull APCacheManager cacheManager, @NotNull APSharedPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)apViewRepository, (String)"apViewRepository");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.apViewRepository = apViewRepository;
        this.userRepository = userRepository;
        this.cacheManager = cacheManager;
        this.preferences = preferences;
    }

    private final void setDataModel(APTemplateDataModel dataModel, String appViewId) {
        Object object = this.listener;
        if (object != null) {
            object.invoke((Object)dataModel);
        }
        dataModelForPopup = dataModel;
        object = dataModel.getCampaigns();
        boolean bl = false;
        if (!object.isEmpty()) {
            this.cacheManager.saveAPTemplateViewDataModelToCache(appViewId, dataModel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final APTemplateDataModel getDataModel(@NotNull String apViewId) {
        APTemplateDataModel aPTemplateDataModel;
        Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
        if (Intrinsics.areEqual((Object)apViewId, (Object)apId)) {
            void var2_2;
            APTemplateDataModel newTemplateData = dataModelForPopup;
            apId = null;
            dataModelForPopup = null;
            aPTemplateDataModel = var2_2;
        } else {
            apId = null;
            dataModelForPopup = null;
            aPTemplateDataModel = this.loadTemplateFromCache(apViewId);
        }
        return aPTemplateDataModel;
    }

    public final void requestTemplate(@NotNull String apViewId, boolean hasDrafts) {
        Intrinsics.checkNotNullParameter((Object)apViewId, (String)"apViewId");
        apId = apViewId;
        dataModelForPopup = this.loadTemplateFromCache(apViewId);
        this.apViewRepository.requestTemplate(apViewId, hasDrafts, new RequestResultCallback<APTemplateDataModel>(this, apViewId){
            final /* synthetic */ APViewlessViewModel this$0;
            final /* synthetic */ String $apViewId;
            {
                this.this$0 = $receiver;
                this.$apViewId = $apViewId;
            }

            public void success(@NotNull APTemplateDataModel response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                AsyncUtilsKt.runOnMainThread((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, response, this.$apViewId){
                    final /* synthetic */ APViewlessViewModel this$0;
                    final /* synthetic */ APTemplateDataModel $response;
                    final /* synthetic */ String $apViewId;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        this.$apViewId = $apViewId;
                        super(0);
                    }

                    public final void invoke() {
                        APViewlessViewModel.access$setDataModel(this.this$0, this.$response, this.$apViewId);
                    }
                }));
            }

            public void failure(@Nullable APError error) {
                APViewlessViewModel.access$loadTemplateFromCache(this.this$0, this.$apViewId);
            }
        });
    }

    public static /* synthetic */ void requestTemplate$default(APViewlessViewModel aPViewlessViewModel, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        aPViewlessViewModel.requestTemplate(string, bl);
    }

    private final APTemplateDataModel loadTemplateFromCache(String apViewId) {
        Ref.ObjectRef data = new Ref.ObjectRef();
        this.cacheManager.loadAPTemplateViewDataModelFromCache(apViewId, (Function1<? super APTemplateDataModel, Unit>)((Function1)new Function1<APTemplateDataModel, Unit>((Ref.ObjectRef<APTemplateDataModel>)data){
            final /* synthetic */ Ref.ObjectRef<APTemplateDataModel> $data;
            {
                this.$data = $data;
                super(1);
            }

            public final void invoke(@Nullable APTemplateDataModel dataModel) {
                if (dataModel != null) {
                    this.$data.element = dataModel;
                }
            }
        }));
        return (APTemplateDataModel)data.element;
    }

    public final void preloadImages(@NotNull FragmentActivity fragmentActivity) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        APCrashlyticsUtilsKt.throwableRun$default(null, (Function0)new Function0<Unit>(fragmentActivity){
            final /* synthetic */ FragmentActivity $fragmentActivity;
            {
                this.$fragmentActivity = $fragmentActivity;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List<Campaign> list;
                APTemplateDataModel aPTemplateDataModel = APViewlessViewModel.access$getDataModelForPopup$cp();
                if (aPTemplateDataModel != null && (list = aPTemplateDataModel.getCampaigns()) != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    FragmentActivity fragmentActivity = this.$fragmentActivity;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Campaign campaign = (Campaign)element$iv;
                        boolean bl = false;
                        Object object = campaign.getBody().getInstruction();
                        Story.Body body = object == null ? null : ((Story)object).getBody();
                        if (body == null || (object = body.getSnaps()) == null) continue;
                        Iterable $this$forEach$iv2 = (Iterable)object;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            Snap snap = (Snap)element$iv2;
                            boolean bl2 = false;
                            Iterable $this$forEach$iv3 = snap.getBody().getLayers();
                            boolean $i$f$forEach3 = false;
                            for (T element$iv3 : $this$forEach$iv3) {
                                String string;
                                Layer.Component component;
                                Layer layer = (Layer)element$iv3;
                                boolean bl3 = false;
                                if (layer.getType() != APLayer.Type.IMAGE || (component = layer.getComponent()) == null || (string = component.getUrl()) == null) continue;
                                String string2 = string;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                String it = string2;
                                boolean bl6 = false;
                                APComponentUtilsKt.preloadImage$default((Context)fragmentActivity, it, null, null, 12, null);
                            }
                        }
                    }
                }
            }
        }, 1, null);
    }

    public final void saveInstructionShowCount(@Nullable String instructionId) {
        this.preferences.saveWatchedInstructionCount(instructionId);
    }

    public final int getWatchedInstructionCount(@Nullable String instructionId) {
        return this.preferences.getWatchedInstructionCount(instructionId);
    }

    public final void setListener(@NotNull Function1<? super APTemplateDataModel, Unit> instructionListener) {
        Intrinsics.checkNotNullParameter(instructionListener, (String)"instructionListener");
        this.listener = instructionListener;
    }

    public final void saveWatchedPopupIdCount(@Nullable String popupId) {
        this.preferences.saveWatchedPopupIdCount(popupId);
    }

    public final int getWatchedPopupIdCount(@Nullable String popupId) {
        return this.preferences.getWatchedPopupIdCount(popupId);
    }

    @Nullable
    public final String getLocale() {
        APUser.Device device = this.userRepository.getAPUser().getDevice();
        return device == null ? null : device.getLocale();
    }

    public static final /* synthetic */ void access$setDataModel(APViewlessViewModel $this, APTemplateDataModel dataModel, String appViewId) {
        $this.setDataModel(dataModel, appViewId);
    }

    public static final /* synthetic */ APTemplateDataModel access$loadTemplateFromCache(APViewlessViewModel $this, String apViewId) {
        return $this.loadTemplateFromCache(apViewId);
    }

    public static final /* synthetic */ APTemplateDataModel access$getDataModelForPopup$cp() {
        return dataModelForPopup;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lplus/adaptive/sdk/ui/apview/vm/APViewlessViewModel$Companion;", "", "()V", "apId", "", "dataModelForPopup", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

