/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.components.poll;

import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.managers.APSharedPreferences;
import plus.adaptive.sdk.data.models.APError;
import plus.adaptive.sdk.data.models.APPollData;
import plus.adaptive.sdk.data.models.components.APPollComponent;
import plus.adaptive.sdk.data.models.network.RequestResultCallback;
import plus.adaptive.sdk.data.repositories.APPollRepository;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.ui.components.core.APComponentContainerViewModel;
import plus.adaptive.sdk.ui.components.core.APComponentLifecycleListener;
import plus.adaptive.sdk.ui.components.core.APComponentViewController;
import plus.adaptive.sdk.ui.components.core.vm.APBaseComponentViewModel;
import plus.adaptive.sdk.utils.AsyncUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lplus/adaptive/sdk/ui/components/poll/APPollComponentViewModel;", "Lplus/adaptive/sdk/ui/components/core/vm/APBaseComponentViewModel;", "containerViewModel", "Lplus/adaptive/sdk/ui/components/core/APComponentContainerViewModel;", "lifecycleListener", "Lplus/adaptive/sdk/ui/components/core/APComponentLifecycleListener;", "component", "Lplus/adaptive/sdk/data/models/components/APPollComponent;", "pollRepository", "Lplus/adaptive/sdk/data/repositories/APPollRepository;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "preferences", "Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "(Lplus/adaptive/sdk/ui/components/core/APComponentContainerViewModel;Lplus/adaptive/sdk/ui/components/core/APComponentLifecycleListener;Lplus/adaptive/sdk/data/models/components/APPollComponent;Lplus/adaptive/sdk/data/repositories/APPollRepository;Lplus/adaptive/sdk/data/repositories/APUserRepository;Lplus/adaptive/sdk/core/managers/APSharedPreferences;)V", "pollData", "Lplus/adaptive/sdk/data/models/APPollData;", "getCachedPollData", "getChosenAnswerId", "", "getPollData", "onAnswerChosen", "", "answerId", "onPollBuildFail", "onPollBuildSuccess", "pause", "prepare", "reset", "resume", "saveChosenAnswerId", "savePollData", "sdk_release"})
public final class APPollComponentViewModel
extends APBaseComponentViewModel {
    @NotNull
    private final APPollComponent component;
    @NotNull
    private final APPollRepository pollRepository;
    @Nullable
    private final APUserRepository userRepository;
    @Nullable
    private final APSharedPreferences preferences;
    @Nullable
    private APPollData pollData;

    public APPollComponentViewModel(@NotNull APComponentContainerViewModel containerViewModel, @NotNull APComponentLifecycleListener lifecycleListener, @NotNull APPollComponent component, @NotNull APPollRepository pollRepository, @Nullable APUserRepository userRepository, @Nullable APSharedPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)containerViewModel, (String)"containerViewModel");
        Intrinsics.checkNotNullParameter((Object)lifecycleListener, (String)"lifecycleListener");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)pollRepository, (String)"pollRepository");
        super(containerViewModel, lifecycleListener);
        this.component = component;
        this.pollRepository = pollRepository;
        this.userRepository = userRepository;
        this.preferences = preferences;
    }

    @Override
    public void prepare() {
        this.getLifecycleListener().onReady(false);
        APComponentViewController aPComponentViewController = this.getMComponentViewController();
        if (aPComponentViewController != null) {
            aPComponentViewController.prepare();
        }
        this.pollData = this.getCachedPollData();
        if (this.pollData == null) {
            this.pollRepository.requestPollData(this.component.getId(), new RequestResultCallback<APPollData>(this){
                final /* synthetic */ APPollComponentViewModel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void success(@NotNull APPollData response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    APPollComponentViewModel.access$savePollData(this.this$0, response);
                    APPollComponentViewModel.access$setPollData$p(this.this$0, response);
                    this.this$0.reset();
                }

                public void failure(@Nullable APError error) {
                }
            });
        } else {
            this.reset();
            this.pollRepository.requestPollData(this.component.getId(), new RequestResultCallback<APPollData>(this){
                final /* synthetic */ APPollComponentViewModel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void success(@NotNull APPollData response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    APPollComponentViewModel.access$savePollData(this.this$0, response);
                }

                public void failure(@Nullable APError error) {
                }
            });
        }
    }

    @Override
    public void resume() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void reset() {
        AsyncUtilsKt.runOnMainThread((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ APPollComponentViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                APComponentViewController aPComponentViewController = APPollComponentViewModel.access$getMComponentViewController(this.this$0);
                if (aPComponentViewController != null) {
                    aPComponentViewController.reset();
                }
            }
        }));
    }

    @Nullable
    public final APPollData getPollData() {
        return this.pollData;
    }

    public final void onPollBuildSuccess() {
        this.getLifecycleListener().onReady(true);
    }

    public final void onPollBuildFail() {
        this.getLifecycleListener().onError();
    }

    public final void onAnswerChosen(@NotNull String answerId) {
        Intrinsics.checkNotNullParameter((Object)answerId, (String)"answerId");
        this.pollRepository.submitChosenAnswer(this.component.getId(), answerId, new RequestResultCallback<Object>(this, answerId){
            final /* synthetic */ APPollComponentViewModel this$0;
            final /* synthetic */ String $answerId;
            {
                this.this$0 = $receiver;
                this.$answerId = $answerId;
            }

            public void success(@Nullable Object response) {
                APPollComponentViewModel.access$saveChosenAnswerId(this.this$0, this.$answerId);
            }

            public void failure(@Nullable APError error) {
            }
        });
    }

    private final void saveChosenAnswerId(String answerId) {
        String string;
        APUserRepository aPUserRepository = this.userRepository;
        if (aPUserRepository != null && (string = aPUserRepository.getAPUserId()) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String userId = string2;
            boolean bl3 = false;
            String prefKey = userId + '_' + this.component.getId() + "_poll_chosen_answer_id";
            APSharedPreferences aPSharedPreferences = this.preferences;
            if (aPSharedPreferences != null) {
                aPSharedPreferences.saveString(prefKey, answerId);
            }
        }
    }

    @Nullable
    public final String getChosenAnswerId() {
        String string;
        APUserRepository aPUserRepository = this.userRepository;
        if (aPUserRepository == null) {
            string = null;
        } else {
            String string2 = aPUserRepository.getAPUserId();
            if (string2 == null) {
                string = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String userId = string3;
                boolean bl3 = false;
                String prefKey = userId + '_' + this.component.getId() + "_poll_chosen_answer_id";
                APSharedPreferences aPSharedPreferences = this.preferences;
                string = aPSharedPreferences == null ? null : aPSharedPreferences.getString(prefKey);
            }
        }
        return string;
    }

    private final void savePollData(APPollData pollData) {
        String string;
        APUserRepository aPUserRepository = this.userRepository;
        if (aPUserRepository != null && (string = aPUserRepository.getAPUserId()) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String userId = string2;
            boolean bl3 = false;
            String prefKey = userId + '_' + this.component.getId() + "_poll_data";
            String serializedPollData = new Gson().toJson((Object)pollData);
            APSharedPreferences aPSharedPreferences = this.preferences;
            if (aPSharedPreferences != null) {
                Intrinsics.checkNotNullExpressionValue((Object)serializedPollData, (String)"serializedPollData");
                aPSharedPreferences.saveString(prefKey, serializedPollData);
            }
        }
    }

    private final APPollData getCachedPollData() {
        Object object;
        APUserRepository aPUserRepository = this.userRepository;
        if (aPUserRepository == null) {
            object = null;
        } else {
            String string = aPUserRepository.getAPUserId();
            if (string == null) {
                object = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String userId = string2;
                boolean bl3 = false;
                String prefKey = userId + '_' + this.component.getId() + "_poll_data";
                Object object2 = this.preferences;
                String serializedPollData = object2 == null ? null : ((APSharedPreferences)object2).getString(prefKey);
                try {
                    object2 = (APPollData)new Gson().fromJson(serializedPollData, APPollData.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    object2 = null;
                }
                object = object2;
            }
        }
        return object;
    }

    public static final /* synthetic */ void access$savePollData(APPollComponentViewModel $this, APPollData pollData) {
        $this.savePollData(pollData);
    }

    public static final /* synthetic */ void access$setPollData$p(APPollComponentViewModel $this, APPollData aPPollData) {
        $this.pollData = aPPollData;
    }

    public static final /* synthetic */ APComponentViewController access$getMComponentViewController(APPollComponentViewModel $this) {
        return $this.getMComponentViewController();
    }

    public static final /* synthetic */ void access$saveChosenAnswerId(APPollComponentViewModel $this, String answerId) {
        $this.saveChosenAnswerId(answerId);
    }
}

