/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.components.story;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.R;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APFont;
import plus.adaptive.sdk.data.models.components.APComponent;
import plus.adaptive.sdk.data.models.components.StoryComponent;
import plus.adaptive.sdk.data.models.story.APOuterStyles;
import plus.adaptive.sdk.ext.ImageViewExtensionKt;
import plus.adaptive.sdk.ext.TextViewExtensionKt;
import plus.adaptive.sdk.ui.components.core.APBaseComponentView;
import plus.adaptive.sdk.ui.components.core.vm.APComponentViewModel;
import plus.adaptive.sdk.ui.components.story.StoryComponentViewModel;
import plus.adaptive.sdk.utils.ColorUtilsKt;
import plus.adaptive.sdk.utils.DrawableUtilsKt;
import plus.adaptive.sdk.utils.StorySizeConst;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lplus/adaptive/sdk/ui/components/story/StoryRectComponentView;", "Lplus/adaptive/sdk/ui/components/core/APBaseComponentView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "component", "Lplus/adaptive/sdk/data/models/components/StoryComponent;", "componentViewModel", "Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModel;", "(Landroid/content/Context;Lplus/adaptive/sdk/data/models/components/StoryComponent;Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModel;)V", "initElement", "", "pause", "prepare", "reset", "resume", "updateImageBorder", "sdk_release"})
public final class StoryRectComponentView
extends APBaseComponentView {
    public StoryRectComponentView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public StoryRectComponentView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    public StoryRectComponentView(@NotNull Context context, @NotNull StoryComponent component, @Nullable APComponentViewModel componentViewModel2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(context, component, componentViewModel2, null, 8, null);
    }

    @Override
    protected void initElement() {
        View.inflate((Context)this.getContext(), (int)R.layout.ap_component_rectangle_story, (ViewGroup)((ViewGroup)this));
        this.prepare();
    }

    @Override
    public void prepare() {
        StoryComponent storyComponent;
        APComponent aPComponent = this.getComponent();
        StoryComponent storyComponent2 = storyComponent = aPComponent instanceof StoryComponent ? (StoryComponent)aPComponent : null;
        if (storyComponent != null) {
            aPComponent = storyComponent;
            boolean bl = false;
            boolean bl2 = false;
            APComponent $this$prepare_u24lambda_u2d1 = aPComponent;
            boolean bl3 = false;
            APComponent aPComponent2 = this.getComponent();
            if (aPComponent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.StoryComponent");
            }
            if (((StoryComponent)aPComponent2).isBookmark()) {
                ((TextView)this.findViewById(R.id.appStoryComponentText)).setVisibility(4);
                ((ImageView)this.findViewById(R.id.apComponentBookmarkImageView)).setVisibility(0);
                if (((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getOuterSize() == APOuterStyles.OuterSize.S) {
                    ((ImageView)this.findViewById(R.id.apComponentBookmarkImageView)).setScaleX(0.85f);
                    ((ImageView)this.findViewById(R.id.apComponentBookmarkImageView)).setScaleY(0.85f);
                }
                ((ImageView)this.findViewById(R.id.apComponentBookmarkImageView)).setColorFilter(Color.parseColor((String)APConstantsKt.getBRAND_COLOR()));
                this.updateImageBorder();
            } else {
                int n;
                double d;
                ((ImageView)this.findViewById(R.id.apComponentBookmarkImageView)).setVisibility(8);
                Drawable defaultDrawable = DrawableUtilsKt.createDrawableFromColor$default(ColorUtilsKt.getColorFromHex(((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getOuterImageLoadingColor()), (int)((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getCornerRadius(), null, null, 12, null);
                APOuterStyles.OuterSize outerSize = ((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getOuterSize();
                int n2 = outerSize == null ? -1 : WhenMappings.$EnumSwitchMapping$0[outerSize.ordinal()];
                switch (n2) {
                    case 1: {
                        d = StorySizeConst.INSTANCE.getTEXT_SIZE_S();
                        break;
                    }
                    case 2: {
                        d = StorySizeConst.INSTANCE.getTEXT_SIZE_M();
                        break;
                    }
                    case 3: {
                        d = StorySizeConst.INSTANCE.getTEXT_SIZE_L();
                        break;
                    }
                    default: {
                        d = 10.0 * (double)APConstantsKt.getBASE_SIZE_MULTIPLIER();
                    }
                }
                double textSize = d;
                APOuterStyles.OuterSize outerSize2 = ((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getOuterSize();
                int n3 = outerSize2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[outerSize2.ordinal()];
                switch (n3) {
                    case 1: {
                        n = StorySizeConst.INSTANCE.getTEXT_PADDING_S();
                        break;
                    }
                    case 2: {
                        n = StorySizeConst.INSTANCE.getTEXT_PADDING_M();
                        break;
                    }
                    case 3: {
                        n = StorySizeConst.INSTANCE.getTEXT_PADDING_L();
                        break;
                    }
                    default: {
                        n = 6 * APConstantsKt.getBASE_SIZE_MULTIPLIER();
                    }
                }
                int textPadding = n;
                outerSize2 = (TextView)this.findViewById(R.id.appStoryComponentText);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)outerSize2), (String)"appStoryComponentText");
                View $this$setPadding$iv = (View)outerSize2;
                boolean $i$f$setPadding = false;
                $this$setPadding$iv.setPadding(textPadding, textPadding, textPadding, textPadding);
                APFont font = new APFont("Roboto", APFont.Style.BOLD, textSize, "#ffffff", APFont.Align.BOTTOM, 0.0, null);
                Object object = (TextView)this.findViewById(R.id.appStoryComponentText);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appStoryComponentText");
                TextViewExtensionKt.applyAPFont$default(object, font, 0, (Function0)new Function0<Unit>((StoryComponent)$this$prepare_u24lambda_u2d1, this){
                    final /* synthetic */ StoryComponent $this_run;
                    final /* synthetic */ StoryRectComponentView this$0;
                    {
                        this.$this_run = $receiver;
                        this.this$0 = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        Object object;
                        Object object2;
                        String text;
                        block14: {
                            String string;
                            text = null;
                            text = this.$this_run.getOuterText().getRU();
                            object2 = this.$this_run.getOuterText().getLocale();
                            if (object2 == null) break block14;
                            object = object2;
                            StoryComponent storyComponent = this.$this_run;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = object;
                            boolean bl3 = false;
                            switch (it) {
                                case "ru": {
                                    string = storyComponent.getOuterText().getRU();
                                    break;
                                }
                                case "kk": {
                                    string = storyComponent.getOuterText().getKZ();
                                    break;
                                }
                                case "en": {
                                    string = storyComponent.getOuterText().getEN();
                                    break;
                                }
                                default: {
                                    string = storyComponent.getOuterText().getRU();
                                }
                            }
                            text = string;
                        }
                        ((TextView)this.this$0.findViewById(R.id.appStoryComponentText)).setText((CharSequence)text);
                        object = StoryRectComponentView.access$getComponentViewModel(this.this$0);
                        Object object3 = object2 = object instanceof StoryComponentViewModel ? (StoryComponentViewModel)object : null;
                        if (object2 != null) {
                            ((StoryComponentViewModel)object2).onTextResourceReady();
                        }
                    }
                }, (Function0)new Function0<Unit>(this, (StoryComponent)$this$prepare_u24lambda_u2d1){
                    final /* synthetic */ StoryRectComponentView this$0;
                    final /* synthetic */ StoryComponent $this_run;
                    {
                        this.this$0 = $receiver;
                        this.$this_run = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        StoryComponentViewModel storyComponentViewModel;
                        ((TextView)this.this$0.findViewById(R.id.appStoryComponentText)).setText((CharSequence)this.$this_run.getOuterText().getRU());
                        APComponentViewModel aPComponentViewModel = StoryRectComponentView.access$getComponentViewModel(this.this$0);
                        StoryComponentViewModel storyComponentViewModel2 = storyComponentViewModel = aPComponentViewModel instanceof StoryComponentViewModel ? (StoryComponentViewModel)aPComponentViewModel : null;
                        if (storyComponentViewModel != null) {
                            storyComponentViewModel.onError();
                        }
                    }
                }, 2, null);
                object = ((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterImageUrl();
                if (object != null) {
                    Object object2 = object;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = object2;
                    boolean bl6 = false;
                    ImageView imageView = (ImageView)this.findViewById(R.id.apComponentImageView);
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"apComponentImageView");
                    ImageViewExtensionKt.loadImage(imageView, (String)it, defaultDrawable, (int)((StoryComponent)$this$prepare_u24lambda_u2d1).getOuterStyles().getCornerRadius() * APConstantsKt.getBASE_SIZE_MULTIPLIER(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ StoryRectComponentView this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            StoryComponentViewModel storyComponentViewModel;
                            APComponentViewModel aPComponentViewModel = StoryRectComponentView.access$getComponentViewModel(this.this$0);
                            StoryComponentViewModel storyComponentViewModel2 = storyComponentViewModel = aPComponentViewModel instanceof StoryComponentViewModel ? (StoryComponentViewModel)aPComponentViewModel : null;
                            if (storyComponentViewModel != null) {
                                storyComponentViewModel.onImageResourceReady();
                            }
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ StoryRectComponentView this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            StoryComponentViewModel storyComponentViewModel;
                            APComponentViewModel aPComponentViewModel = StoryRectComponentView.access$getComponentViewModel(this.this$0);
                            StoryComponentViewModel storyComponentViewModel2 = storyComponentViewModel = aPComponentViewModel instanceof StoryComponentViewModel ? (StoryComponentViewModel)aPComponentViewModel : null;
                            if (storyComponentViewModel != null) {
                                storyComponentViewModel.onImageLoadFailed();
                            }
                        }
                    }), (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
                        final /* synthetic */ StoryRectComponentView this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(float it) {
                            StoryComponentViewModel storyComponentViewModel;
                            APComponentViewModel aPComponentViewModel = StoryRectComponentView.access$getComponentViewModel(this.this$0);
                            StoryComponentViewModel storyComponentViewModel2 = storyComponentViewModel = aPComponentViewModel instanceof StoryComponentViewModel ? (StoryComponentViewModel)aPComponentViewModel : null;
                            if (storyComponentViewModel != null) {
                                storyComponentViewModel.onImageLoadProgressUpdate(it);
                            }
                        }
                    }));
                }
                this.updateImageBorder();
            }
        }
    }

    @Override
    public void resume() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void reset() {
        this.updateImageBorder();
    }

    private final void updateImageBorder() {
        StoryComponent storyComponent;
        APComponent aPComponent = this.getComponent();
        StoryComponent storyComponent2 = storyComponent = aPComponent instanceof StoryComponent ? (StoryComponent)aPComponent : null;
        if (storyComponent != null) {
            Object object;
            aPComponent = storyComponent;
            boolean bl = false;
            boolean bl2 = false;
            APComponent $this$updateImageBorder_u24lambda_u2d5 = aPComponent;
            boolean bl3 = false;
            Object object2 = this.getComponent();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.StoryComponent");
            }
            if (((StoryComponent)object2).isBookmark() || !Intrinsics.areEqual((Object)((object2 = (object = this.getComponentViewModel()) instanceof StoryComponentViewModel ? (StoryComponentViewModel)object : null) == null ? null : Boolean.valueOf(((StoryComponentViewModel)object2).showBorder())), (Object)false)) {
                object = this.getComponent();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.StoryComponent");
                }
                String colorForBorder = ((StoryComponent)object).isBookmark() ? APConstantsKt.getBRAND_COLOR() : ((StoryComponent)$this$updateImageBorder_u24lambda_u2d5).getOuterBorderColor();
                ConstraintSet constraintSet = new ConstraintSet();
                constraintSet.clone((ConstraintLayout)this.findViewById(R.id.apComponentLayout));
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 6, 2);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 7, 2);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 3, 2);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 4, 2);
                constraintSet.applyTo((ConstraintLayout)this.findViewById(R.id.apComponentLayout));
                GradientDrawable gradientDrawable = new GradientDrawable();
                boolean bl4 = false;
                boolean bl5 = false;
                GradientDrawable $this$updateImageBorder_u24lambda_u2d5_u24lambda_u2d4 = gradientDrawable;
                boolean bl6 = false;
                $this$updateImageBorder_u24lambda_u2d5_u24lambda_u2d4.setShape(0);
                double d = ((StoryComponent)$this$updateImageBorder_u24lambda_u2d5).getOuterStyles().getCornerRadius();
                boolean bl7 = false;
                boolean bl8 = false;
                double radius = d;
                boolean bl9 = false;
                $this$updateImageBorder_u24lambda_u2d5_u24lambda_u2d4.setCornerRadius((float)radius / (float)2);
                Integer n = ColorUtilsKt.getColorFromHex(colorForBorder);
                if (n != null) {
                    Integer n2 = n;
                    bl8 = false;
                    boolean bl10 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl11 = false;
                    $this$updateImageBorder_u24lambda_u2d5_u24lambda_u2d4.setStroke(2 * APConstantsKt.getBASE_SIZE_MULTIPLIER(), it);
                }
                GradientDrawable borderDrawable = gradientDrawable;
                this.findViewById(R.id.apComponentBorderView).setBackground((Drawable)borderDrawable);
            } else {
                ConstraintSet constraintSet = new ConstraintSet();
                constraintSet.clone((ConstraintLayout)this.findViewById(R.id.apComponentLayout));
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 6, 0);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 7, 0);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 3, 0);
                constraintSet.setMargin(((ImageView)this.findViewById(R.id.apComponentImageView)).getId(), 4, 0);
                constraintSet.applyTo((ConstraintLayout)this.findViewById(R.id.apComponentLayout));
                this.findViewById(R.id.apComponentBorderView).setBackground(null);
            }
        }
    }

    @Override
    public void _$_clearFindViewByIdCache() {
    }

    public static final /* synthetic */ APComponentViewModel access$getComponentViewModel(StoryRectComponentView $this) {
        return $this.getComponentViewModel();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[APOuterStyles.OuterSize.values().length];
            nArray[APOuterStyles.OuterSize.S.ordinal()] = 1;
            nArray[APOuterStyles.OuterSize.M.ordinal()] = 2;
            nArray[APOuterStyles.OuterSize.L.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

