/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.stories.progress;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.R;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animation", "Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar$StoppableScaleAnimation;", "callback", "Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar$Callback;", "duration", "", "clearProgressAnimation", "", "getElapsedTime", "pauseProgress", "resetAnimationProgress", "resumeProgress", "setCallback", "setDuration", "setMax", "setMaxWithoutCallback", "setMin", "setMinWithoutCallback", "startProgress", "Callback", "Companion", "StoppableScaleAnimation", "sdk_release"})
public final class APStoppableProgressBar
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StoppableScaleAnimation animation;
    private long duration;
    @Nullable
    private Callback callback;
    private static final long DEFAULT_PROGRESS_DURATION = 2000L;

    public APStoppableProgressBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public APStoppableProgressBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public APStoppableProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.duration = 2000L;
        View.inflate((Context)context, (int)R.layout.ap_stoppable_progress_bar, (ViewGroup)((ViewGroup)this));
    }

    public final void setDuration(long duration) {
        this.duration = duration;
    }

    public final void setCallback(@NotNull Callback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.callback = callback2;
    }

    public final long getElapsedTime() {
        StoppableScaleAnimation stoppableScaleAnimation = this.animation;
        return stoppableScaleAnimation == null ? (this.findViewById(R.id.apFrontProgressView).getVisibility() == 0 ? this.duration : 0L) : stoppableScaleAnimation.getElapsedTime();
    }

    public final void setMax() {
        Object object = this.animation;
        long elapsedTime = object == null ? 0L : object.getElapsedTime();
        this.setMaxWithoutCallback();
        object = this.callback;
        if (object != null) {
            object.onFinishProgress(elapsedTime);
        }
    }

    public final void setMin() {
        Object object = this.animation;
        long elapsedTime = object == null ? 0L : object.getElapsedTime();
        this.setMinWithoutCallback();
        object = this.callback;
        if (object != null) {
            object.onFinishProgress(elapsedTime);
        }
    }

    public final void setMinWithoutCallback() {
        this.clearProgressAnimation();
        this.findViewById(R.id.apFrontProgressView).setVisibility(4);
    }

    public final void setMaxWithoutCallback() {
        this.clearProgressAnimation();
        this.findViewById(R.id.apFrontProgressView).setVisibility(0);
    }

    public final void startProgress() {
        this.setMinWithoutCallback();
        StoppableScaleAnimation stoppableScaleAnimation = this.animation = new StoppableScaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 0, 0.0f, 1, 0.0f);
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.setDuration(this.duration);
        }
        stoppableScaleAnimation = this.animation;
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        }
        stoppableScaleAnimation = this.animation;
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.setAnimationListener(new Animation.AnimationListener(this){
                final /* synthetic */ APStoppableProgressBar this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAnimationStart(@NotNull Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.this$0.findViewById(R.id.apFrontProgressView).setVisibility(0);
                    Callback callback2 = APStoppableProgressBar.access$getCallback$p(this.this$0);
                    if (callback2 != null) {
                        callback2.onStartProgress();
                    }
                }

                public void onAnimationRepeat(@NotNull Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                }

                public void onAnimationEnd(@NotNull Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    Object object = animation instanceof StoppableScaleAnimation ? (StoppableScaleAnimation)animation : null;
                    long elapsedTime = object == null ? 0L : ((StoppableScaleAnimation)((Object)object)).getElapsedTime();
                    object = APStoppableProgressBar.access$getCallback$p(this.this$0);
                    if (object != null) {
                        object.onFinishProgress(elapsedTime);
                    }
                }
            });
        }
        stoppableScaleAnimation = this.animation;
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.setFillAfter(true);
        }
        stoppableScaleAnimation = this.findViewById(R.id.apFrontProgressView);
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.startAnimation((Animation)this.animation);
        }
    }

    public final void pauseProgress() {
        StoppableScaleAnimation stoppableScaleAnimation = this.animation;
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.pause();
        }
    }

    public final void resumeProgress() {
        StoppableScaleAnimation stoppableScaleAnimation = this.animation;
        if (stoppableScaleAnimation != null) {
            stoppableScaleAnimation.resume();
        }
    }

    public final void resetAnimationProgress() {
        this.startProgress();
    }

    private final void clearProgressAnimation() {
        Object object = this.findViewById(R.id.apFrontProgressView);
        if (object != null) {
            object.clearAnimation();
        }
        object = this.animation;
        if (object != null) {
            object.setAnimationListener(null);
        }
        object = this.animation;
        if (object != null) {
            object.cancel();
        }
        this.animation = null;
    }

    public void _$_clearFindViewByIdCache() {
    }

    public static final /* synthetic */ Callback access$getCallback$p(APStoppableProgressBar $this) {
        return $this.callback;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar$Companion;", "", "()V", "DEFAULT_PROGRESS_DURATION", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar$Callback;", "", "onFinishProgress", "", "elapsedTime", "", "onStartProgress", "sdk_release"})
    public static interface Callback {
        public void onStartProgress();

        public void onFinishProgress(long var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u000eJ \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar$StoppableScaleAnimation;", "Landroid/view/animation/ScaleAnimation;", "fromX", "", "toX", "fromY", "toY", "pivotXType", "", "pivotXValue", "pivotYType", "pivotYValue", "(FFFFIFIF)V", "mElapsedAtPause", "", "mElapsedTime", "mPaused", "", "getElapsedTime", "getTransformation", "currentTime", "outTransformation", "Landroid/view/animation/Transformation;", "scale", "pause", "", "resume", "sdk_release"})
    private static final class StoppableScaleAnimation
    extends ScaleAnimation {
        private long mElapsedTime;
        private long mElapsedAtPause;
        private boolean mPaused;

        public StoppableScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
            super(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
        }

        public boolean getTransformation(long currentTime, @NotNull Transformation outTransformation, float scale) {
            Intrinsics.checkNotNullParameter((Object)outTransformation, (String)"outTransformation");
            this.mElapsedTime = currentTime - this.getStartTime();
            if (this.mPaused && this.getStartTime() != -1L && this.mElapsedAtPause == 0L) {
                this.mElapsedAtPause = this.mElapsedTime;
            }
            if (this.mPaused && this.getStartTime() != -1L) {
                this.setStartTime(currentTime - this.mElapsedAtPause);
            }
            return super.getTransformation(currentTime, outTransformation, scale);
        }

        public final void pause() {
            if (this.mPaused) {
                return;
            }
            this.mElapsedAtPause = 0L;
            this.mPaused = true;
        }

        public final void resume() {
            this.mPaused = false;
        }

        public final long getElapsedTime() {
            return this.mElapsedTime;
        }
    }
}

