/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.stories.progress;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.R;
import plus.adaptive.sdk.ui.stories.progress.APStoppableProgressBar;
import plus.adaptive.sdk.ui.stories.progress.APStoryProgressView;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0007*\u0001\u0019\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0017J\u0015\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\t\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\rJ\b\u0010$\u001a\u00020\u0017H\u0002J\u0006\u0010%\u001a\u00020\u0017J\b\u0010&\u001a\u00020\u0017H\u0002J\u0006\u0010'\u001a\u00020\u0017J\u0006\u0010(\u001a\u00020\u0017J\u0006\u0010)\u001a\u00020\u0017J\u0014\u0010*\u001a\u00020\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0,J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0011J\u0006\u0010/\u001a\u00020\u0017J\u0006\u00100\u001a\u00020\u0017J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\tR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoryProgressView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "current", "isComplete", "", "isReverseStart", "isSkipStart", "lifecycleListener", "Lplus/adaptive/sdk/ui/stories/progress/APStoryProgressView$LifecycleListener;", "progressBars", "", "Lplus/adaptive/sdk/ui/stories/progress/APStoppableProgressBar;", "storiesCount", "bindViews", "", "buildStoppableProgressBarCallback", "plus/adaptive/sdk/ui/stories/progress/APStoryProgressView$buildStoppableProgressBarCallback$1", "index", "(I)Lplus/adaptive/sdk/ui/stories/progress/APStoryProgressView$buildStoppableProgressBarCallback$1;", "createProgressBar", "createSpace", "Landroid/view/View;", "destroy", "getElapsedTime", "", "(I)Ljava/lang/Long;", "hasStarted", "init", "pause", "reset", "resetCurrentSnap", "resume", "reverse", "setSnapsDurations", "durations", "", "setStoriesListener", "listener", "skip", "startStories", "from", "LifecycleListener", "sdk_release"})
public final class APStoryProgressView
extends LinearLayout {
    @NotNull
    private List<APStoppableProgressBar> progressBars;
    private int storiesCount;
    private int current;
    @Nullable
    private LifecycleListener lifecycleListener;
    private boolean isComplete;
    private boolean isSkipStart;
    private boolean isReverseStart;

    public APStoryProgressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null);
        boolean bl = false;
        this.progressBars = new ArrayList();
        this.current = -1;
    }

    public APStoryProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public APStoryProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        boolean bl = false;
        this.progressBars = new ArrayList();
        this.current = -1;
        this.init();
    }

    private final void init() {
        this.setOrientation(0);
        this.bindViews();
    }

    private final void bindViews() {
        this.reset();
        this.removeAllViews();
        this.progressBars.clear();
        int n = 0;
        int n2 = this.storiesCount;
        if (n < n2) {
            do {
                int i2 = n++;
                APStoppableProgressBar p = this.createProgressBar();
                this.progressBars.add(p);
                this.addView((View)p);
                if (i2 + 1 >= this.storiesCount) continue;
                this.addView(this.createSpace());
            } while (n < n2);
        }
    }

    private final APStoppableProgressBar createProgressBar() {
        Object object = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
        object = new APStoppableProgressBar((Context)object);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$createProgressBar_u24lambda_u2d0 = object;
        boolean bl3 = false;
        int height = (int)$this$createProgressBar_u24lambda_u2d0.getResources().getDimension(R.dimen.ap_stories_progress_bar_height);
        $this$createProgressBar_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, height, 1.0f));
        return object;
    }

    private final View createSpace() {
        View view = new View(this.getContext());
        boolean bl = false;
        boolean bl2 = false;
        View $this$createSpace_u24lambda_u2d1 = view;
        boolean bl3 = false;
        int height = (int)$this$createSpace_u24lambda_u2d1.getResources().getDimension(R.dimen.ap_stories_progress_bar_height);
        int width = (int)$this$createSpace_u24lambda_u2d1.getResources().getDimension(R.dimen.ap_stories_progress_bar_space_width);
        $this$createSpace_u24lambda_u2d1.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
        return view;
    }

    public final void setStoriesListener(@NotNull LifecycleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.lifecycleListener = listener;
    }

    public final void skip() {
        if (this.isSkipStart || this.isReverseStart) {
            return;
        }
        if (this.isComplete) {
            return;
        }
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)this.current));
        if (aPStoppableProgressBar != null) {
            APStoppableProgressBar aPStoppableProgressBar2 = aPStoppableProgressBar;
            boolean bl = false;
            boolean bl2 = false;
            APStoppableProgressBar it = aPStoppableProgressBar2;
            boolean bl3 = false;
            this.isSkipStart = true;
            it.setMax();
        }
    }

    public final void reverse() {
        if (this.isSkipStart || this.isReverseStart) {
            return;
        }
        if (this.isComplete) {
            return;
        }
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)this.current));
        if (aPStoppableProgressBar != null) {
            APStoppableProgressBar aPStoppableProgressBar2 = aPStoppableProgressBar;
            boolean bl = false;
            boolean bl2 = false;
            APStoppableProgressBar it = aPStoppableProgressBar2;
            boolean bl3 = false;
            this.isReverseStart = true;
            it.setMin();
        }
    }

    public final void setSnapsDurations(@NotNull List<Long> durations) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(durations, (String)"durations");
        if (durations.size() != this.storiesCount) {
            this.storiesCount = durations.size();
            this.bindViews();
        }
        if ((n2 = 0) < (n = this.progressBars.size())) {
            do {
                Long l;
                int i2;
                this.progressBars.get(i2).setDuration((l = (Long)CollectionsKt.getOrNull(durations, (int)(i2 = n2++))) == null ? 3000L : l);
                this.progressBars.get(i2).setCallback(this.buildStoppableProgressBarCallback(i2));
            } while (n2 < n);
        }
    }

    private final buildStoppableProgressBarCallback.1 buildStoppableProgressBarCallback(int index) {
        return new APStoppableProgressBar.Callback(this, index){
            final /* synthetic */ APStoryProgressView this$0;
            final /* synthetic */ int $index;
            {
                this.this$0 = $receiver;
                this.$index = $index;
            }

            public void onStartProgress() {
                APStoryProgressView.access$setCurrent$p(this.this$0, this.$index);
            }

            public void onFinishProgress(long elapsedTime) {
                if (APStoryProgressView.access$isReverseStart$p(this.this$0)) {
                    Object object;
                    APStoryProgressView.access$setReverseStart$p(this.this$0, false);
                    if (APStoryProgressView.access$getCurrent$p(this.this$0) - 1 >= 0) {
                        object = this.this$0;
                        int n = APStoryProgressView.access$getCurrent$p((APStoryProgressView)((Object)object));
                        APStoryProgressView.access$setCurrent$p((APStoryProgressView)((Object)object), n + -1);
                        APStoppableProgressBar p = (APStoppableProgressBar)((Object)APStoryProgressView.access$getProgressBars$p(this.this$0).get(APStoryProgressView.access$getCurrent$p(this.this$0)));
                        p.setMinWithoutCallback();
                        ((APStoppableProgressBar)((Object)APStoryProgressView.access$getProgressBars$p(this.this$0).get(APStoryProgressView.access$getCurrent$p(this.this$0)))).startProgress();
                    } else {
                        ((APStoppableProgressBar)((Object)APStoryProgressView.access$getProgressBars$p(this.this$0).get(APStoryProgressView.access$getCurrent$p(this.this$0)))).startProgress();
                    }
                    object = APStoryProgressView.access$getLifecycleListener$p(this.this$0);
                    if (object != null) {
                        object.onPrev(elapsedTime);
                    }
                } else {
                    APStoryProgressView.access$setSkipStart$p(this.this$0, false);
                    Object object = this.this$0;
                    int n = APStoryProgressView.access$getCurrent$p((APStoryProgressView)((Object)object));
                    APStoryProgressView.access$setCurrent$p((APStoryProgressView)((Object)object), n + 1);
                    if (APStoryProgressView.access$getCurrent$p(this.this$0) < APStoryProgressView.access$getProgressBars$p(this.this$0).size()) {
                        ((APStoppableProgressBar)((Object)APStoryProgressView.access$getProgressBars$p(this.this$0).get(APStoryProgressView.access$getCurrent$p(this.this$0)))).startProgress();
                        object = APStoryProgressView.access$getLifecycleListener$p(this.this$0);
                        if (object != null) {
                            object.onNext(elapsedTime);
                        }
                    } else {
                        APStoryProgressView.access$setComplete$p(this.this$0, true);
                        object = APStoryProgressView.access$getLifecycleListener$p(this.this$0);
                        if (object != null) {
                            object.onComplete(elapsedTime);
                        }
                    }
                }
            }
        };
    }

    private final void reset() {
        this.destroy();
        this.current = -1;
        this.isComplete = false;
        this.isSkipStart = false;
        this.isReverseStart = false;
    }

    public final void resetCurrentSnap() {
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)this.current));
        if (aPStoppableProgressBar != null) {
            aPStoppableProgressBar.resetAnimationProgress();
        }
    }

    public final void startStories() {
        this.reset();
        this.current = 0;
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)0));
        if (aPStoppableProgressBar != null) {
            aPStoppableProgressBar.startProgress();
        }
    }

    public final void startStories(int from) {
        this.reset();
        int n = 0;
        if (n < from) {
            do {
                int i2;
                APStoppableProgressBar aPStoppableProgressBar;
                if ((aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)(i2 = n++)))) == null) continue;
                aPStoppableProgressBar.setMaxWithoutCallback();
            } while (n < from);
        }
        this.current = from;
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)from));
        if (aPStoppableProgressBar != null) {
            aPStoppableProgressBar.startProgress();
        }
    }

    public final void destroy() {
        for (APStoppableProgressBar p : this.progressBars) {
            p.setMinWithoutCallback();
        }
    }

    public final void pause() {
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)this.current));
        if (aPStoppableProgressBar != null) {
            aPStoppableProgressBar.pauseProgress();
        }
    }

    public final void resume() {
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)this.current));
        if (aPStoppableProgressBar != null) {
            aPStoppableProgressBar.resumeProgress();
        }
    }

    public final boolean hasStarted() {
        return !this.isComplete && this.current >= 0;
    }

    @Nullable
    public final Long getElapsedTime(int index) {
        APStoppableProgressBar aPStoppableProgressBar = (APStoppableProgressBar)((Object)CollectionsKt.getOrNull(this.progressBars, (int)index));
        return aPStoppableProgressBar == null ? null : Long.valueOf(aPStoppableProgressBar.getElapsedTime());
    }

    public void _$_clearFindViewByIdCache() {
    }

    public static final /* synthetic */ void access$setCurrent$p(APStoryProgressView $this, int n) {
        $this.current = n;
    }

    public static final /* synthetic */ boolean access$isReverseStart$p(APStoryProgressView $this) {
        return $this.isReverseStart;
    }

    public static final /* synthetic */ void access$setReverseStart$p(APStoryProgressView $this, boolean bl) {
        $this.isReverseStart = bl;
    }

    public static final /* synthetic */ int access$getCurrent$p(APStoryProgressView $this) {
        return $this.current;
    }

    public static final /* synthetic */ List access$getProgressBars$p(APStoryProgressView $this) {
        return $this.progressBars;
    }

    public static final /* synthetic */ LifecycleListener access$getLifecycleListener$p(APStoryProgressView $this) {
        return $this.lifecycleListener;
    }

    public static final /* synthetic */ void access$setSkipStart$p(APStoryProgressView $this, boolean bl) {
        $this.isSkipStart = bl;
    }

    public static final /* synthetic */ void access$setComplete$p(APStoryProgressView $this, boolean bl) {
        $this.isComplete = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lplus/adaptive/sdk/ui/stories/progress/APStoryProgressView$LifecycleListener;", "", "onComplete", "", "elapsedTime", "", "onNext", "onPrev", "sdk_release"})
    public static interface LifecycleListener {
        public void onNext(long var1);

        public void onPrev(long var1);

        public void onComplete(long var1);
    }
}

