/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.stories.vm;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.core.analytics.APAnalytics;
import plus.adaptive.sdk.core.managers.APSharedPreferences;
import plus.adaptive.sdk.core.providers.RepositoryProviderKt;
import plus.adaptive.sdk.data.models.APAnalyticsEvent;
import plus.adaptive.sdk.data.models.APLayer;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.APUser;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.models.components.APBackgroundComponent;
import plus.adaptive.sdk.data.models.components.APComponent;
import plus.adaptive.sdk.data.models.components.APGIFComponent;
import plus.adaptive.sdk.data.models.components.APImageComponent;
import plus.adaptive.sdk.data.models.components.APPollComponent;
import plus.adaptive.sdk.data.models.components.APTextComponent;
import plus.adaptive.sdk.data.models.story.FeedbackComponent;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.ui.components.background.APBackgroundComponentViewModel;
import plus.adaptive.sdk.ui.components.core.APComponentContainerViewModel;
import plus.adaptive.sdk.ui.components.core.APComponentLifecycleListener;
import plus.adaptive.sdk.ui.components.core.vm.APBaseComponentViewModel;
import plus.adaptive.sdk.ui.components.core.vm.APComponentViewModel;
import plus.adaptive.sdk.ui.components.core.vm.APComponentViewModelProvider;
import plus.adaptive.sdk.ui.components.gif.APGIFComponentViewModel;
import plus.adaptive.sdk.ui.components.image.APImageComponentViewModel;
import plus.adaptive.sdk.ui.components.poll.APPollComponentViewModel;
import plus.adaptive.sdk.ui.components.text.APTextComponentViewModel;
import plus.adaptive.sdk.ui.stories.actionarea.APActionAreaListener;
import plus.adaptive.sdk.ui.stories.data.APSnapEvent;
import plus.adaptive.sdk.ui.stories.data.APSnapEventInfo;
import plus.adaptive.sdk.ui.stories.vm.APStoryViewModelDelegateProtocol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u001d\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\u0004\u0018\u00010\u00192\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u0004\u0018\u00010'J\u0015\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020'\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u0010H\u0016J\u001d\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020'J\u0010\u00106\u001a\u0002022\u0006\u0010*\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u0002022\u0006\u0010*\u001a\u00020\u001bH\u0002J\u0018\u00108\u001a\u0002022\u0006\u0010*\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0013H\u0002J\u0018\u0010:\u001a\u0002022\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u0010H\u0002J\u000e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u000202J\u000e\u0010@\u001a\u0002022\u0006\u0010-\u001a\u00020'J\u0006\u0010A\u001a\u000202J\u0016\u0010B\u001a\u0002022\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u0018H\u0016J\u000e\u0010E\u001a\u0002022\u0006\u0010-\u001a\u00020'J\b\u0010F\u001a\u00020\u0010H\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lplus/adaptive/sdk/ui/stories/vm/APSnapViewModel;", "Landroidx/lifecycle/ViewModel;", "Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModelProvider;", "Lplus/adaptive/sdk/ui/stories/actionarea/APActionAreaListener;", "Lplus/adaptive/sdk/ui/components/core/APComponentContainerViewModel;", "snap", "Lplus/adaptive/sdk/data/models/APSnap;", "storyViewModelDelegate", "Lplus/adaptive/sdk/ui/stories/vm/APStoryViewModelDelegateProtocol;", "preferences", "Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Lplus/adaptive/sdk/data/models/APSnap;Lplus/adaptive/sdk/ui/stories/vm/APStoryViewModelDelegateProtocol;Lplus/adaptive/sdk/core/managers/APSharedPreferences;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "_isErrorStateLiveData", "Landroidx/lifecycle/MutableLiveData;", "", "_isSnapReadyLiveData", "_snapLoadingProgressLiveData", "", "componentPreparationProgressList", "", "componentReadinessList", "componentViewModelList", "", "Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModel;", "hasPreparationProgressComponentCount", "", "Ljava/lang/Integer;", "isErrorStateLiveData", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "isSnapReadyLiveData", "sharedHandler", "Ljava/util/logging/Handler;", "snapLoadingProgressLiveData", "getSnapLoadingProgressLiveData", "changeSnapSaved", "publicationId", "", "(Lplus/adaptive/sdk/data/models/APSnap;Ljava/lang/String;)Ljava/lang/Boolean;", "getAPComponentViewModel", "index", "getLang", "getSnapLike", "id", "(Ljava/lang/String;)Ljava/lang/Boolean;", "isActive", "isSnapSaved", "logAnalyticFeedbackEvent", "", "feedback", "Lplus/adaptive/sdk/data/models/story/FeedbackComponent;", "eventName", "onComponentComplete", "onComponentError", "onComponentPreparationProgressUpdate", "progress", "onComponentReady", "isReady", "onSnapEvent", "event", "Lplus/adaptive/sdk/ui/stories/data/APSnapEvent;", "prepare", "removeSnapLike", "runActionAreaActions", "runActions", "actions", "Lplus/adaptive/sdk/data/models/actions/APAction;", "saveSnapLike", "showBorder", "sdk_release"})
public final class APSnapViewModel
extends ViewModel
implements APComponentViewModelProvider,
APActionAreaListener,
APComponentContainerViewModel {
    @NotNull
    private final APSnap snap;
    @Nullable
    private final APStoryViewModelDelegateProtocol storyViewModelDelegate;
    @Nullable
    private final APSharedPreferences preferences;
    @Nullable
    private final APUserRepository userRepository;
    @NotNull
    private final MutableLiveData<Float> _snapLoadingProgressLiveData;
    @NotNull
    private final MutableLiveData<Boolean> _isSnapReadyLiveData;
    @NotNull
    private final MutableLiveData<Boolean> _isErrorStateLiveData;
    @Nullable
    private Integer hasPreparationProgressComponentCount;
    @NotNull
    private final List<Float> componentPreparationProgressList;
    @NotNull
    private final List<Boolean> componentReadinessList;
    @Nullable
    private final Handler sharedHandler;
    @NotNull
    private final List<APComponentViewModel> componentViewModelList;

    /*
     * WARNING - void declaration
     */
    public APSnapViewModel(@NotNull APSnap snap, @Nullable APStoryViewModelDelegateProtocol storyViewModelDelegate, @Nullable APSharedPreferences preferences, @Nullable APUserRepository userRepository) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$_isErrorStateLiveData_u24lambda_u2d2;
        MutableLiveData $this$_isSnapReadyLiveData_u24lambda_u2d1;
        MutableLiveData $this$_snapLoadingProgressLiveData_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)snap, (String)"snap");
        this.snap = snap;
        this.storyViewModelDelegate = storyViewModelDelegate;
        this.preferences = preferences;
        this.userRepository = userRepository;
        Object object2 = new MutableLiveData();
        boolean bl = false;
        boolean bl2 = false;
        MutableLiveData mutableLiveData = object2;
        APSnapViewModel aPSnapViewModel = this;
        boolean bl3 = false;
        $this$_snapLoadingProgressLiveData_u24lambda_u2d0.setValue((Object)Float.valueOf(0.0f));
        Object object3 = Unit.INSTANCE;
        aPSnapViewModel._snapLoadingProgressLiveData = object2;
        object2 = new MutableLiveData();
        bl = false;
        bl2 = false;
        $this$_snapLoadingProgressLiveData_u24lambda_u2d0 = object2;
        aPSnapViewModel = this;
        boolean bl4 = false;
        $this$_isSnapReadyLiveData_u24lambda_u2d1.setValue((Object)false);
        object3 = Unit.INSTANCE;
        aPSnapViewModel._isSnapReadyLiveData = object2;
        object2 = new MutableLiveData();
        bl = false;
        bl2 = false;
        $this$_isSnapReadyLiveData_u24lambda_u2d1 = object2;
        aPSnapViewModel = this;
        boolean bl5 = false;
        $this$_isErrorStateLiveData_u24lambda_u2d2.setValue((Object)false);
        object3 = Unit.INSTANCE;
        aPSnapViewModel._isErrorStateLiveData = object2;
        object2 = this.snap.getLayers();
        aPSnapViewModel = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            APLayer aPLayer = (APLayer)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl6 = false;
            object = Float.valueOf(0.0f);
            object3.add(object);
        }
        object3 = (List)destination$iv$iv;
        aPSnapViewModel.componentPreparationProgressList = CollectionsKt.toMutableList((Collection)((Collection)object3));
        $this$map$iv = this.snap.getLayers();
        aPSnapViewModel = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            APLayer it = (APLayer)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl7 = false;
            object = false;
            object3.add(object);
        }
        object3 = (List)destination$iv$iv;
        aPSnapViewModel.componentReadinessList = CollectionsKt.toMutableList((Collection)((Collection)object3));
        $this$map$iv = this.snap.getLayers();
        aPSnapViewModel = this;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void apLayer;
            void index;
            int n = index$iv$iv++;
            boolean bl8 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            APLayer aPLayer = (APLayer)item$iv$iv;
            int n2 = n;
            object3 = destination$iv$iv;
            boolean bl9 = false;
            APComponentLifecycleListener componentLifecycleListener2 = new APComponentLifecycleListener(this, (int)index){
                final /* synthetic */ APSnapViewModel this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                public void onReady(boolean isReady) {
                    APSnapViewModel.access$onComponentReady(this.this$0, this.$index, isReady);
                }

                public void onComplete() {
                    APSnapViewModel.access$onComponentComplete(this.this$0, this.$index);
                }

                public void onError() {
                    APSnapViewModel.access$onComponentError(this.this$0, this.$index);
                }

                public void onPreparationProgressUpdate(float progress) {
                    APSnapViewModel.access$onComponentPreparationProgressUpdate(this.this$0, this.$index, progress);
                }
            };
            APComponent aPComponent = apLayer.getComponent();
            object = aPComponent instanceof APBackgroundComponent ? (APBaseComponentViewModel)new APBackgroundComponentViewModel(this, componentLifecycleListener2) : (aPComponent instanceof APImageComponent ? (APBaseComponentViewModel)new APImageComponentViewModel(this, componentLifecycleListener2) : (aPComponent instanceof APTextComponent ? (APBaseComponentViewModel)new APTextComponentViewModel(this, componentLifecycleListener2) : (aPComponent instanceof APGIFComponent ? (APBaseComponentViewModel)new APGIFComponentViewModel(this, componentLifecycleListener2) : (aPComponent instanceof APPollComponent ? (APBaseComponentViewModel)new APPollComponentViewModel(this, componentLifecycleListener2, (APPollComponent)apLayer.getComponent(), RepositoryProviderKt.provideAPPollRepository(), this.userRepository, this.preferences) : null))));
            object3.add(object);
        }
        aPSnapViewModel.componentViewModelList = object3 = (List)destination$iv$iv;
    }

    @NotNull
    public final LiveData<Float> getSnapLoadingProgressLiveData() {
        return (LiveData)this._snapLoadingProgressLiveData;
    }

    @NotNull
    public final LiveData<Boolean> isSnapReadyLiveData() {
        return (LiveData)this._isSnapReadyLiveData;
    }

    @NotNull
    public final LiveData<Boolean> isErrorStateLiveData() {
        return (LiveData)this._isErrorStateLiveData;
    }

    @Override
    @Nullable
    public APComponentViewModel getAPComponentViewModel(int index) {
        return this.componentViewModelList.get(index);
    }

    private final void onComponentReady(int index, boolean isReady) {
        if (index >= 0 && index < this.componentReadinessList.size()) {
            boolean bl;
            block6: {
                this.componentReadinessList.set(index, isReady);
                if (isReady) {
                    this.onComponentPreparationProgressUpdate(index, 1.0f);
                }
                Iterable $this$all$iv = this.componentReadinessList;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl2 = false;
                        if (it) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            boolean isSnapReady = bl;
            this._isSnapReadyLiveData.setValue((Object)isSnapReady);
            APStoryViewModelDelegateProtocol aPStoryViewModelDelegateProtocol = this.storyViewModelDelegate;
            if (aPStoryViewModelDelegateProtocol != null) {
                aPStoryViewModelDelegateProtocol.updateSnapReadiness(this.snap.getId(), isSnapReady);
            }
        }
    }

    private final void onComponentComplete(int index) {
    }

    private final void onComponentError(int index) {
        APComponentViewModel viewModel = this.componentViewModelList.get(index);
        if (viewModel instanceof APImageComponentViewModel || viewModel instanceof APGIFComponentViewModel) {
            this._isErrorStateLiveData.setValue((Object)true);
        } else {
            this.onComponentReady(index, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onComponentPreparationProgressUpdate(int index, float progress) {
        Object object;
        Object object2 = this.componentViewModelList.get(index);
        if (!Intrinsics.areEqual((Object)(object2 == null ? null : Boolean.valueOf(object2.hasPreparationProgressUpdates())), (Object)true)) {
            return;
        }
        if (this.hasPreparationProgressComponentCount == null) {
            int n;
            void $this$count$iv;
            object2 = this.componentViewModelList;
            APSnapViewModel aPSnapViewModel = this;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    APComponentViewModel it22 = (APComponentViewModel)element$iv;
                    boolean bl4 = false;
                    object = it22;
                    if (!Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(object.hasPreparationProgressUpdates())), (Object)true)) continue;
                    int it22 = ++count$iv;
                    bl4 = false;
                    if (it22 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            aPSnapViewModel.hasPreparationProgressComponentCount = n2;
        }
        if ((object2 = this.hasPreparationProgressComponentCount) != null) {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            int count = ((Number)object3).intValue();
            boolean bl3 = false;
            Float bl4 = (Float)this._snapLoadingProgressLiveData.getValue();
            object = bl4 == null ? Float.valueOf(0.0f) : bl4;
            float oldSnapProgress = ((Number)object).floatValue();
            float oldComponentProgress = ((Number)this.componentPreparationProgressList.get(index)).floatValue();
            float newSnapProgress = oldSnapProgress + (progress - oldComponentProgress) / (float)count;
            this.componentPreparationProgressList.set(index, Float.valueOf(progress));
            this._snapLoadingProgressLiveData.setValue((Object)Float.valueOf(newSnapProgress));
        }
    }

    public final void logAnalyticFeedbackEvent(@NotNull FeedbackComponent feedback, @NotNull String eventName) {
        Pair[] pairArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Object object2 = this.storyViewModelDelegate;
        String string = object2 == null ? "" : ((object = object2.getCampaignId()) == null ? "" : object);
        object = this.storyViewModelDelegate;
        object2 = object == null ? "" : ((pairArray = object.getAPViewId()) == null ? "" : pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"snapId", (Object)this.snap.getId()), TuplesKt.to((Object)"feedbackId", (Object)feedback.getId())};
        object = MapsKt.mapOf((Pair[])pairArray);
        APAnalyticsEvent event = new APAnalyticsEvent(eventName, (String)object2, string, (Map)object, null, null, 48, null);
        APAnalytics.Companion.logEvent(event);
    }

    @Override
    public void runActions(@NotNull List<? extends APAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Object object = actions;
        boolean bl = false;
        if (!object.isEmpty()) {
            String string;
            Object object2;
            Object object3 = this.storyViewModelDelegate;
            object = object3 == null ? "" : ((object2 = object3.getCampaignId()) == null ? "" : object2);
            object2 = this.storyViewModelDelegate;
            object3 = object2 == null ? "" : ((string = object2.getAPViewId()) == null ? "" : string);
            object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"snapId", (Object)this.snap.getId()));
            APAnalytics.Companion.logEvent(new APAnalyticsEvent("action-snap", (String)object3, (String)object, (Map)object2, null, null, 48, null));
        }
        if ((object = this.storyViewModelDelegate) != null) {
            object.runActions(actions);
        }
    }

    public final void runActionAreaActions() {
        List<APAction> list;
        APSnap.ActionArea actionArea = this.snap.getActionArea();
        if (actionArea instanceof APSnap.ButtonActionArea && (list = ((APSnap.ButtonActionArea)actionArea).getActions()) != null) {
            List<APAction> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<APAction> it = list2;
            boolean bl3 = false;
            this.runActions(it);
        }
    }

    public final void onSnapEvent(@NotNull APSnapEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        APStoryViewModelDelegateProtocol aPStoryViewModelDelegateProtocol = this.storyViewModelDelegate;
        if (aPStoryViewModelDelegateProtocol != null) {
            aPStoryViewModelDelegateProtocol.onSnapEvent(new APSnapEventInfo(this.snap.getId(), event));
        }
    }

    public final void prepare() {
        this._isErrorStateLiveData.setValue((Object)false);
        Iterable $this$forEach$iv = this.componentViewModelList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            APComponentViewModel it = (APComponentViewModel)element$iv;
            boolean bl = false;
            APComponentViewModel aPComponentViewModel = it;
            if (aPComponentViewModel == null) continue;
            aPComponentViewModel.prepare();
        }
    }

    @Nullable
    public final String getLang() {
        APUser aPUser;
        Object object = this.userRepository;
        APUser aPUser2 = aPUser = object == null ? null : ((APUserRepository)object).getAPUser();
        return aPUser == null ? null : ((object = aPUser.getDevice()) == null ? null : ((APUser.Device)object).getLocale());
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean showBorder() {
        return true;
    }

    public final void saveSnapLike(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        APSharedPreferences aPSharedPreferences = this.preferences;
        if (aPSharedPreferences != null) {
            aPSharedPreferences.saveBoolean(Intrinsics.stringPlus((String)"snapLiked ", (Object)id2), true);
        }
    }

    public final void removeSnapLike(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        APSharedPreferences aPSharedPreferences = this.preferences;
        if (aPSharedPreferences != null) {
            aPSharedPreferences.remove(Intrinsics.stringPlus((String)"snapLiked ", (Object)id2));
        }
    }

    @Nullable
    public final Boolean getSnapLike(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        APSharedPreferences aPSharedPreferences = this.preferences;
        return aPSharedPreferences == null ? null : Boolean.valueOf(aPSharedPreferences.getBoolean(Intrinsics.stringPlus((String)"snapLiked ", (Object)id2)));
    }

    @Nullable
    public final Boolean isSnapSaved(@NotNull APSnap snap, @NotNull String publicationId) {
        Intrinsics.checkNotNullParameter((Object)snap, (String)"snap");
        Intrinsics.checkNotNullParameter((Object)publicationId, (String)"publicationId");
        APSharedPreferences aPSharedPreferences = this.preferences;
        return aPSharedPreferences == null ? null : Boolean.valueOf(aPSharedPreferences.isSnapSaved(snap, publicationId));
    }

    @Nullable
    public final Boolean changeSnapSaved(@NotNull APSnap snap, @NotNull String publicationId) {
        Intrinsics.checkNotNullParameter((Object)snap, (String)"snap");
        Intrinsics.checkNotNullParameter((Object)publicationId, (String)"publicationId");
        APSharedPreferences aPSharedPreferences = this.preferences;
        return aPSharedPreferences == null ? null : Boolean.valueOf(aPSharedPreferences.changeSnapSaved(snap, publicationId));
    }

    public static final /* synthetic */ void access$onComponentReady(APSnapViewModel $this, int index, boolean isReady) {
        $this.onComponentReady(index, isReady);
    }

    public static final /* synthetic */ void access$onComponentComplete(APSnapViewModel $this, int index) {
        $this.onComponentComplete(index);
    }

    public static final /* synthetic */ void access$onComponentError(APSnapViewModel $this, int index) {
        $this.onComponentError(index);
    }

    public static final /* synthetic */ void access$onComponentPreparationProgressUpdate(APSnapViewModel $this, int index, float progress) {
        $this.onComponentPreparationProgressUpdate(index, progress);
    }
}

