/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.ui.stories.vm;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import plus.adaptive.sdk.core.managers.APSharedPreferences;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.APStory;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.repositories.APUserRepository;
import plus.adaptive.sdk.ui.stories.data.APSnapEventInfo;
import plus.adaptive.sdk.ui.stories.data.APSnapState;
import plus.adaptive.sdk.ui.stories.data.APSnapStateInfo;
import plus.adaptive.sdk.ui.stories.vm.APStoriesDialogViewModelDelegateProtocol;
import plus.adaptive.sdk.ui.stories.vm.APStoryViewModelDelegateProtocol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH\u0016J\u0016\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u000e\u0010,\u001a\u00020&2\u0006\u0010#\u001a\u00020\u0010J\u000e\u0010-\u001a\u00020&2\u0006\u0010#\u001a\u00020\u0010J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u0014H\u0016J\u0016\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0014H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lplus/adaptive/sdk/ui/stories/vm/APStoryViewModel;", "Landroidx/lifecycle/ViewModel;", "Lplus/adaptive/sdk/ui/stories/vm/APStoryViewModelDelegateProtocol;", "story", "Lplus/adaptive/sdk/data/models/APStory;", "storiesDialogViewModelDelegate", "Lplus/adaptive/sdk/ui/stories/vm/APStoriesDialogViewModelDelegateProtocol;", "preferences", "Lplus/adaptive/sdk/core/managers/APSharedPreferences;", "userRepository", "Lplus/adaptive/sdk/data/repositories/APUserRepository;", "(Lplus/adaptive/sdk/data/models/APStory;Lplus/adaptive/sdk/ui/stories/vm/APStoriesDialogViewModelDelegateProtocol;Lplus/adaptive/sdk/core/managers/APSharedPreferences;Lplus/adaptive/sdk/data/repositories/APUserRepository;)V", "_snapEventInfoLiveData", "Landroidx/lifecycle/MutableLiveData;", "Lplus/adaptive/sdk/ui/stories/data/APSnapEventInfo;", "_snapReadinessUpdatedEventLiveData", "", "_snapStatusLiveData", "Lplus/adaptive/sdk/ui/stories/data/APSnapStateInfo;", "_takingScreenShotLiveData", "", "isStoriesPausedLiveData", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "snapEventInfoLiveData", "getSnapEventInfoLiveData", "snapReadinessMap", "", "snapReadinessUpdatedEventLiveData", "getSnapReadinessUpdatedEventLiveData", "takingScreenShotLiveData", "getTakingScreenShotLiveData", "getAPViewId", "getCampaignId", "isSnapReady", "id", "isStoriesPaused", "onSnapEvent", "", "eventInfo", "runActions", "actions", "", "Lplus/adaptive/sdk/data/models/actions/APAction;", "saveWatchedStoryCountById", "saveWatchedStoryId", "setViewsForScreenShot", "isTakingScreenShoot", "updateSnapProgressState", "snapId", "state", "Lplus/adaptive/sdk/ui/stories/data/APSnapState;", "updateSnapReadiness", "isReady", "sdk_release"})
public final class APStoryViewModel
extends ViewModel
implements APStoryViewModelDelegateProtocol {
    @NotNull
    private final APStory story;
    @NotNull
    private final APStoriesDialogViewModelDelegateProtocol storiesDialogViewModelDelegate;
    @NotNull
    private final APSharedPreferences preferences;
    @NotNull
    private final APUserRepository userRepository;
    @NotNull
    private final MutableLiveData<String> _snapReadinessUpdatedEventLiveData;
    @NotNull
    private final MutableLiveData<Boolean> _takingScreenShotLiveData;
    @NotNull
    private final MutableLiveData<APSnapStateInfo> _snapStatusLiveData;
    @NotNull
    private final MutableLiveData<APSnapEventInfo> _snapEventInfoLiveData;
    @NotNull
    private final Map<String, Boolean> snapReadinessMap;

    /*
     * WARNING - void declaration
     */
    public APStoryViewModel(@NotNull APStory story, @NotNull APStoriesDialogViewModelDelegateProtocol storiesDialogViewModelDelegate, @NotNull APSharedPreferences preferences, @NotNull APUserRepository userRepository) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        Intrinsics.checkNotNullParameter((Object)storiesDialogViewModelDelegate, (String)"storiesDialogViewModelDelegate");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.story = story;
        this.storiesDialogViewModelDelegate = storiesDialogViewModelDelegate;
        this.preferences = preferences;
        this.userRepository = userRepository;
        this._snapReadinessUpdatedEventLiveData = new MutableLiveData();
        this._takingScreenShotLiveData = new MutableLiveData();
        this._snapStatusLiveData = new MutableLiveData();
        this._snapEventInfoLiveData = new MutableLiveData();
        boolean bl = false;
        this.snapReadinessMap = new LinkedHashMap();
        this.snapReadinessMap.clear();
        Iterable $this$map$iv = this.story.getSnaps();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            APSnap aPSnap = (APSnap)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)it.getId(), (Object)false);
            collection.add(pair);
        }
        Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        boolean bl3 = false;
        boolean bl4 = false;
        Map it = map;
        boolean bl5 = false;
        this.snapReadinessMap.putAll(it);
    }

    @NotNull
    public final LiveData<String> getSnapReadinessUpdatedEventLiveData() {
        return (LiveData)this._snapReadinessUpdatedEventLiveData;
    }

    @NotNull
    public final LiveData<Boolean> getTakingScreenShotLiveData() {
        return (LiveData)this._takingScreenShotLiveData;
    }

    @NotNull
    public final LiveData<APSnapEventInfo> getSnapEventInfoLiveData() {
        return (LiveData)this._snapEventInfoLiveData;
    }

    @NotNull
    public final LiveData<Boolean> isStoriesPausedLiveData() {
        return this.storiesDialogViewModelDelegate.isAPStoriesPausedLiveData();
    }

    @Override
    public void updateSnapReadiness(@NotNull String id2, boolean isReady) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Map<String, Boolean> map = this.snapReadinessMap;
        boolean bl = false;
        Map<String, Boolean> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(id2)) {
            map = this.snapReadinessMap;
            Boolean bl3 = isReady;
            boolean bl4 = false;
            map.put(id2, bl3);
            this._snapReadinessUpdatedEventLiveData.setValue((Object)id2);
        }
    }

    public final boolean isSnapReady(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Map<String, Boolean> map = this.snapReadinessMap;
        boolean bl = false;
        Boolean bl2 = map.get(id2);
        if (bl2 == null) {
            boolean bl3 = false;
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public void runActions(@NotNull List<? extends APAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.storiesDialogViewModelDelegate.runActions(actions);
    }

    public final boolean isStoriesPaused() {
        return Intrinsics.areEqual((Object)this.isStoriesPausedLiveData().getValue(), (Object)true);
    }

    public final void updateSnapProgressState(@NotNull String snapId, @NotNull APSnapState state) {
        Intrinsics.checkNotNullParameter((Object)snapId, (String)"snapId");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this._snapStatusLiveData.setValue((Object)new APSnapStateInfo(snapId, state));
    }

    @Override
    public void onSnapEvent(@NotNull APSnapEventInfo eventInfo) {
        Intrinsics.checkNotNullParameter((Object)eventInfo, (String)"eventInfo");
        this._snapEventInfoLiveData.setValue((Object)eventInfo);
    }

    @Override
    @NotNull
    public String getAPViewId() {
        return this.storiesDialogViewModelDelegate.getAPViewId();
    }

    @Override
    @NotNull
    public String getCampaignId() {
        return this.story.getCampaignId();
    }

    @Override
    public void setViewsForScreenShot(boolean isTakingScreenShoot) {
        this._takingScreenShotLiveData.setValue((Object)isTakingScreenShoot);
    }

    public final void saveWatchedStoryId(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        String string2 = this.userRepository.getAPUser().getExternalId();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.preferences.saveWatchedStoryId(it, id2);
        }
    }

    public final void saveWatchedStoryCountById(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.preferences.saveWatchedStoryCount(id2);
    }
}

