/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.models.APUser;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\n"}, d2={"getAppVersion", "", "context", "Landroid/content/Context;", "getDeviceId", "getDeviceType", "Lplus/adaptive/sdk/data/models/APUser$Device$Type;", "getMobileCountryCode", "getMobileNetworkCode", "getMobileOperatorName", "sdk_release"})
public final class APUserUtilsKt {
    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public static final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(context.contentResolver, Settings.Secure.ANDROID_ID)");
        return string2;
    }

    @NotNull
    public static final APUser.Device.Type getDeviceType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int uiMode = context.getResources().getConfiguration().uiMode;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        return (uiMode & 0xF) == 4 ? APUser.Device.Type.TV : ((screenLayout & 0xF) >= 3 ? APUser.Device.Type.TABLET : APUser.Device.Type.PHONE);
    }

    @Nullable
    public static final String getAppVersion(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string2 = pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public static final String getMobileOperatorName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        object = telephonyManager;
        return object == null ? null : object.getNetworkOperatorName();
    }

    @Nullable
    public static final String getMobileCountryCode(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        Object object2 = telephonyManager;
        String networkOperator = object2 == null ? null : object2.getNetworkOperator();
        if (networkOperator != null && networkOperator.length() >= 3) {
            object2 = networkOperator;
            int n = 0;
            int n2 = 3;
            boolean bl = false;
            String string3 = ((String)object2).substring(n, n2);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public static final String getMobileNetworkCode(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        Object object2 = telephonyManager;
        String networkOperator = object2 == null ? null : object2.getNetworkOperator();
        if (networkOperator != null && networkOperator.length() >= 3) {
            object2 = networkOperator;
            int n = 3;
            boolean bl = false;
            String string3 = ((String)object2).substring(n);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }
}

