/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.View;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.APConstantsKt;
import plus.adaptive.sdk.data.models.APFont;
import plus.adaptive.sdk.data.models.APLayer;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.APStory;
import plus.adaptive.sdk.data.models.components.APBackgroundComponent;
import plus.adaptive.sdk.data.models.components.APComponent;
import plus.adaptive.sdk.data.models.components.APGIFComponent;
import plus.adaptive.sdk.data.models.components.APImageComponent;
import plus.adaptive.sdk.data.models.components.APPollComponent;
import plus.adaptive.sdk.data.models.components.APTextComponent;
import plus.adaptive.sdk.data.models.components.StoryComponent;
import plus.adaptive.sdk.data.models.story.APOuterStyles;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.Layer;
import plus.adaptive.sdk.data.models.story.Story;
import plus.adaptive.sdk.ui.apview.newVm.CampaignViewModel;
import plus.adaptive.sdk.ui.components.background.APBackgroundComponentView;
import plus.adaptive.sdk.ui.components.core.APBaseComponentView;
import plus.adaptive.sdk.ui.components.core.vm.APComponentViewModel;
import plus.adaptive.sdk.ui.components.core.vm.APComponentViewModelProvider;
import plus.adaptive.sdk.ui.components.gif.APGIFComponentView;
import plus.adaptive.sdk.ui.components.image.APImageComponentView;
import plus.adaptive.sdk.ui.components.poll.APMultipleChoicePollComponentView;
import plus.adaptive.sdk.ui.components.poll.APYesNoPollComponentView;
import plus.adaptive.sdk.ui.components.story.StoryCircleComponentView;
import plus.adaptive.sdk.ui.components.story.StoryRectComponentView;
import plus.adaptive.sdk.ui.components.story.StorySquareComponentView;
import plus.adaptive.sdk.ui.components.text.APTextComponentView;
import plus.adaptive.sdk.ui.splashscreen.vm.APSplashScreenDialogViewModel;
import plus.adaptive.sdk.ui.stories.actionarea.APActionAreaButtonView;
import plus.adaptive.sdk.ui.stories.actionarea.APActionAreaListener;
import plus.adaptive.sdk.ui.stories.vm.APSnapViewModel;
import plus.adaptive.sdk.utils.ActionUtilsKt;
import plus.adaptive.sdk.utils.ApTemplateUtilsKt;
import plus.adaptive.sdk.utils.StorySizeConst;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a$\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a$\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a(\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0000\u001a\"\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\"\u0010&\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020'2\b\u0010#\u001a\u0004\u0018\u00010$H\u0000\u001a(\u0010(\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0000\u001a,\u0010)\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020'2\b\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010*\u001a\u00020+H\u0000\u001a\u001a\u0010,\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010\u00102\b\u0010.\u001a\u0004\u0018\u00010/H\u0000\u001a\u0012\u00100\u001a\u0002012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u00102\u001a\u0004\u0018\u0001032\b\u0010\u000b\u001a\u0004\u0018\u00010$H\u0002\u001a\u0012\u00104\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010/H\u0000\u00a8\u00065"}, d2={"buildActionAreaView", "Landroid/view/View;", "context", "Landroid/content/Context;", "actionArea", "Lplus/adaptive/sdk/data/models/APSnap$ActionArea;", "actionAreaListener", "Lplus/adaptive/sdk/ui/stories/actionarea/APActionAreaListener;", "buildComponentView", "layer", "Lplus/adaptive/sdk/data/models/APLayer;", "viewModel", "Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModel;", "buildComponentViewByLayer", "Lplus/adaptive/sdk/data/models/story/Layer;", "checkImageDublication", "", "layers", "convertToBackgroundComponent", "Lplus/adaptive/sdk/data/models/components/APBackgroundComponent;", "component", "Lplus/adaptive/sdk/data/models/story/Layer$Component;", "convertToGifComponent", "Lplus/adaptive/sdk/data/models/components/APGIFComponent;", "convertToImageComponent", "Lplus/adaptive/sdk/data/models/components/APImageComponent;", "convertToPollComponent", "Lplus/adaptive/sdk/data/models/components/APPollComponent;", "convertToTextComponent", "Lplus/adaptive/sdk/data/models/components/APTextComponent;", "countDpiAndSteKoef", "", "drawAPLayersOnLayout", "layout", "Landroidx/constraintlayout/widget/ConstraintLayout;", "componentViewModelProvider", "Lplus/adaptive/sdk/ui/components/core/vm/APComponentViewModelProvider;", "drawAPSnapActionArea", "drawCircleStoryOnLayout", "Lplus/adaptive/sdk/data/models/components/StoryComponent;", "drawLayersOnLayout", "drawStoryOnLayout", "isSquare", "", "getAPStoriesList", "Lplus/adaptive/sdk/data/models/APStory;", "dataModel", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "getDpi", "", "getLanguageFromViewModel", "", "isStoriesDataModelNullOrEmpty", "sdk_release"})
public final class APViewUtilsKt {
    @Nullable
    public static final View buildComponentView(@NotNull Context context, @NotNull APLayer layer, @Nullable APComponentViewModel viewModel) {
        View view;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        APComponent aPComponent = layer.getComponent();
        if (aPComponent instanceof APBackgroundComponent) {
            view = (View)new APBackgroundComponentView(context, (APBackgroundComponent)layer.getComponent(), viewModel);
        } else if (aPComponent instanceof APImageComponent) {
            view = (View)(ApTemplateUtilsKt.isTooLargeOrNegativePosition(layer.getOptions()) ? new APImageComponentView(context, (APImageComponent)layer.getComponent(), viewModel, layer.getOptions()) : new APImageComponentView(context, (APImageComponent)layer.getComponent(), viewModel, null, 8, null));
        } else if (aPComponent instanceof APTextComponent) {
            view = (View)new APTextComponentView(context, (APTextComponent)layer.getComponent(), viewModel);
        } else if (aPComponent instanceof APGIFComponent) {
            view = (View)new APGIFComponentView(context, (APGIFComponent)layer.getComponent(), viewModel);
        } else if (aPComponent instanceof APPollComponent) {
            APBaseComponentView aPBaseComponentView;
            APPollComponent.Type type = ((APPollComponent)layer.getComponent()).getType();
            int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n) {
                case 1: {
                    aPBaseComponentView = new APYesNoPollComponentView(context, (APPollComponent)layer.getComponent(), viewModel);
                    break;
                }
                case 2: {
                    aPBaseComponentView = new APMultipleChoicePollComponentView(context, (APPollComponent)layer.getComponent(), viewModel);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            view = (View)aPBaseComponentView;
        } else {
            view = null;
        }
        return view;
    }

    public static final int getDpi(@Nullable Context context) {
        Resources resources;
        int metric = 0;
        Context context2 = context;
        DisplayMetrics metrics = context2 == null ? null : ((resources = context2.getResources()) == null ? null : resources.getDisplayMetrics());
        context2 = metrics;
        if (context2 != null) {
            resources = context2;
            boolean bl = false;
            boolean bl2 = false;
            Resources it = resources;
            boolean bl3 = false;
            metric = (int)(it.density * 160.0f);
        }
        return metric;
    }

    public static final void countDpiAndSteKoef(@Nullable Context context) {
        int currentDpi = APViewUtilsKt.getDpi(context);
        if (currentDpi < 240) {
            APConstantsKt.setBASE_SIZE_MULTIPLIER(1);
            APConstantsKt.setBASE_SIZE_MULTIPLIER(1);
        } else {
            boolean bl = 241 <= currentDpi ? currentDpi <= 320 : false;
            if (bl) {
                APConstantsKt.setBASE_SIZE_MULTIPLIER(2);
                APConstantsKt.setBASE_SIZE_MULTIPLIER(2);
            } else {
                boolean bl2 = 321 <= currentDpi ? currentDpi <= 480 : false;
                if (bl2) {
                    APConstantsKt.setBASE_SIZE_MULTIPLIER(3);
                    APConstantsKt.setBASE_SIZE_MULTIPLIER(3);
                } else if (currentDpi > 480) {
                    APConstantsKt.setBASE_SIZE_MULTIPLIER(4);
                    APConstantsKt.setBASE_SIZE_MULTIPLIER(4);
                }
            }
        }
    }

    @Nullable
    public static final View buildComponentViewByLayer(@NotNull Context context, @NotNull Layer layer, @Nullable APComponentViewModel viewModel) {
        View view;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        APLayer.Type type = layer.getType();
        int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()];
        switch (n) {
            case 1: {
                view = (View)new APBackgroundComponentView(context, APViewUtilsKt.convertToBackgroundComponent(layer.getComponent()), viewModel);
                break;
            }
            case 2: {
                view = (View)new APImageComponentView(context, APViewUtilsKt.convertToImageComponent(layer.getComponent()), viewModel, null, 8, null);
                break;
            }
            case 3: {
                APTextComponentView aPTextComponentView;
                APTextComponent aPTextComponent = APViewUtilsKt.convertToTextComponent(layer.getComponent());
                if (aPTextComponent == null) {
                    aPTextComponentView = null;
                } else {
                    APTextComponent aPTextComponent2 = aPTextComponent;
                    boolean bl = false;
                    boolean bl2 = false;
                    APTextComponent it = aPTextComponent2;
                    boolean bl3 = false;
                    aPTextComponentView = new APTextComponentView(context, it, viewModel);
                }
                view = (View)aPTextComponentView;
                break;
            }
            case 4: {
                view = (View)new APGIFComponentView(context, APViewUtilsKt.convertToGifComponent(layer.getComponent()), viewModel);
                break;
            }
            case 5: {
                APBaseComponentView aPBaseComponentView;
                Layer.Component component = layer.getComponent();
                APPollComponent.Type type2 = component == null ? null : component.getType();
                int n2 = type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                switch (n2) {
                    case 1: {
                        aPBaseComponentView = new APYesNoPollComponentView(context, APViewUtilsKt.convertToPollComponent(layer.getComponent()), viewModel);
                        break;
                    }
                    case 2: {
                        aPBaseComponentView = new APMultipleChoicePollComponentView(context, APViewUtilsKt.convertToPollComponent(layer.getComponent()), viewModel);
                        break;
                    }
                    default: {
                        aPBaseComponentView = null;
                    }
                }
                view = (View)aPBaseComponentView;
                break;
            }
            default: {
                view = null;
            }
        }
        return view;
    }

    private static final APPollComponent convertToPollComponent(Layer.Component component) {
        if (component.getId() != null && component.getType() != null) {
            APPollComponent.Type type = component.getType();
            String string = component.getId();
            return new APPollComponent(string, type);
        }
        return new APPollComponent("", APPollComponent.Type.YES_NO_POLL);
    }

    private static final APBackgroundComponent convertToBackgroundComponent(Layer.Component component) {
        APBackgroundComponent aPBackgroundComponent;
        Object object = component;
        if ((object == null ? null : ((Layer.Component)object).getColor()) != null) {
            object = component.getColor();
            Intrinsics.checkNotNull((Object)object);
            APBackgroundComponent aPBackgroundComponent2 = new APBackgroundComponent((String)object);
            aPBackgroundComponent = aPBackgroundComponent2;
        } else {
            aPBackgroundComponent = new APBackgroundComponent("#ffffff");
        }
        return aPBackgroundComponent;
    }

    private static final APImageComponent convertToImageComponent(Layer.Component component) {
        Layer.Component component2 = component;
        return (component2 == null ? null : component2.getUrl()) != null ? new APImageComponent(component.getUrl(), null, component.getCornerRadius(), component.getLoadingColor()) : new APImageComponent("", null, null, null);
    }

    private static final APTextComponent convertToTextComponent(Layer.Component component) {
        APTextComponent aPTextComponent;
        Serializable serializable = component;
        if ((serializable == null ? null : serializable.getFont()) != null && component.getValue() != null) {
            serializable = component.getFont();
            APTextComponent.APLocale aPLocale = component.getValue();
            aPTextComponent = new APTextComponent(aPLocale, (APFont)serializable);
        } else {
            aPTextComponent = null;
        }
        return aPTextComponent;
    }

    private static final APGIFComponent convertToGifComponent(Layer.Component component) {
        Layer.Component component2 = component;
        return (component2 == null ? null : component2.getUrl()) != null ? new APGIFComponent(component.getUrl(), null, component.getCornerRadius(), component.getLoadingColor()) : new APGIFComponent("", null, null, null);
    }

    public static final void drawStoryOnLayout(@NotNull ConstraintLayout layout2, @NotNull StoryComponent component, @Nullable APComponentViewModelProvider componentViewModelProvider, boolean isSquare) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        layout2.removeAllViews();
        StoryComponent storyComponent = component;
        boolean bl = false;
        boolean bl2 = false;
        StoryComponent it = storyComponent;
        boolean bl3 = false;
        APComponentViewModelProvider aPComponentViewModelProvider = componentViewModelProvider;
        APComponentViewModel viewModel = aPComponentViewModelProvider == null ? null : aPComponentViewModelProvider.getAPComponentViewModel(0);
        String language = APViewUtilsKt.getLanguageFromViewModel(componentViewModelProvider);
        component.getOuterText().setLocale(language);
        if (isSquare) {
            Object object = layout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"layout.context");
            StorySquareComponentView storySquareComponentView = new StorySquareComponentView((Context)object, component, viewModel);
            object = storySquareComponentView;
            boolean bl4 = false;
            boolean bl5 = false;
            Object componentView = object;
            boolean bl6 = false;
            componentView.setId(ViewCompat.generateViewId());
            layout2.addView((View)componentView);
            ConstraintSet componentConstraintSet = new ConstraintSet();
            componentConstraintSet.clone(layout2);
            componentConstraintSet.constrainWidth(componentView.getId(), (int)component.getOuterStyles().getWidth());
            componentConstraintSet.constrainHeight(componentView.getId(), (int)component.getOuterStyles().getHeight());
            componentConstraintSet.applyTo(layout2);
        } else {
            Object object = layout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"layout.context");
            StoryRectComponentView storyRectComponentView = new StoryRectComponentView((Context)object, component, viewModel);
            object = storyRectComponentView;
            boolean bl7 = false;
            boolean bl8 = false;
            Object componentView = object;
            boolean bl9 = false;
            componentView.setId(ViewCompat.generateViewId());
            layout2.addView((View)componentView);
            ConstraintSet componentConstraintSet = new ConstraintSet();
            componentConstraintSet.clone(layout2);
            componentConstraintSet.constrainWidth(componentView.getId(), (int)component.getOuterStyles().getWidth());
            componentConstraintSet.constrainHeight(componentView.getId(), (int)component.getOuterStyles().getHeight());
            componentConstraintSet.applyTo(layout2);
        }
    }

    public static /* synthetic */ void drawStoryOnLayout$default(ConstraintLayout constraintLayout, StoryComponent storyComponent, APComponentViewModelProvider aPComponentViewModelProvider, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        APViewUtilsKt.drawStoryOnLayout(constraintLayout, storyComponent, aPComponentViewModelProvider, bl);
    }

    private static final String getLanguageFromViewModel(APComponentViewModelProvider viewModel) {
        APComponentViewModelProvider aPComponentViewModelProvider = viewModel;
        return aPComponentViewModelProvider instanceof CampaignViewModel ? ((CampaignViewModel)viewModel).getLang() : (aPComponentViewModelProvider instanceof APSnapViewModel ? ((APSnapViewModel)viewModel).getLang() : (aPComponentViewModelProvider instanceof APSplashScreenDialogViewModel ? ((APSplashScreenDialogViewModel)viewModel).getLang() : null));
    }

    public static final void drawCircleStoryOnLayout(@NotNull ConstraintLayout layout2, @NotNull StoryComponent component, @Nullable APComponentViewModelProvider componentViewModelProvider) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        layout2.removeAllViews();
        StoryComponent storyComponent = component;
        boolean bl = false;
        boolean bl2 = false;
        StoryComponent it = storyComponent;
        boolean bl3 = false;
        APComponentViewModelProvider aPComponentViewModelProvider = componentViewModelProvider;
        APComponentViewModel viewModel = aPComponentViewModelProvider == null ? null : aPComponentViewModelProvider.getAPComponentViewModel(0);
        String language = APViewUtilsKt.getLanguageFromViewModel(componentViewModelProvider);
        component.getOuterText().setLocale(language);
        int imgViewId = 0;
        Object object = layout2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"layout.context");
        StoryCircleComponentView storyCircleComponentView = new StoryCircleComponentView((Context)object, component, viewModel);
        object = storyCircleComponentView;
        boolean bl4 = false;
        int n = 0;
        Object componentView = object;
        boolean bl5 = false;
        componentView.setId(ViewCompat.generateViewId());
        imgViewId = componentView.getId();
        layout2.addView((View)componentView);
        ConstraintSet componentConstraintSet = new ConstraintSet();
        componentConstraintSet.clone(layout2);
        componentConstraintSet.constrainWidth(componentView.getId(), (int)component.getOuterStyles().getWidth());
        componentConstraintSet.constrainHeight(componentView.getId(), (int)component.getOuterStyles().getHeight());
        componentConstraintSet.applyTo(layout2);
        if (!component.isBookmark()) {
            int n2;
            double d;
            APOuterStyles.OuterSize outerSize = component.getOuterStyles().getOuterSize();
            n = outerSize == null ? -1 : WhenMappings.$EnumSwitchMapping$2[outerSize.ordinal()];
            switch (n) {
                case 1: {
                    d = StorySizeConst.INSTANCE.getTEXT_SIZE_S();
                    break;
                }
                case 2: {
                    d = StorySizeConst.INSTANCE.getTEXT_SIZE_M();
                    break;
                }
                case 3: {
                    d = StorySizeConst.INSTANCE.getTEXT_SIZE_L();
                    break;
                }
                default: {
                    d = 10.0;
                }
            }
            double textSize = d;
            APFont aPFont = new APFont("Roboto", APFont.Style.BOLD, textSize / (double)APConstantsKt.getBASE_SIZE_MULTIPLIER(), "#000000", APFont.Align.CENTER, 0.0, null);
            Object object2 = component.getOuterText();
            APTextComponent storyTextComponent = new APTextComponent((APTextComponent.APLocale)object2, aPFont);
            object2 = component.getOuterStyles().getOuterSize();
            int n3 = object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$2[((Enum)object2).ordinal()];
            switch (n3) {
                case 1: {
                    n2 = StorySizeConst.INSTANCE.getSTORY_PADDING_TEXT_S();
                    break;
                }
                case 2: {
                    n2 = StorySizeConst.INSTANCE.getSTORY_PADDING_TEXT_M();
                    break;
                }
                case 3: {
                    n2 = StorySizeConst.INSTANCE.getSTORY_PADDING_TEXT_L();
                    break;
                }
                default: {
                    n2 = -66;
                }
            }
            int margin = n2;
            Object object3 = layout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"layout.context");
            object2 = new APTextComponentView((Context)object3, storyTextComponent, viewModel);
            object3 = object2;
            boolean bl6 = false;
            boolean bl7 = false;
            Object componentTextView = object3;
            boolean bl8 = false;
            componentTextView.setId(ViewCompat.generateViewId());
            layout2.addView((View)componentTextView);
            ConstraintSet textComponentConstraintSet = new ConstraintSet();
            textComponentConstraintSet.clone(layout2);
            textComponentConstraintSet.constrainWidth(componentTextView.getId(), (int)component.getOuterStyles().getWidth());
            textComponentConstraintSet.constrainHeight(componentTextView.getId(), (int)component.getOuterStyles().getHeight());
            textComponentConstraintSet.connect(componentTextView.getId(), 4, imgViewId, 4, margin);
            textComponentConstraintSet.applyTo(layout2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawAPLayersOnLayout(@NotNull ConstraintLayout layout2, @NotNull List<APLayer> layers, @Nullable APComponentViewModelProvider componentViewModelProvider) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        layout2.removeAllViews();
        List<APLayer> uniqLayers = APViewUtilsKt.checkImageDublication(layers);
        Iterable $this$forEachIndexed$iv = uniqLayers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void layer;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            APLayer aPLayer = (APLayer)item$iv;
            int index = n;
            boolean bl2 = false;
            APComponentViewModelProvider aPComponentViewModelProvider = componentViewModelProvider;
            APComponentViewModel componentViewModel2 = aPComponentViewModelProvider == null ? null : aPComponentViewModelProvider.getAPComponentViewModel(index);
            String language = APViewUtilsKt.getLanguageFromViewModel(componentViewModelProvider);
            if (layer.getComponent() instanceof APTextComponent) {
                ((APTextComponent)layer.getComponent()).getValue().setLocale(language);
            }
            Context context = layout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"layout.context");
            View view = APViewUtilsKt.buildComponentView(context, (APLayer)layer, componentViewModel2);
            if (view == null) continue;
            context = view;
            boolean bl3 = false;
            boolean bl4 = false;
            Context componentView = context;
            boolean bl5 = false;
            componentView.setId(ViewCompat.generateViewId());
            layout2.addView((View)componentView);
            ConstraintSet componentConstraintSet = new ConstraintSet();
            componentConstraintSet.clone(layout2);
            if (layer.getType() == APLayer.Type.IMAGE && layer.getOptions().getPosition().getWidth() > (double)(375 * APConstantsKt.getBASE_SIZE_MULTIPLIER())) {
                if (layer.getOptions().getPosition().getX() <= 0.0) {
                    componentConstraintSet.connect(componentView.getId(), 6, layout2.getId(), 6, 0);
                } else {
                    componentConstraintSet.connect(componentView.getId(), 6, layout2.getId(), 6, (int)layer.getOptions().getPosition().getX());
                }
                if (layer.getOptions().getPosition().getY() <= 0.0) {
                    componentConstraintSet.connect(componentView.getId(), 3, layout2.getId(), 3, 0);
                } else {
                    componentConstraintSet.connect(componentView.getId(), 3, layout2.getId(), 3, (int)layer.getOptions().getPosition().getY());
                }
            } else {
                componentConstraintSet.connect(componentView.getId(), 6, layout2.getId(), 6, (int)layer.getOptions().getPosition().getX());
                componentConstraintSet.connect(componentView.getId(), 3, layout2.getId(), 3, (int)layer.getOptions().getPosition().getY());
            }
            componentConstraintSet.connect(componentView.getId(), 3, layout2.getId(), 3, (int)layer.getOptions().getPosition().getY());
            if (componentView instanceof APImageComponentView && layer.getOptions().getPosition().getWidth() > (double)(375 * APConstantsKt.getBASE_SIZE_MULTIPLIER())) {
                componentConstraintSet.constrainWidth(((APImageComponentView)componentView).getId(), 375 * APConstantsKt.getBASE_SIZE_MULTIPLIER());
            } else {
                componentConstraintSet.constrainWidth(componentView.getId(), (int)layer.getOptions().getPosition().getWidth());
            }
            if (componentView instanceof APImageComponentView && layer.getOptions().getPosition().getHeight() > (double)(667 * APConstantsKt.getBASE_SIZE_MULTIPLIER())) {
                componentConstraintSet.constrainHeight(((APImageComponentView)componentView).getId(), 667 * APConstantsKt.getBASE_SIZE_MULTIPLIER());
            } else {
                componentConstraintSet.constrainHeight(componentView.getId(), (int)layer.getOptions().getPosition().getWidth());
            }
            if (layer.getType() == APLayer.Type.POLL) {
                componentConstraintSet.constrainHeight(componentView.getId(), -2);
            } else {
                componentConstraintSet.constrainHeight(componentView.getId(), (int)layer.getOptions().getPosition().getHeight());
            }
            componentConstraintSet.setAlpha(componentView.getId(), (float)layer.getOptions().getOpacity());
            componentConstraintSet.setRotation(componentView.getId(), (float)layer.getOptions().getPosition().getAngle());
            componentConstraintSet.applyTo(layout2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<APLayer> checkImageDublication(List<APLayer> layers) {
        ArrayList newLayers = (ArrayList)layers;
        int indexOfBackgroundImage = 0;
        indexOfBackgroundImage = -1;
        int secondIndexOfBackgroundImage = 0;
        secondIndexOfBackgroundImage = -1;
        int count = 0;
        Iterable $this$forEachIndexed$iv = layers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void apLayer;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            APLayer aPLayer = (APLayer)item$iv;
            int index = n;
            boolean bl2 = false;
            if (apLayer.getType() != APLayer.Type.IMAGE || !(apLayer.getOptions().getPosition().getWidth() >= (double)(375 * APConstantsKt.getBASE_SIZE_MULTIPLIER())) || !(apLayer.getOptions().getPosition().getHeight() >= (double)(667 * APConstantsKt.getBASE_SIZE_MULTIPLIER()))) continue;
            if (count == 0) {
                indexOfBackgroundImage = index;
            }
            if (count == 1) {
                secondIndexOfBackgroundImage = index;
            }
            int n2 = count;
            count = n2 + 1;
        }
        if (indexOfBackgroundImage != -1 && count == 2) {
            newLayers.remove(indexOfBackgroundImage);
        }
        if (secondIndexOfBackgroundImage != -1 && count == 3) {
            newLayers.remove(secondIndexOfBackgroundImage);
        }
        return newLayers;
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawLayersOnLayout(@NotNull ConstraintLayout layout2, @NotNull List<Layer> layers, @Nullable APComponentViewModelProvider componentViewModelProvider) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        layout2.removeAllViews();
        Iterable $this$forEachIndexed$iv = layers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            APTextComponent.APLocale aPLocale;
            Serializable serializable;
            void layer;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Layer layer2 = (Layer)item$iv;
            int index = n;
            boolean bl2 = false;
            APComponentViewModelProvider aPComponentViewModelProvider = componentViewModelProvider;
            APComponentViewModel componentViewModel2 = aPComponentViewModelProvider == null ? null : aPComponentViewModelProvider.getAPComponentViewModel(index);
            String language = APViewUtilsKt.getLanguageFromViewModel(componentViewModelProvider);
            if (layer.getType() == APLayer.Type.TEXT) {
                serializable = layer.getComponent();
                APTextComponent.APLocale aPLocale2 = aPLocale = serializable == null ? null : serializable.getValue();
                if (aPLocale != null) {
                    aPLocale.setLocale(language);
                }
            }
            serializable = layout2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"layout.context");
            aPLocale = APViewUtilsKt.buildComponentViewByLayer((Context)serializable, (Layer)layer, componentViewModel2);
            if (aPLocale == null) continue;
            serializable = aPLocale;
            boolean bl3 = false;
            boolean bl4 = false;
            Serializable componentView = serializable;
            boolean bl5 = false;
            componentView.setId(ViewCompat.generateViewId());
            layout2.addView((View)componentView);
            ConstraintSet componentConstraintSet = new ConstraintSet();
            componentConstraintSet.clone(layout2);
            componentConstraintSet.connect(componentView.getId(), 6, layout2.getId(), 6, (int)layer.getOptions().getPosition().getX());
            componentConstraintSet.connect(componentView.getId(), 3, layout2.getId(), 3, (int)layer.getOptions().getPosition().getY());
            componentConstraintSet.constrainWidth(componentView.getId(), (int)layer.getOptions().getPosition().getWidth());
            if (layer.getType() == APLayer.Type.POLL) {
                componentConstraintSet.constrainHeight(componentView.getId(), -2);
            } else {
                componentConstraintSet.constrainHeight(componentView.getId(), (int)layer.getOptions().getPosition().getHeight());
            }
            componentConstraintSet.setAlpha(componentView.getId(), (float)layer.getOptions().getOpacity());
            componentConstraintSet.setRotation(componentView.getId(), (float)layer.getOptions().getPosition().getAngle());
            componentConstraintSet.applyTo(layout2);
        }
    }

    public static final boolean isStoriesDataModelNullOrEmpty(@Nullable APTemplateDataModel dataModel) {
        Object object = dataModel;
        object = object == null ? null : ((APTemplateDataModel)object).getCampaigns();
        boolean bl = false;
        boolean bl2 = false;
        return object == null || object.isEmpty();
    }

    @Nullable
    public static final List<APStory> getAPStoriesList(@Nullable APTemplateDataModel dataModel) {
        List list;
        APTemplateDataModel aPTemplateDataModel = dataModel;
        if (aPTemplateDataModel == null) {
            list = null;
        } else {
            APTemplateDataModel aPTemplateDataModel2 = aPTemplateDataModel;
            boolean bl = false;
            boolean bl2 = false;
            APTemplateDataModel $this$getAPStoriesList_u24lambda_u2d15 = aPTemplateDataModel2;
            boolean bl3 = false;
            boolean bl4 = false;
            List stories = new ArrayList();
            Iterable $this$forEach$iv = $this$getAPStoriesList_u24lambda_u2d15.getCampaigns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Campaign campaign = (Campaign)element$iv;
                boolean bl5 = false;
                Story story = campaign.getBody().getStory();
                if (story == null) continue;
                Story story2 = story;
                boolean bl6 = false;
                boolean bl7 = false;
                Story it = story2;
                boolean bl8 = false;
                stories.add(new APStory(it.getId(), campaign.getId(), ActionUtilsKt.getAPSnapFromSnap(it.getBody().getSnaps())));
            }
            list = stories;
        }
        return list;
    }

    @Nullable
    public static final View buildActionAreaView(@NotNull Context context, @NotNull APSnap.ActionArea actionArea, @Nullable APActionAreaListener actionAreaListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)actionArea, (String)"actionArea");
        APSnap.ActionArea actionArea2 = actionArea;
        return actionArea2 instanceof APSnap.ButtonActionArea ? (View)new APActionAreaButtonView(context, (APSnap.ButtonActionArea)actionArea, actionAreaListener) : null;
    }

    public static final void drawAPSnapActionArea(@NotNull ConstraintLayout layout2, @NotNull APSnap.ActionArea actionArea, @Nullable APActionAreaListener actionAreaListener) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)actionArea, (String)"actionArea");
        layout2.removeAllViews();
        Context context = layout2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"layout.context");
        View view = APViewUtilsKt.buildActionAreaView(context, actionArea, actionAreaListener);
        if (view != null) {
            context = view;
            boolean bl = false;
            boolean bl2 = false;
            Context actionAreaView = context;
            boolean bl3 = false;
            actionAreaView.setId(ViewCompat.generateViewId());
            layout2.addView((View)actionAreaView);
            ConstraintSet constraintSet = new ConstraintSet();
            constraintSet.clone(layout2);
            APSnap.ActionArea actionArea2 = actionArea;
            if (actionArea2 instanceof APSnap.ButtonActionArea) {
                constraintSet.connect(actionAreaView.getId(), 6, layout2.getId(), 6);
                constraintSet.connect(actionAreaView.getId(), 7, layout2.getId(), 7);
                constraintSet.connect(actionAreaView.getId(), 4, layout2.getId(), 4);
                constraintSet.connect(actionAreaView.getId(), 3, layout2.getId(), 3);
            }
            constraintSet.applyTo(layout2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[APPollComponent.Type.values().length];
            nArray[APPollComponent.Type.YES_NO_POLL.ordinal()] = 1;
            nArray[APPollComponent.Type.MULTIPLE_CHOICE_POLL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[APLayer.Type.values().length];
            nArray[APLayer.Type.BACKGROUND.ordinal()] = 1;
            nArray[APLayer.Type.IMAGE.ordinal()] = 2;
            nArray[APLayer.Type.TEXT.ordinal()] = 3;
            nArray[APLayer.Type.GIF.ordinal()] = 4;
            nArray[APLayer.Type.POLL.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[APOuterStyles.OuterSize.values().length];
            nArray[APOuterStyles.OuterSize.S.ordinal()] = 1;
            nArray[APOuterStyles.OuterSize.M.ordinal()] = 2;
            nArray[APOuterStyles.OuterSize.L.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

