/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.models.APFont;
import plus.adaptive.sdk.data.models.APLayer;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.APStory;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.models.actions.APCallPhoneAction;
import plus.adaptive.sdk.data.models.actions.APCustomAction;
import plus.adaptive.sdk.data.models.actions.APOpenWebLinkAction;
import plus.adaptive.sdk.data.models.actions.APSendSMSAction;
import plus.adaptive.sdk.data.models.actions.APShowStoryAction;
import plus.adaptive.sdk.data.models.components.APBackgroundComponent;
import plus.adaptive.sdk.data.models.components.APComponent;
import plus.adaptive.sdk.data.models.components.APGIFComponent;
import plus.adaptive.sdk.data.models.components.APImageComponent;
import plus.adaptive.sdk.data.models.components.APPollComponent;
import plus.adaptive.sdk.data.models.components.APTextComponent;
import plus.adaptive.sdk.data.models.story.Action;
import plus.adaptive.sdk.data.models.story.ActionArea;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.FeedbackComponent;
import plus.adaptive.sdk.data.models.story.Layer;
import plus.adaptive.sdk.data.models.story.Snap;
import plus.adaptive.sdk.data.models.story.Story;
import plus.adaptive.sdk.data.models.story.Text;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002\u001a\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017H\u0000\u001a\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017H\u0000\u001a\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a8\u0006$"}, d2={"createAPStoryFromStory", "Lplus/adaptive/sdk/data/models/APStory;", "story", "Lplus/adaptive/sdk/data/models/story/Story;", "createCallAction", "Lplus/adaptive/sdk/data/models/actions/APCallPhoneAction;", "action", "Lplus/adaptive/sdk/data/models/story/Action;", "createComponent", "Lplus/adaptive/sdk/data/models/components/APComponent;", "layer", "Lplus/adaptive/sdk/data/models/story/Layer;", "createCustomAction", "Lplus/adaptive/sdk/data/models/actions/APCustomAction;", "createSMSAction", "Lplus/adaptive/sdk/data/models/actions/APSendSMSAction;", "createStoryAction", "Lplus/adaptive/sdk/data/models/actions/APAction;", "campaign", "Lplus/adaptive/sdk/data/models/story/Campaign;", "createWebLinkAction", "Lplus/adaptive/sdk/data/models/actions/APOpenWebLinkAction;", "getAPLayersFromLayers", "", "Lplus/adaptive/sdk/data/models/APLayer;", "layers", "getAPSnapFromSnap", "Lplus/adaptive/sdk/data/models/APSnap;", "snaps", "Lplus/adaptive/sdk/data/models/story/Snap;", "getApActions", "actions", "toAPActionArea", "Lplus/adaptive/sdk/data/models/APSnap$ActionArea;", "actionArea", "Lplus/adaptive/sdk/data/models/story/ActionArea;", "sdk_release"})
public final class ActionUtilsKt {
    @Nullable
    public static final APAction createStoryAction(@NotNull Campaign campaign) {
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        APStory story = null;
        Story story2 = campaign.getBody().getStory();
        if (story2 != null) {
            Story story3 = story2;
            boolean bl = false;
            boolean bl2 = false;
            Story it = story3;
            boolean bl3 = false;
            story = ActionUtilsKt.createAPStoryFromStory(it);
        }
        return story != null ? (APAction)new APShowStoryAction(story) : (APAction)null;
    }

    @NotNull
    public static final APStory createAPStoryFromStory(@NotNull Story story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        return new APStory(story.getId(), story.getBody().getCampaignId(), ActionUtilsKt.getAPSnapFromSnap(story.getBody().getSnaps()));
    }

    @NotNull
    public static final List<APSnap> getAPSnapFromSnap(@NotNull List<Snap> snaps) {
        Intrinsics.checkNotNullParameter(snaps, (String)"snaps");
        ArrayList<APSnap> snapList = new ArrayList<APSnap>();
        Iterable $this$forEach$iv = snaps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Snap snap = (Snap)element$iv;
            boolean bl = false;
            String string2 = snap.getId();
            double d = snap.getBody().getWidth();
            double d2 = snap.getBody().getHeight();
            Double d3 = snap.getBody().getActionAreaHeight();
            APSnap.ActionArea actionArea = ActionUtilsKt.toAPActionArea(snap.getBody().getActionArea());
            double d4 = snap.getBody().getShowTime();
            List<APLayer> list = ActionUtilsKt.getAPLayersFromLayers(snap.getBody().getLayers());
            List<FeedbackComponent> list2 = snap.getBody().getFeedbackComponents();
            snapList.add(new APSnap(string2, list, list2, d, d2, d3, actionArea, d4));
        }
        return snapList;
    }

    private static final List<APLayer> getAPLayersFromLayers(List<Layer> layers) {
        ArrayList<APLayer> layerList = new ArrayList<APLayer>();
        Iterable $this$forEach$iv = layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer layer = (Layer)element$iv;
            boolean bl = false;
            layerList.add(new APLayer(layer.getType(), layer.getOptions(), ActionUtilsKt.createComponent(layer)));
        }
        return layerList;
    }

    private static final APComponent createComponent(Layer layer) {
        APComponent component = null;
        Layer.Component component2 = layer.getComponent();
        if (component2 != null) {
            Layer.Component component3 = component2;
            boolean bl = false;
            boolean bl2 = false;
            Layer.Component $this$createComponent_u24lambda_u2d10 = component3;
            boolean bl3 = false;
            APLayer.Type type = layer.getType();
            int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n) {
                case 1: {
                    String string2 = layer.getComponent().getColor();
                    if (string2 == null) break;
                    String string3 = string2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it = string3;
                    boolean bl6 = false;
                    component = new APBackgroundComponent(it);
                    break;
                }
                case 2: {
                    String string4 = layer.getComponent().getUrl();
                    if (string4 == null) break;
                    String string5 = string4;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String it = string5;
                    boolean bl9 = false;
                    component = new APImageComponent(it, null, $this$createComponent_u24lambda_u2d10.getCornerRadius(), $this$createComponent_u24lambda_u2d10.getLoadingColor());
                    break;
                }
                case 3: {
                    String string6 = layer.getComponent().getUrl();
                    if (string6 == null) break;
                    String string7 = string6;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    String it = string7;
                    boolean bl12 = false;
                    component = new APGIFComponent(it, null, $this$createComponent_u24lambda_u2d10.getCornerRadius(), $this$createComponent_u24lambda_u2d10.getLoadingColor());
                    break;
                }
                case 4: {
                    boolean it;
                    APFont aPFont;
                    APFont bigFont = null;
                    APFont aPFont2 = $this$createComponent_u24lambda_u2d10.getFont();
                    if (aPFont2 == null) {
                        aPFont = null;
                    } else {
                        APFont aPFont3;
                        APFont aPFont4 = aPFont2;
                        it = false;
                        boolean bl12 = false;
                        APFont it2 = aPFont4;
                        boolean bl13 = false;
                        aPFont = aPFont3 = new APFont(it2.getFamily(), it2.getStyle(), it2.getSize(), it2.getColor(), it2.getAlign(), it2.getLetterSpacing(), it2.getLineHeight());
                    }
                    Serializable serializable = aPFont;
                    bigFont = serializable == null ? layer.getComponent().getFont() : serializable;
                    serializable = layer.getComponent().getValue();
                    if (serializable == null) break;
                    aPFont2 = serializable;
                    boolean bl14 = false;
                    it = false;
                    APFont it3 = aPFont2;
                    boolean bl15 = false;
                    component = new APTextComponent((APTextComponent.APLocale)((Object)it3), bigFont);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    APPollComponent.Type type2 = layer.getComponent().getType();
                    if (type2 == null) break;
                    APPollComponent.Type type3 = type2;
                    boolean bl16 = false;
                    boolean bl17 = false;
                    APPollComponent.Type $this$createComponent_u24lambda_u2d10_u24lambda_u2d9 = type3;
                    boolean bl18 = false;
                    String string8 = layer.getComponent().getId();
                    if (string8 == null) break;
                    String string9 = string8;
                    boolean bl19 = false;
                    boolean bl20 = false;
                    String it = string9;
                    boolean bl21 = false;
                    component = new APPollComponent(it, $this$createComponent_u24lambda_u2d10_u24lambda_u2d9);
                }
            }
        }
        return component;
    }

    private static final APSnap.ActionArea toAPActionArea(ActionArea actionArea) {
        ActionArea.Body body;
        APSnap.ButtonActionArea area = null;
        ActionArea actionArea2 = actionArea;
        if (actionArea2 != null && (body = actionArea2.getBody()) != null) {
            ActionArea.Body body2 = body;
            boolean bl = false;
            boolean bl2 = false;
            ActionArea.Body it = body2;
            boolean bl3 = false;
            Text text = it.getText();
            List<APAction> list = ActionUtilsKt.getApActions(it.getActions());
            APSnap.ButtonActionArea.Border border = it.getBorder();
            Double d = it.getCornerRadius();
            String string2 = it.getBackgroundColor();
            String string3 = string2 == null ? "#ffffff" : string2;
            area = new APSnap.ButtonActionArea(text, list, d, string3, border);
        }
        return area;
    }

    @NotNull
    public static final List<APAction> getApActions(@Nullable List<Action> actions) {
        ArrayList<Serializable> newAPActions = new ArrayList<Serializable>();
        List<Action> list = actions;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Action action = (Action)element$iv;
                boolean bl = false;
                Action.Type type = action.getType();
                int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()];
                switch (n) {
                    case 1: {
                        newAPActions.add(ActionUtilsKt.createCallAction(action));
                        break;
                    }
                    case 2: {
                        newAPActions.add(ActionUtilsKt.createSMSAction(action));
                        break;
                    }
                    case 3: {
                        newAPActions.add(ActionUtilsKt.createCustomAction(action));
                        break;
                    }
                    case 4: {
                        newAPActions.add(ActionUtilsKt.createWebLinkAction(action));
                    }
                }
            }
        }
        return newAPActions;
    }

    private static final APCustomAction createCustomAction(Action action) {
        return new APCustomAction(action.getName(), action.getParameters());
    }

    private static final APOpenWebLinkAction createWebLinkAction(Action action) {
        APOpenWebLinkAction aPOpenWebLinkAction;
        if (action.getParameters() != null) {
            Object object = action.getParameters();
            Intrinsics.checkNotNull(object);
            String string2 = String.valueOf(((HashMap)object).get("url"));
            object = String.valueOf(action.getParameters().get("isWebView"));
            boolean bl = false;
            APOpenWebLinkAction aPOpenWebLinkAction2 = new APOpenWebLinkAction(string2, Boolean.parseBoolean((String)object));
            aPOpenWebLinkAction = aPOpenWebLinkAction2;
        } else {
            aPOpenWebLinkAction = new APOpenWebLinkAction("", false);
        }
        return aPOpenWebLinkAction;
    }

    private static final APSendSMSAction createSMSAction(Action action) {
        APSendSMSAction aPSendSMSAction;
        if (action.getParameters() != null) {
            HashMap<String, Object> hashMap = action.getParameters();
            Intrinsics.checkNotNull(hashMap);
            String string2 = String.valueOf(hashMap.get("phoneNumber"));
            String string3 = string2 == null ? "" : string2;
            string2 = String.valueOf(action.getParameters().get("message"));
            String string4 = string2 == null ? "" : string2;
            aPSendSMSAction = new APSendSMSAction(string3, string4);
        } else {
            aPSendSMSAction = new APSendSMSAction("", "");
        }
        return aPSendSMSAction;
    }

    private static final APCallPhoneAction createCallAction(Action action) {
        APCallPhoneAction aPCallPhoneAction;
        if (action.getParameters() != null) {
            HashMap<String, Object> hashMap = action.getParameters();
            Intrinsics.checkNotNull(hashMap);
            String string2 = String.valueOf(hashMap.get("phoneNumber"));
            String string3 = string2 == null ? "" : string2;
            aPCallPhoneAction = new APCallPhoneAction(string3);
        } else {
            aPCallPhoneAction = new APCallPhoneAction("");
        }
        return aPCallPhoneAction;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[APLayer.Type.values().length];
            nArray[APLayer.Type.BACKGROUND.ordinal()] = 1;
            nArray[APLayer.Type.IMAGE.ordinal()] = 2;
            nArray[APLayer.Type.GIF.ordinal()] = 3;
            nArray[APLayer.Type.TEXT.ordinal()] = 4;
            nArray[APLayer.Type.BUTTON.ordinal()] = 5;
            nArray[APLayer.Type.POLL.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Action.Type.values().length];
            nArray[Action.Type.CALL.ordinal()] = 1;
            nArray[Action.Type.SEND_SMS.ordinal()] = 2;
            nArray[Action.Type.CUSTOM.ordinal()] = 3;
            nArray[Action.Type.OPEN_WEB_LINK.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

