/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.models.APLayer;
import plus.adaptive.sdk.data.models.APSnap;
import plus.adaptive.sdk.data.models.actions.APAction;
import plus.adaptive.sdk.data.models.actions.APCallPhoneAction;
import plus.adaptive.sdk.data.models.actions.APCustomAction;
import plus.adaptive.sdk.data.models.actions.APOpenWebLinkAction;
import plus.adaptive.sdk.data.models.actions.APSendSMSAction;
import plus.adaptive.sdk.data.models.components.APBackgroundComponent;
import plus.adaptive.sdk.data.models.components.APComponent;
import plus.adaptive.sdk.data.models.components.APGIFComponent;
import plus.adaptive.sdk.data.models.components.APImageComponent;
import plus.adaptive.sdk.data.models.components.APPollComponent;
import plus.adaptive.sdk.data.models.components.APTextComponent;
import plus.adaptive.sdk.data.models.story.APBookmarkSnapList;
import plus.adaptive.sdk.data.models.story.APOuterStyles;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.models.story.Action;
import plus.adaptive.sdk.data.models.story.ActionArea;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.FeedbackComponent;
import plus.adaptive.sdk.data.models.story.Layer;
import plus.adaptive.sdk.data.models.story.Snap;
import plus.adaptive.sdk.data.models.story.Story;
import plus.adaptive.sdk.data.models.story.Text;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0012H\u0000\u00a8\u0006$"}, d2={"createAPBody", "Lplus/adaptive/sdk/data/models/story/Campaign$APBody;", "dataModel", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "bookmark", "Lplus/adaptive/sdk/data/models/story/APBookmarkSnapList;", "createActionArea", "Lplus/adaptive/sdk/data/models/story/ActionArea;", "actionArea", "Lplus/adaptive/sdk/data/models/APSnap$ActionArea;", "createActionAreaBody", "Lplus/adaptive/sdk/data/models/story/ActionArea$Body;", "createActionsFromApAction", "", "Lplus/adaptive/sdk/data/models/story/Action;", "actions", "Lplus/adaptive/sdk/data/models/actions/APAction;", "createCampaignForBookmarks", "Lplus/adaptive/sdk/data/models/story/Campaign;", "createComponent", "Lplus/adaptive/sdk/data/models/story/Layer$Component;", "layer", "Lplus/adaptive/sdk/data/models/APLayer;", "createLayers", "Lplus/adaptive/sdk/data/models/story/Layer;", "layers", "createSnapFromApSnap", "Lplus/adaptive/sdk/data/models/story/Snap;", "oldSnapModel", "Lplus/adaptive/sdk/data/models/APSnap;", "createStoryBody", "Lplus/adaptive/sdk/data/models/story/Story$Body;", "removeOrSwapBookmarkCampaign", "Ljava/util/ArrayList;", "campaignList", "bookmarkCampaign", "sdk_release"})
public final class BookmarkUtilsKt {
    @NotNull
    public static final Campaign createCampaignForBookmarks(@NotNull APTemplateDataModel dataModel, @NotNull APBookmarkSnapList bookmark) {
        Intrinsics.checkNotNullParameter((Object)dataModel, (String)"dataModel");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        String string = Intrinsics.stringPlus((String)dataModel.getId(), (Object)"book_mark_snaps");
        Campaign.Status status = Campaign.Status.ACTIVE;
        Campaign.APBody aPBody = BookmarkUtilsKt.createAPBody(dataModel, bookmark);
        return new Campaign(string, "", aPBody, status, 1000, true);
    }

    private static final Campaign.APBody createAPBody(APTemplateDataModel dataModel, APBookmarkSnapList bookmark) {
        Story story = new Story(Intrinsics.stringPlus((String)dataModel.getId(), (Object)"storyId"), "", BookmarkUtilsKt.createStoryBody(dataModel, bookmark), false);
        return new Campaign.APBody(null, story, null, null);
    }

    private static final Story.Body createStoryBody(APTemplateDataModel dataModel, APBookmarkSnapList bookmark) {
        String string = Intrinsics.stringPlus((String)dataModel.getId(), (Object)"campaignbook_mark_snaps");
        APTextComponent.APLocale aPLocale = new APTextComponent.APLocale("", "", "");
        APOuterStyles aPOuterStyles = dataModel.getOptions().getOuterStyles();
        ArrayList<Snap> arrayList = bookmark.getSnaps();
        return new Story.Body(string, (List<Snap>)arrayList, aPLocale, "", aPOuterStyles, "");
    }

    @NotNull
    public static final Snap createSnapFromApSnap(@NotNull APSnap oldSnapModel) {
        Intrinsics.checkNotNullParameter((Object)oldSnapModel, (String)"oldSnapModel");
        String string = oldSnapModel.getId();
        List<FeedbackComponent> list = oldSnapModel.getFeedbackComponents();
        List<Layer> list2 = BookmarkUtilsKt.createLayers(oldSnapModel.getLayers());
        double d = oldSnapModel.getWidth();
        double d2 = oldSnapModel.getHeight();
        Double d3 = oldSnapModel.getActionAreaHeight();
        ActionArea actionArea = BookmarkUtilsKt.createActionArea(oldSnapModel.getActionArea());
        double d4 = oldSnapModel.getShowTime();
        Snap.Body body = new Snap.Body(list2, list, d, d2, d3, actionArea, d4);
        return new Snap(string, "", body, null);
    }

    private static final List<Layer> createLayers(List<APLayer> layers) {
        ArrayList<Layer> newLayers = new ArrayList<Layer>();
        Iterable $this$forEach$iv = layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            APLayer it = (APLayer)element$iv;
            boolean bl = false;
            newLayers.add(new Layer(it.getType(), it.getOptions(), BookmarkUtilsKt.createComponent(it)));
        }
        return newLayers;
    }

    private static final Layer.Component createComponent(APLayer layer) {
        Layer.Component component = null;
        APLayer.Type type = layer.getType();
        int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 1: {
                APComponent aPComponent = layer.getComponent();
                if (aPComponent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.APBackgroundComponent");
                }
                component = new Layer.Component(null, ((APBackgroundComponent)aPComponent).getColor(), null, null, null, null, null, null, null, null, null, 2045, null);
                break;
            }
            case 2: {
                APComponent aPComponent = layer.getComponent();
                if (aPComponent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.APImageComponent");
                }
                component = new Layer.Component(null, null, ((APImageComponent)aPComponent).getUrl(), null, null, null, null, null, null, ((APImageComponent)layer.getComponent()).getCornerRadius(), ((APImageComponent)layer.getComponent()).getLoadingColor(), 507, null);
                break;
            }
            case 3: {
                APComponent aPComponent = layer.getComponent();
                if (aPComponent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.APTextComponent");
                }
                component = new Layer.Component(null, null, null, null, null, null, ((APTextComponent)aPComponent).getValue(), ((APTextComponent)layer.getComponent()).getFont(), null, null, null, 1855, null);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                APComponent aPComponent = layer.getComponent();
                if (aPComponent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.APGIFComponent");
                }
                component = new Layer.Component(null, null, ((APGIFComponent)aPComponent).getUrl(), null, null, null, null, null, null, ((APGIFComponent)layer.getComponent()).getCornerRadius(), ((APGIFComponent)layer.getComponent()).getLoadingColor(), 507, null);
                break;
            }
            case 6: {
                Object object = layer.getComponent();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.components.APPollComponent");
                }
                APPollComponent.Type type2 = ((APPollComponent)object).getType();
                object = ((APPollComponent)layer.getComponent()).getId();
                component = new Layer.Component((String)object, null, null, type2, null, null, null, null, null, null, null, 2038, null);
            }
        }
        return component;
    }

    private static final ActionArea createActionArea(APSnap.ActionArea actionArea) {
        return new ActionArea(ActionArea.Type.BUTTON, BookmarkUtilsKt.createActionAreaBody(actionArea));
    }

    private static final ActionArea.Body createActionAreaBody(APSnap.ActionArea actionArea) {
        ActionArea.Body body;
        APSnap.ActionArea actionArea2 = actionArea;
        if (actionArea2 == null) {
            body = null;
        } else {
            ActionArea.Body body2;
            APSnap.ActionArea actionArea3 = actionArea2;
            boolean bl = false;
            boolean bl2 = false;
            APSnap.ActionArea it = actionArea3;
            boolean bl3 = false;
            if (actionArea == null) {
                throw new NullPointerException("null cannot be cast to non-null type plus.adaptive.sdk.data.models.APSnap.ButtonActionArea");
            }
            APSnap.ButtonActionArea.Border border = ((APSnap.ButtonActionArea)actionArea).getBorder();
            Double d = ((APSnap.ButtonActionArea)actionArea).getCornerRadius();
            String string = ((APSnap.ButtonActionArea)actionArea).getBackgroundColor();
            Text text = ((APSnap.ButtonActionArea)actionArea).getText();
            List<Action> list = BookmarkUtilsKt.createActionsFromApAction(((APSnap.ButtonActionArea)actionArea).getActions());
            body = body2 = new ActionArea.Body(text, list, d, string, border);
        }
        return body;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Action> createActionsFromApAction(List<? extends APAction> actions) {
        ArrayList<Object> newActions = new ArrayList<Object>();
        List<? extends APAction> list = actions;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HashMap<String, Object> $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d4;
                Action action;
                Unit unit;
                HashMap<String, Object> $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d2;
                Action.Type type;
                boolean bl;
                boolean bl2;
                Object object;
                APAction apAction = (APAction)element$iv;
                boolean bl3 = false;
                Object object2 = apAction;
                if (object2 instanceof APSendSMSAction) {
                    object = new HashMap<String, Object>();
                    bl2 = false;
                    bl = false;
                    HashMap<String, Object> hashMap = object;
                    type = Action.Type.SHOW_STORY;
                    boolean bl4 = false;
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d2.put("phoneNumber", ((APSendSMSAction)apAction).getPhoneNumber());
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d2.put("message", ((APSendSMSAction)apAction).getMessage());
                    unit = Unit.INSTANCE;
                    String string = Action.Type.SHOW_STORY.name();
                    Object object3 = object;
                    Action.Type type2 = type;
                    action = new Action(type2, (HashMap<String, Object>)object3, string);
                } else if (object2 instanceof APOpenWebLinkAction) {
                    object = new HashMap();
                    bl2 = false;
                    bl = false;
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d2 = object;
                    type = Action.Type.OPEN_WEB_LINK;
                    boolean bl5 = false;
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d4.put("url", ((APOpenWebLinkAction)apAction).getUrl());
                    Boolean bl6 = ((APOpenWebLinkAction)apAction).isWebView();
                    if (bl6 != null) {
                        Boolean bl7 = bl6;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        boolean isweb = bl7;
                        boolean bl10 = false;
                        $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d4.put("isWebView", isweb);
                    }
                    unit = Unit.INSTANCE;
                    String string = Action.Type.OPEN_WEB_LINK.name();
                    Object object4 = object;
                    Action.Type type3 = type;
                    action = new Action(type3, (HashMap<String, Object>)object4, string);
                } else if (object2 instanceof APCallPhoneAction) {
                    void $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d5;
                    object = new HashMap();
                    bl2 = false;
                    bl = false;
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d4 = object;
                    type = Action.Type.CALL;
                    boolean bl11 = false;
                    $this$createActionsFromApAction_u24lambda_u2d7_u24lambda_u2d5.put("phoneNumber", ((APCallPhoneAction)apAction).getPhoneNumber());
                    unit = Unit.INSTANCE;
                    String string = Action.Type.CALL.name();
                    Object object5 = object;
                    Action.Type type4 = type;
                    action = new Action(type4, (HashMap<String, Object>)object5, string);
                } else {
                    action = object2 instanceof APCustomAction ? new Action(Action.Type.CUSTOM, ((APCustomAction)apAction).getParameters(), ((APCustomAction)apAction).getName()) : (Action)null;
                }
                Action action2 = action;
                object2 = action2;
                if (object2 == null) continue;
                object = object2;
                bl2 = false;
                bl = false;
                Object it = object;
                boolean bl12 = false;
                newActions.add(it);
            }
        }
        return newActions;
    }

    @NotNull
    public static final ArrayList<Campaign> removeOrSwapBookmarkCampaign(@NotNull ArrayList<Campaign> campaignList, @Nullable Campaign bookmarkCampaign) {
        Campaign campaign;
        Intrinsics.checkNotNullParameter(campaignList, (String)"campaignList");
        boolean hasBookmark = false;
        Iterable $this$forEach$iv = campaignList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Campaign campaign2 = (Campaign)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)campaign2.isBookmarkCampaign(), (Object)true)) continue;
            hasBookmark = true;
        }
        if (hasBookmark) {
            campaignList.remove(campaignList.size() - 1);
        }
        if ((campaign = bookmarkCampaign) != null) {
            Campaign campaign3 = campaign;
            boolean bl = false;
            boolean bl2 = false;
            Campaign it = campaign3;
            boolean bl3 = false;
            campaignList.add(it);
        }
        return campaignList;
    }

    public static /* synthetic */ ArrayList removeOrSwapBookmarkCampaign$default(ArrayList arrayList, Campaign campaign, int n, Object object) {
        if ((n & 2) != 0) {
            campaign = null;
        }
        return BookmarkUtilsKt.removeOrSwapBookmarkCampaign(arrayList, campaign);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[APLayer.Type.values().length];
            nArray[APLayer.Type.BACKGROUND.ordinal()] = 1;
            nArray[APLayer.Type.IMAGE.ordinal()] = 2;
            nArray[APLayer.Type.TEXT.ordinal()] = 3;
            nArray[APLayer.Type.BUTTON.ordinal()] = 4;
            nArray[APLayer.Type.GIF.ordinal()] = 5;
            nArray[APLayer.Type.POLL.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

