/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.Html;
import android.text.Spanned;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.R;
import plus.adaptive.sdk.data.models.APFont;
import plus.adaptive.sdk.utils.CustomTagHandler;
import plus.adaptive.sdk.utils.QueryBuilder;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0000\u001aS\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\b0\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"apFontMap", "", "", "Landroid/graphics/Typeface;", "processHtmlText", "Landroid/text/Spanned;", "htmlStr", "requestFontDownload", "", "context", "Landroid/content/Context;", "familyName", "fontStyle", "Lplus/adaptive/sdk/data/models/APFont$Style;", "onSuccess", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "typeface", "onError", "Lkotlin/Function0;", "sdk_release"})
public final class TextUtilsKt {
    @NotNull
    private static final Map<String, Typeface> apFontMap;

    @NotNull
    public static final Spanned processHtmlText(@NotNull String htmlStr) {
        Spanned spanned;
        Intrinsics.checkNotNullParameter((Object)htmlStr, (String)"htmlStr");
        String myHtmlStr = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)htmlStr, (String)"<ul", (String)"<s10s-ul", (boolean)false, (int)4, null), (String)"</ul>", (String)"</s10s-ul>", (boolean)false, (int)4, null), (String)"<ol", (String)"<s10s-ol", (boolean)false, (int)4, null), (String)"</ol>", (String)"</s10s-ol>", (boolean)false, (int)4, null), (String)"<li", (String)"<s10s-li", (boolean)false, (int)4, null), (String)"</li>", (String)"</s10s-li>", (boolean)false, (int)4, null), (String)"\n", (String)"<br/>", (boolean)false, (int)4, null);
        if (Build.VERSION.SDK_INT >= 24) {
            Spanned spanned2 = Html.fromHtml((String)myHtmlStr, (int)0, null, (Html.TagHandler)new CustomTagHandler());
            Intrinsics.checkNotNullExpressionValue((Object)spanned2, (String)"{\n        Html.fromHtml(myHtmlStr, Html.FROM_HTML_MODE_LEGACY, null, CustomTagHandler())\n    }");
            spanned = spanned2;
        } else {
            Spanned spanned3 = Html.fromHtml((String)myHtmlStr, null, (Html.TagHandler)new CustomTagHandler());
            Intrinsics.checkNotNullExpressionValue((Object)spanned3, (String)"{\n        Html.fromHtml(myHtmlStr, null, CustomTagHandler())\n    }");
            spanned = spanned3;
        }
        return spanned;
    }

    public static final void requestFontDownload(@NotNull Context context, @NotNull String familyName, @Nullable APFont.Style fontStyle, @NotNull Function1<? super Typeface, Unit> onSuccess, @NotNull Function0<Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        String fontMapKey = familyName + ':' + (Object)((Object)fontStyle);
        Typeface typeface = apFontMap.get(fontMapKey);
        if (typeface != null) {
            Typeface typeface2 = typeface;
            boolean bl = false;
            boolean bl2 = false;
            Typeface it = typeface2;
            boolean bl3 = false;
            onSuccess.invoke((Object)it);
            return;
        }
        QueryBuilder queryBuilder = new QueryBuilder(familyName, fontStyle);
        String query = queryBuilder.build();
        FontRequest request = new FontRequest("com.google.android.gms.fonts", "com.google.android.gms", query, R.array.com_google_android_gms_fonts_certs);
        FontsContractCompat.FontRequestCallback callback2 = new FontsContractCompat.FontRequestCallback(fontMapKey, onSuccess, onError){
            final /* synthetic */ String $fontMapKey;
            final /* synthetic */ Function1<Typeface, Unit> $onSuccess;
            final /* synthetic */ Function0<Unit> $onError;
            {
                this.$fontMapKey = $fontMapKey;
                this.$onSuccess = $onSuccess;
                this.$onError = $onError;
            }

            public void onTypefaceRetrieved(@NotNull Typeface typeface) {
                Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
                Map map = TextUtilsKt.access$getApFontMap$p();
                String string2 = this.$fontMapKey;
                boolean bl = false;
                map.put(string2, typeface);
                this.$onSuccess.invoke((Object)typeface);
            }

            public void onTypefaceRequestFailed(int reason) {
                this.$onError.invoke();
            }
        };
        HandlerThread handlerThread = new HandlerThread("fonts");
        handlerThread.start();
        Handler mHandler = new Handler(handlerThread.getLooper());
        FontsContractCompat.requestFont((Context)context, (FontRequest)request, (FontsContractCompat.FontRequestCallback)callback2, (Handler)mHandler);
    }

    public static final /* synthetic */ Map access$getApFontMap$p() {
        return apFontMap;
    }

    static {
        boolean bl = false;
        apFontMap = new LinkedHashMap();
    }
}

