/*
 * Decompiled with CFR 0.152.
 */
package plus.adaptive.sdk.utils;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.adaptive.sdk.data.models.story.APTemplateDataModel;
import plus.adaptive.sdk.data.models.story.Campaign;
import plus.adaptive.sdk.data.models.story.TemplateType;
import plus.adaptive.sdk.data.models.story.TemplateViewType;
import plus.adaptive.sdk.data.models.story.TemplateViewlessType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0005H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0005H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0006H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0005H\u0000\u00a8\u0006\r"}, d2={"isViewVisibleToUser", "", "view", "Landroid/view/View;", "getFirstCampaign", "Lplus/adaptive/sdk/data/models/story/Campaign;", "Lplus/adaptive/sdk/data/models/story/APTemplateDataModel;", "getType", "Lplus/adaptive/sdk/data/models/story/TemplateType;", "getViewType", "Lplus/adaptive/sdk/data/models/story/TemplateViewType;", "getViewlessType", "Lplus/adaptive/sdk/data/models/story/TemplateViewlessType;", "sdk_release"})
public final class ViewUtilsKt {
    public static final boolean isViewVisibleToUser(@NotNull View view) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        try {
            AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain();
            view.onInitializeAccessibilityNodeInfo(nodeInfo);
            boolean result = nodeInfo.isVisibleToUser();
            nodeInfo.recycle();
            bl = result;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final TemplateType getType(@NotNull APTemplateDataModel $this$getType) {
        Intrinsics.checkNotNullParameter((Object)$this$getType, (String)"<this>");
        TemplateType resultType = TemplateType.EMPTY;
        Collection collection = $this$getType.getCampaigns();
        boolean bl = false;
        if (!collection.isEmpty()) {
            resultType = ViewUtilsKt.getType($this$getType.getCampaigns().get(0));
        }
        return resultType;
    }

    @NotNull
    public static final TemplateType getType(@NotNull Campaign $this$getType) {
        Intrinsics.checkNotNullParameter((Object)$this$getType, (String)"<this>");
        TemplateType resultType = TemplateType.EMPTY;
        resultType = $this$getType.getBody().getBanner() != null ? TemplateType.BANNER : ($this$getType.getBody().getStory() != null ? TemplateType.STORY : ($this$getType.getBody().getInstruction() != null ? TemplateType.INSTRUCTION : TemplateType.EMPTY));
        return resultType;
    }

    @NotNull
    public static final TemplateViewType getViewType(@NotNull APTemplateDataModel $this$getViewType) {
        Intrinsics.checkNotNullParameter((Object)$this$getViewType, (String)"<this>");
        TemplateViewType resultType = TemplateViewType.EMPTY;
        Collection collection = $this$getViewType.getCampaigns();
        boolean bl = false;
        if (!collection.isEmpty()) {
            resultType = ViewUtilsKt.getViewType($this$getViewType.getCampaigns().get(0));
        }
        return resultType;
    }

    @NotNull
    public static final TemplateViewType getViewType(@NotNull Campaign $this$getViewType) {
        Intrinsics.checkNotNullParameter((Object)$this$getViewType, (String)"<this>");
        TemplateViewType resultType = TemplateViewType.EMPTY;
        resultType = $this$getViewType.getBody().getBanner() != null ? TemplateViewType.BANNER : ($this$getViewType.getBody().getStory() != null ? TemplateViewType.STORY : TemplateViewType.EMPTY);
        return resultType;
    }

    @NotNull
    public static final TemplateViewlessType getViewlessType(@NotNull APTemplateDataModel $this$getViewlessType) {
        Intrinsics.checkNotNullParameter((Object)$this$getViewlessType, (String)"<this>");
        TemplateViewlessType resultType = TemplateViewlessType.EMPTY;
        Collection collection = $this$getViewlessType.getCampaigns();
        boolean bl = false;
        if (!collection.isEmpty()) {
            resultType = ViewUtilsKt.getViewlessType($this$getViewlessType.getCampaigns().get(0));
        }
        return resultType;
    }

    @NotNull
    public static final TemplateViewlessType getViewlessType(@NotNull Campaign $this$getViewlessType) {
        Intrinsics.checkNotNullParameter((Object)$this$getViewlessType, (String)"<this>");
        TemplateViewlessType resultType = TemplateViewlessType.EMPTY;
        resultType = $this$getViewlessType.getBody().getInstruction() != null ? TemplateViewlessType.INSTRUCTION : ($this$getViewlessType.getBody().getPopup() != null ? TemplateViewlessType.POPUP : TemplateViewlessType.EMPTY);
        return resultType;
    }

    @Nullable
    public static final Campaign getFirstCampaign(@NotNull APTemplateDataModel $this$getFirstCampaign) {
        Intrinsics.checkNotNullParameter((Object)$this$getFirstCampaign, (String)"<this>");
        Collection collection = $this$getFirstCampaign.getCampaigns();
        boolean bl = false;
        return !collection.isEmpty() ? $this$getFirstCampaign.getCampaigns().get(0) : (Campaign)null;
    }
}

