/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.github.pengfeizhou.jscore.JSONBuilder;
import java.io.EOFException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.json.JSONObject;
import pub.doric.Doric;
import pub.doric.DoricContext;
import pub.doric.DoricContextManager;
import pub.doric.DoricSingleton;
import pub.doric.IDoricMonitor;
import pub.doric.devkit.DoricContextDebuggable;
import pub.doric.devkit.DoricDebugDriver;
import pub.doric.devkit.DoricDevMonitor;
import pub.doric.devkit.DoricDevPerformanceAnchorHook;
import pub.doric.devkit.WSClient;
import pub.doric.devkit.ui.DoricDevActivity;
import pub.doric.devkit.util.SimulatorUtil;
import pub.doric.performance.DoricPerformanceProfile;
import pub.doric.utils.DoricLog;

public class DoricDev {
    private final Set<StatusCallback> callbacks = new HashSet<StatusCallback>();
    private final WeakHashMap<String, DoricContext> reloadingContexts = new WeakHashMap();
    public final boolean isRunningInEmulator;
    private final Handler uiHandler = new Handler(Looper.getMainLooper());
    private WSClient wsClient;
    private boolean devKitConnected = false;
    private DoricContextDebuggable debuggable;
    private String url;

    private DoricDev() {
        this.isRunningInEmulator = SimulatorUtil.isSimulator((Context)Doric.application());
        DoricSingleton.getInstance().getNativeDriver().getRegistry().registerMonitor((IDoricMonitor)new DoricDevMonitor());
        DoricSingleton.getInstance().getNativeDriver().getRegistry().setGlobalPerformanceAnchorHook((DoricPerformanceProfile.GlobalAnchorHook)new DoricDevPerformanceAnchorHook());
    }

    public static DoricDev getInstance() {
        return Inner.sInstance;
    }

    public void openDevMode() {
        Intent intent = new Intent((Context)Doric.application(), DoricDevActivity.class);
        intent.setFlags(0x10000000);
        Doric.application().startActivity(intent);
    }

    public void closeDevMode() {
        this.stopDebugging(true);
        if (this.wsClient != null) {
            this.wsClient.close();
            this.wsClient = null;
        }
    }

    public boolean isInDevMode() {
        return this.devKitConnected;
    }

    public void addStatusCallback(StatusCallback listener) {
        this.callbacks.add(listener);
    }

    public void removeStatusCallback(StatusCallback listener) {
        this.callbacks.remove(listener);
    }

    public void connectDevKit(String url) {
        if (this.wsClient != null) {
            this.wsClient.close();
        }
        this.devKitConnected = false;
        this.wsClient = new WSClient(url);
        this.url = url;
    }

    public String getIP() {
        if (this.url != null) {
            return this.url.replace("ws://", "").replace(":7777", "");
        }
        return "0.0.0.0";
    }

    public void sendDevCommand(String command, JSONObject jsonObject) {
        this.wsClient.sendToServer(command, jsonObject);
    }

    public void startDebugging(String source) {
        List<DoricContext> contexts;
        if (this.debuggable != null) {
            this.debuggable.stopDebug(true);
        }
        if ((contexts = this.matchAllContext(source)).size() <= 0) {
            DoricLog.d((String)"Cannot find  context source %s for debugging", (Object[])new Object[]{source});
            this.wsClient.sendToDebugger("DEBUG_STOP", new JSONBuilder().put("msg", (Object)"Cannot find suitable alive context for debugging").toJSONObject());
        } else {
            final DoricContext context = contexts.get(contexts.size() - 1);
            this.wsClient.sendToDebugger("DEBUG_RES", new JSONBuilder().put("contextId", (Object)context.getContextId()).toJSONObject());
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    DoricDev.this.debuggable = new DoricContextDebuggable(DoricDev.this.wsClient, context);
                    DoricDev.this.debuggable.startDebug();
                    for (StatusCallback callback : DoricDev.this.callbacks) {
                        callback.onStartDebugging(context);
                    }
                }
            });
        }
    }

    public void requestDebugging(DoricContext context) {
        this.wsClient.sendToServer("DEBUG", new JSONBuilder().put("source", (Object)context.getSource()).put("script", (Object)context.getScript()).toJSONObject());
    }

    public void stopDebugging(final boolean resume) {
        this.wsClient.sendToDebugger("DEBUG_STOP", new JSONBuilder().put("msg", (Object)"Stop debugging").toJSONObject());
        if (this.debuggable != null) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    DoricDev.this.debuggable.stopDebug(resume);
                    DoricDev.this.debuggable = null;
                    for (StatusCallback callback : DoricDev.this.callbacks) {
                        callback.onStopDebugging();
                    }
                }
            });
        }
    }

    public void onOpen() {
        this.devKitConnected = true;
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)Doric.application(), (CharSequence)"dev kit connected", (int)1).show();
                for (StatusCallback callback : DoricDev.this.callbacks) {
                    callback.onOpen(DoricDev.this.url);
                }
            }
        });
    }

    public void onClose() {
        this.devKitConnected = false;
        this.stopDebugging(true);
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                for (StatusCallback callback : DoricDev.this.callbacks) {
                    callback.onClose(DoricDev.this.url);
                }
            }
        });
    }

    public void onFailure(final Throwable t) {
        this.devKitConnected = false;
        this.stopDebugging(true);
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (t instanceof EOFException) {
                    Toast.makeText((Context)Doric.application(), (CharSequence)"Devkit lost connection", (int)1).show();
                } else if (t instanceof ConnectException) {
                    Toast.makeText((Context)Doric.application(), (CharSequence)("Devkit connect to " + DoricDev.this.getIP() + " failed"), (int)1).show();
                } else {
                    Toast.makeText((Context)Doric.application(), (CharSequence)("Devkit connect fail:" + t.getLocalizedMessage()), (int)1).show();
                }
                for (StatusCallback callback : DoricDev.this.callbacks) {
                    callback.onFailure(t);
                }
            }
        });
    }

    private List<DoricContext> matchAllContext(String source) {
        ArrayList<DoricContext> list = new ArrayList<DoricContext>();
        source = source.replace(".js", "").replace(".ts", "");
        for (DoricContext context : DoricContextManager.aliveContexts()) {
            String doricSource = context.getSource().replace(".js", "").replace(".ts", "");
            if (!source.equals(doricSource) && !doricSource.equals("__dev__")) continue;
            list.add(context);
        }
        return list;
    }

    public void reload(String source, final String script) {
        List<DoricContext> contexts = this.matchAllContext(source);
        if (contexts.size() <= 0) {
            DoricLog.d((String)"Cannot find context source %s for reload", (Object[])new Object[]{source});
        } else {
            for (final DoricContext context : contexts) {
                if (context.getDriver() instanceof DoricDebugDriver) {
                    DoricLog.d((String)"Context source %s in debugging,skip reload", (Object[])new Object[]{source});
                    continue;
                }
                DoricLog.d((String)"Context reload :id %s,source %s ", (Object[])new Object[]{context.getContextId(), source});
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        context.reload(script);
                        if (DoricDev.this.reloadingContexts.get(context.getContextId()) == null) {
                            DoricDev.this.reloadingContexts.put(context.getContextId(), context);
                        }
                        for (StatusCallback callback : DoricDev.this.callbacks) {
                            callback.onReload(context, script);
                        }
                    }
                });
            }
        }
    }

    public boolean isReloadingContext(DoricContext context) {
        return this.reloadingContexts.get(context.getContextId()) != null;
    }

    private static class Inner {
        private static final DoricDev sInstance = new DoricDev();

        private Inner() {
        }
    }

    public static interface StatusCallback {
        public void onOpen(String var1);

        public void onClose(String var1);

        public void onFailure(Throwable var1);

        public void onReload(DoricContext var1, String var2);

        public void onStartDebugging(DoricContext var1);

        public void onStopDebugging();
    }
}

