/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit;

import com.github.pengfeizhou.jscore.JSONBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONException;
import org.json.JSONObject;
import pub.doric.devkit.DoricDev;

public class WSClient
extends WebSocketListener {
    private final WebSocket webSocket;
    private final Set<Interceptor> interceptors = new HashSet<Interceptor>();

    public WSClient(String url) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        this.webSocket = okHttpClient.newWebSocket(request, (WebSocketListener)this);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    public void close() {
        this.webSocket.close(1000, "Close");
    }

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        DoricDev.getInstance().onOpen();
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        try {
            String source;
            JSONObject jsonObject = new JSONObject(text);
            String type = jsonObject.optString("type");
            String cmd = jsonObject.optString("cmd");
            JSONObject payload = jsonObject.optJSONObject("payload");
            for (Interceptor interceptor : this.interceptors) {
                if (!interceptor.intercept(type, cmd, payload)) continue;
                return;
            }
            if ("DEBUG_REQ".equals(cmd)) {
                source = payload.optString("source");
                DoricDev.getInstance().startDebugging(source);
            } else if ("DEBUG_STOP".equals(cmd)) {
                DoricDev.getInstance().stopDebugging(true);
            } else if ("RELOAD".equals(cmd)) {
                source = payload.optString("source");
                String script = payload.optString("script");
                DoricDev.getInstance().reload(source, script);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        DoricDev.getInstance().onClose();
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        super.onFailure(webSocket, t, response);
        DoricDev.getInstance().onFailure(t);
    }

    public void sendToDebugger(String command, JSONObject payload) {
        this.webSocket.send(new JSONBuilder().put("type", (Object)"C2D").put("cmd", (Object)command).put("payload", (Object)payload).toString());
    }

    public void sendToServer(String command, JSONObject payload) {
        this.webSocket.send(new JSONBuilder().put("type", (Object)"C2S").put("cmd", (Object)command).put("payload", (Object)payload).toString());
    }

    public static interface Interceptor {
        public boolean intercept(String var1, String var2, JSONObject var3) throws JSONException;
    }
}

