/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.devkit.qrcode.activity;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Hashtable;
import java.util.Vector;
import pub.doric.devkit.qrcode.activity.CaptureFragment;
import pub.doric.devkit.qrcode.camera.BitmapLuminanceSource;
import pub.doric.devkit.qrcode.camera.CameraManager;
import pub.doric.devkit.qrcode.decoding.DecodeFormatManager;

public class CodeUtils {
    public static final String RESULT_TYPE = "result_type";
    public static final String RESULT_STRING = "result_string";
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_FAILED = 2;
    public static final String LAYOUT_ID = "layout_id";

    public static void analyzeBitmap(String path, AnalyzeCallback analyzeCallback) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap mBitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        int sampleSize = (int)((float)options.outHeight / 400.0f);
        if (sampleSize <= 0) {
            sampleSize = 1;
        }
        options.inSampleSize = sampleSize;
        mBitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        Hashtable hints = new Hashtable(2);
        Vector<BarcodeFormat> decodeFormats = new Vector<BarcodeFormat>();
        if (decodeFormats == null || decodeFormats.isEmpty()) {
            decodeFormats = new Vector();
            decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        multiFormatReader.setHints(hints);
        Result rawResult = null;
        try {
            rawResult = multiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BitmapLuminanceSource(mBitmap))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rawResult != null) {
            if (analyzeCallback != null) {
                analyzeCallback.onAnalyzeSuccess(mBitmap, rawResult.getText());
            }
        } else if (analyzeCallback != null) {
            analyzeCallback.onAnalyzeFailed();
        }
    }

    public static Bitmap createImage(String text, int w, int h, Bitmap logo) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            Bitmap scaleLogo = CodeUtils.getScaleLogo(logo, w, h);
            int offsetX = w / 2;
            int offsetY = h / 2;
            int scaleWidth = 0;
            int scaleHeight = 0;
            if (scaleLogo != null) {
                scaleWidth = scaleLogo.getWidth();
                scaleHeight = scaleLogo.getHeight();
                offsetX = (w - scaleWidth) / 2;
                offsetY = (h - scaleHeight) / 2;
            }
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, w, h, hints);
            int[] pixels = new int[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    if (x >= offsetX && x < offsetX + scaleWidth && y >= offsetY && y < offsetY + scaleHeight) {
                        int pixel = scaleLogo.getPixel(x - offsetX, y - offsetY);
                        if (pixel == 0) {
                            pixel = bitMatrix.get(x, y) ? -16777216 : -1;
                        }
                        pixels[y * w + x] = pixel;
                        continue;
                    }
                    pixels[y * w + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
            return bitmap;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap getScaleLogo(Bitmap logo, int w, int h) {
        if (logo == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        float scaleFactor = Math.min((float)w * 1.0f / 5.0f / (float)logo.getWidth(), (float)h * 1.0f / 5.0f / (float)logo.getHeight());
        matrix.postScale(scaleFactor, scaleFactor);
        Bitmap result = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
        return result;
    }

    public static void setFragmentArgs(CaptureFragment captureFragment, int layoutId) {
        if (captureFragment == null || layoutId == -1) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt(LAYOUT_ID, layoutId);
        captureFragment.setArguments(bundle);
    }

    public static void isLightEnable(boolean isEnable) {
        if (isEnable) {
            Camera camera = CameraManager.get().getCamera();
            if (camera != null) {
                Camera.Parameters parameter = camera.getParameters();
                parameter.setFlashMode("torch");
                camera.setParameters(parameter);
            }
        } else {
            Camera camera = CameraManager.get().getCamera();
            if (camera != null) {
                Camera.Parameters parameter = camera.getParameters();
                parameter.setFlashMode("off");
                camera.setParameters(parameter);
            }
        }
    }

    public static interface AnalyzeCallback {
        public void onAnalyzeSuccess(Bitmap var1, String var2);

        public void onAnalyzeFailed();
    }
}

